/**
 * tp_gpio_bulk_sens.h
 *
 * A sensor for multiple gpio pins of a gpio-device.
 * Note that this is quite simple, currently. We support 1 gpio-dev
 * only and allow masking but not shuffling its pins. If you are looking
 * for this kind of functionality have a look into GpioMultiSens
 * 
 * (c) 2005 Peppercon AG, 2005/11/23, thomas@peppercon.de
 */

 
#ifndef _PP_BMC_TP_GPIO_BULK_SENS_H_
#define _PP_BMC_TP_GPIO_BULK_SENS_H_

#include <pp/bmc/tp_gpio_dev.h>
#include <pp/bmc/tp_sensdev.h>
#include <pp/bmc/topo_factory.h>

typedef struct pp_tp_gpio_bulk_sens_s pp_tp_gpio_bulk_sens_t;

struct pp_tp_gpio_bulk_sens_s {
    pp_tp_sensdev_t base;
    
    /* the gpio this object belongs to */
    pp_tp_gpio_dev_t* gpio_dev;

    /* mask of valid gpio taken form gpio dev */
    unsigned int gpio_mask;
    
    /* gpio_subscriber interface */
    pp_tp_gpio_subscriber_t gpio_subs;

    /* some sensor info */
    unsigned char sens_type;
    unsigned char reading_type;
};

/* ppdoc
 * name:   GPIO Bulk Sensor
 * tpname: GpioBulkSens
 * desc:   A sensor for multiple gpio pins of a gpio device. This is a special
 * desc:   sensor that combines several GPIO signal readings in one sensor. This
 * desc:   reading can then be exported through an IPMI sensor. All signals must
 * desc:   be within one gpio device and can be masked but not shuffled.
 * desc:   See also: GpioMultiSens
 * arg 0:  [OBJ (GPIO_DEV)] gpiodev: GPIO dev to use
 * arg 1:  [INT] mask:         gpio-mask, mask of gpio that will be read
 * arg 1:                      all other will be read in as zero
 * arg 2:  [INT] sensortype:   sensor type, as per spec
 * arg 3:  [INT] readingtype:  reading type, as per spec
 * arg 4:  [INT] entityid:     entity id, as per spec
 * arg 5:  [INT] entityinst:   entity instance, as per spec
 * return: [OBJ(GPIO_BULK_SENS)]
 */
pp_tp_obj_t* pp_tp_gpio_bulk_sens_ctor(const char* id, vector_t* args);

static inline pp_tp_gpio_bulk_sens_t*
pp_tp_gpio_bulk_sens_duplicate(pp_tp_gpio_bulk_sens_t* this) {
    return (pp_tp_gpio_bulk_sens_t*)pp_tp_obj_duplicate((pp_tp_obj_t*)this);
}

static inline void
pp_tp_gpio_bulk_sens_release(pp_tp_gpio_bulk_sens_t* this) {
    pp_tp_obj_release((pp_tp_obj_t*)this);
}

static inline int
pp_tp_gpio_bulk_sens_get_reading(pp_tp_gpio_bulk_sens_t* this) {
    return pp_tp_sensdev_get_reading(&this->base);
}

static inline void
pp_tp_gpio_bulk_sens_subscribe(pp_tp_gpio_bulk_sens_t* this,
			       pp_tp_sensdev_subscriber_t* subs) {
    pp_bmc_tp_sensdev_subscribe(&this->base, subs);
}

static inline int
pp_tp_gpio_bulk_sens_unsubscribe(pp_tp_gpio_bulk_sens_t* this,
				 pp_tp_sensdev_subscriber_t* subs) {
    return pp_bmc_tp_sensdev_unsubscribe(&this->base, subs);
}

static inline void
pp_tp_gpio_bulk_sens_notify_subscribers(pp_tp_gpio_bulk_sens_t* this,
					int reading) {
    pp_bmc_tp_sensdev_notify_subscribers(&this->base, reading);
}


#endif /* _PP_BMC_TP_GPIO_BULK_SENS_H */
