/**
 * tp_gpio_multi_sens.h
 *
 * A sensor for a collection of concrete gpio input signals
 * 
 * (c) 2005 Peppercon AG, Ronald Wahl <rwa@peppercon.de>
 */
 
#ifndef _PP_BMC_TP_GPIO_MULTI_SENS_H
#define _PP_BMC_TP_GPIO_MULTI_SENS_H

#include <pp/bmc/tp_sensdev.h>
#include <pp/bmc/tp_gpio_dev.h>
#include <pp/bmc/topo_factory.h>

/**
 * concrete multi gpio signal input sensor
 */
typedef struct {
    pp_tp_sensdev_t base;

    /* the GPIOs and its subscribers */
    vector_t * gpios;
    vector_t * gpio_subscribers;

    /* the current cached value of the GPIOs */
    int value_pending;

    /* debounce time in milliseconds, 0 means 'disabled' */
    int debounce;

    /* select handler for debouncing */
    int debounce_hdl;

} pp_tp_gpio_multi_sens_t;

/* ppdoc
 * name:   GPIO multi sensor
 * tpname: GpioMultiSens
 * desc:   A sensor that combines multiple gpio readings in one value.
 * arg 0:  [INT] debounce: Debounce time
 * arg 1:  [OBJ(GPIO_SENS)] sens1: GPIO sensor to read
 * arg 2:  [...]:                  (optional, repeatable) argument 1 can be
 * arg 2:                          repeated to add more gpio sensors
 * return: [OBJ(GPIO_MULTI_SENS)]
 */
pp_tp_obj_t* pp_tp_gpio_multi_sens_ctor(const char* id, vector_t* args);

void pp_tp_gpio_multi_sens_dtor(pp_tp_obj_t* this);

int pp_tp_gpio_multi_sens_init(pp_tp_gpio_multi_sens_t* this,
			       pp_tp_obj_type_t type, const char* id,
			       pp_tp_obj_dtor_func_t dtor,
			       pp_tp_sensdev_default_sdr_func_t default_sdr,
			       vector_t* gpios, int debounce);

void pp_tp_gpio_multi_sens_cleanup(pp_tp_gpio_multi_sens_t* sensor_mux);

static inline pp_tp_gpio_multi_sens_t*
pp_tp_gpio_multi_sens_duplicate(pp_tp_gpio_multi_sens_t* this)
{
    return (pp_tp_gpio_multi_sens_t*)pp_tp_obj_duplicate((pp_tp_obj_t*)this);
}

static inline void
pp_tp_gpio_multi_sens_release(pp_tp_gpio_multi_sens_t* this)
{
    pp_tp_obj_release((pp_tp_obj_t*)this);
}

#endif /* _PP_BMC_TP_GPIO_MULTI_SENS_H */
