/**
 * tp_i2c_alive_cond.h
 *
 * Tests whether i2c address is alive on the given bus
 * 
 * (c) 2005 Peppercon AG, 2005/11/4, tbr@peppecon.de
 */

#ifndef _PP_BMC_TP_I2C_ALIVE_COND_H__
#define _PP_BMC_TP_I2C_ALIVE_COND_H__

#include <pp/bmc/tp_cond.h>

/* ppdoc
 * name:   I2C alive condition
 * tpname: I2CAliveCond
 * desc:   Continously checks whether the specified i2c target address is
 * desc:   alive (readable) or not.
 * arg 0:  [OBJ(I2C_COM_DEV)] i2cdev: i2c device to use
 * arg 1:  [INT] i2c_addr:            i2c address to check
 * return: [OBJ(COND)]
 */
pp_tp_obj_t* pp_tp_i2c_alive_cond_ctor(const char* id, vector_t* args);

#endif /* _PP_BMC_TP_I2C_ALIVE_COND_H__ */
