/**
 * tp_muxed_scanner.h
 *
 * Scans registered sensors periodically per bank before
 * it switches the mux to the next bank and timeouts before
 * scanning again.
 * 
 * (c) 2006 Peppercon AG, mkl@peppercon.de
 */


#ifndef __PP_BMC_TP_MUXED_SCANNER_H__
#define __PP_BMC_TP_MUXED_SCANNER_H__

#include <pp/bmc/tp_scan_sensdev.h>
#include <pp/bmc/tp_gpio_multi_act.h>

typedef struct {
    pp_tp_obj_t base;

    /* gpio mux where sensors are connected grouped in banks */
    pp_tp_gpio_multi_act_t* gpio_act;
    /* delay between bank switch and bank read */
    int delay;
    /* contains a vector with sensors and a bank address per entry */
    vector_t *sensor_banks;
    /* current selected bank number */
    u_int current_bank;
    /* handle to scanner select function */
    int scanner_hndl;
} pp_tp_muxed_scanner_t;

/* ppdoc
 * name:   Muxed Scanner
 * tpname: MuxedScanner
 * desc:   Scans registered sensors periodically per bank before
 * desc:   switching the mux to the next bank. Then waiting for timeout
 * desc:   before scanning the new selected bank.
 * arg 1:  [OBJ(GPIO_MULTI_ACT)] mux: This mux is switched before reading the next bank
 * arg 2:  [INT] delay_time:        Time to wait before reading the selected bank after switching
 * arg 3:  [...]:                   (optional, repeatable) arguments 1..n (INT, ...)
 * arg 3:                           one argument for each available bank, specifies the
 * arg 3:                           mux value for this bank.
 * return: [OBJ(MUXED_CTRL)]
 */
pp_tp_obj_t* pp_tp_muxed_scanner_ctor(const char* id, vector_t* args);

/*
 * Called by TachSens instances to register itself on one sensor bank 
 */
int pp_tp_muxed_scanner_register(pp_tp_scan_sensdev_t* s, pp_tp_muxed_scanner_t *this, u_int bank_num);

static inline pp_tp_muxed_scanner_t*
pp_tp_muxed_scanner_duplicate(pp_tp_muxed_scanner_t* this) {
    return (pp_tp_muxed_scanner_t*)pp_tp_obj_duplicate((pp_tp_obj_t*)this);
}

static inline void pp_tp_muxed_scanner_release(pp_tp_muxed_scanner_t* this) {
    pp_tp_obj_release((pp_tp_obj_t*)this);
}

#endif /* __PP_BMC_TP_MUXED_SCANNER_H__ */
