/**
 * tp_and_cond.c
 *
 * combines two random conditions by logical AND operation
 * TODO: could be extended to support more than 2 cond's
 * 
 * (c) 2006 Peppercon AG, 2006/04/05, rgue@peppecon.de
 */

#include <pp/bmc/debug.h>
#include <pp/bmc/topo_factory.h>
#include <pp/bmc/tp_and_cond.h>

struct pp_tp_and_cond_s {
    pp_tp_cond_t base;
    pp_tp_cond_t* c1;
    pp_tp_cond_t* c2;
    pp_tp_sensdev_subscriber_t subs;
};
typedef struct pp_tp_and_cond_s pp_tp_and_cond_t;

static void and_cond_dtor(pp_tp_obj_t* o);
static void and_cond_recv_reading(pp_tp_sensdev_subscriber_t* s, 
				  pp_tp_sensdev_t* source, int reading);

pp_tp_obj_t* pp_tp_and_cond_ctor(const char* id, vector_t* args)
{
    const char* errmsg = "[AndCond] '%s' failed (%s)";
    pp_strstream_t err = PP_STRSTREAM_INITIALIZER;
    pp_tp_and_cond_t* this = NULL;
    pp_tp_cond_t *c1, *c2;

    if (pp_tp_arg_scanf(args, 0, &err, "o<sc>o<sc>", &c1, &c2) != 2)
    {
	pp_bmc_log_error(errmsg, id, pp_strstream_buf(&err));
	goto bail;
    }

    this = malloc(sizeof(pp_tp_and_cond_t));
    pp_tp_cond_init(&this->base, PP_TP_COND, id, and_cond_dtor);
    this->c1 = pp_tp_cond_duplicate(c1);
    this->c2 = pp_tp_cond_duplicate(c2);
    this->subs.recv_reading = and_cond_recv_reading;
    pp_tp_cond_subscribe(this->c1, &this->subs);
    pp_tp_cond_subscribe(this->c2, &this->subs);
    
 bail:
    pp_strstream_free(&err);
    return (pp_tp_obj_t*)this;
}

static void and_cond_dtor(pp_tp_obj_t* o)
{
    assert(o);
    pp_tp_and_cond_t* this = (pp_tp_and_cond_t*)o;
    pp_tp_cond_unsubscribe(this->c2, &this->subs);
    pp_tp_cond_unsubscribe(this->c1, &this->subs);
    pp_tp_cond_release(this->c2);
    pp_tp_cond_release(this->c1);
    pp_tp_cond_cleanup(&this->base);
    free(o);
}

static void and_cond_recv_reading(pp_tp_sensdev_subscriber_t* s, 
				  pp_tp_sensdev_t* source UNUSED, int reading UNUSED)
{
    pp_tp_and_cond_t* this = PP_TP_INTF_2_OBJ_CAST(s, pp_tp_and_cond_t, subs);

    unsigned char new = pp_tp_cond_get_reading(this->c1) 
                     && pp_tp_cond_get_reading(this->c2); // do the AND

    // set new value and notify subscribers
    pp_tp_cond_set_reading(&this->base, new);
}

