/**
 * tp_i2c_comdev.c
 *
 * Defines an abstract i2c communication device.
 * Can be mapped to i2c-busses, muxes, ...
 * 
 * (c) 2005 Peppercon AG, 3/9/2005, tbr@peppecon.de
 */

#include <pp/base.h>
#include <pp/bmc/tp_i2c_comdev.h>


/**
 * Initialize a pp_tp_i2c_comdev_t.
 */
void pp_tp_i2c_comdev_init(pp_tp_i2c_comdev_t* d,
                           pp_tp_obj_type_t type,
                           const char* id,
                           void (*dtor)(pp_tp_obj_t*),
			   int (*root_handle)(pp_tp_i2c_comdev_t* dev),
                           int (*pre_com)(pp_tp_i2c_comdev_t*, unsigned char),
                           int (*post_com)(pp_tp_i2c_comdev_t*, unsigned char),
                           int (*rx_byte)(pp_tp_i2c_comdev_t*,
                                               unsigned char,
                                               unsigned char*),
                           int (*tx_byte)(pp_tp_i2c_comdev_t*,
                                               unsigned char,
                                               unsigned char),
                           int (*rx_byte_data)(pp_tp_i2c_comdev_t*,
                                               unsigned char,
                                               unsigned char,
                                               unsigned char*),
                           int (*tx_byte_data)(pp_tp_i2c_comdev_t*,
                                               unsigned char,
                                               unsigned char,
                                               unsigned char),
                            int (*rx_word_data)(pp_tp_i2c_comdev_t*,
				                   unsigned char,
				                   unsigned char,
				                   unsigned short*),
				 int (*tx_word_data)(pp_tp_i2c_comdev_t*,
                                               unsigned char,
                                               unsigned char,
                                               unsigned short))
{
    pp_tp_obj_init((pp_tp_obj_t*)d, type, id, dtor);
    d->root_handle = root_handle;
    d->pre_com = pre_com;
    d->post_com = post_com;
    d->rx_byte = rx_byte;
    d->tx_byte = tx_byte;
    d->rx_byte_data = rx_byte_data;
    d->tx_byte_data = tx_byte_data;
    d->rx_word_data = rx_word_data;
    d->tx_word_data = tx_word_data;
	
}

