/**
 * tp_rs485_chip.c
 *
 * Interface for chip having rs485 interface and
 * register bank access interface.
 *
 * (c) 2006 Peppercon AG, 2006/09/05 tbr@raritan.com
 */

#include <pp/base.h>
#include <pp/bmc/tp_rs485_chip.h>

typedef struct reg_subsc_s {
    pp_tp_reg_subscriber_t* subsc;
    unsigned char addr;
} reg_subsc_t;

static reg_subsc_t*
reg_subsc_create(pp_tp_reg_subscriber_t* subsc, unsigned char addr) {
    reg_subsc_t* o = malloc(sizeof(reg_subsc_t));
    o->subsc = subsc;
    o->addr = addr;
    return o;
}

void pp_tp_rs485_chip_init(pp_tp_rs485_chip_t* this,
			   pp_tp_obj_type_t type,
			   const char* id,
			   void (*dtor)(pp_tp_obj_t*),
			   const char* model,
			   pp_tp_rs485_comdev_t* rs485dev,
			   unsigned char rs485addr,
			   int (*get_byte)(pp_tp_rs485_chip_t*,
					   unsigned char, unsigned char*),
			   int (*set_byte)(pp_tp_rs485_chip_t*,
					   unsigned char, unsigned char),
			   int (*fwupdate)(pp_tp_rs485_chip_t*,
					   const char* data, size_t len)) {
    pp_tp_obj_init((pp_tp_obj_t*)this, type, id, dtor);
    this->model = model;
    this->rs485dev = pp_tp_rs485_comdev_duplicate(rs485dev);
    this->rs485addr = rs485addr;
    this->get_byte = get_byte;
    this->set_byte = set_byte;
    this->fwupdate = fwupdate;
    this->reg_subscribers = vector_new(NULL, 0, free);
}

void pp_tp_rs485_chip_cleanup(pp_tp_rs485_chip_t* this) {
    vector_delete(this->reg_subscribers);
    pp_tp_rs485_comdev_release(this->rs485dev);
    pp_tp_obj_cleanup((pp_tp_obj_t*)this);
}

void pp_tp_rs485_chip_register(pp_tp_rs485_chip_t* this,
			      pp_tp_reg_subscriber_t* subsc,
			      unsigned char addr) {
    reg_subsc_t* s = reg_subsc_create(subsc, addr);
    vector_add(this->reg_subscribers, s);
}

int pp_tp_rs485_chip_unregister(pp_tp_rs485_chip_t* this,
				pp_tp_reg_subscriber_t* subsc) {
    size_t i;
    int ret;
    reg_subsc_t* s;

    /* a single subscriber might be subscribed a couple of times *
     * for different addresses, so remove all occasions          */
    for (i = 0, ret = 0; i < vector_size(this->reg_subscribers); ++i) {
	s = vector_get(this->reg_subscribers, i);
	if (s->subsc == subsc) {
	    vector_remove(this->reg_subscribers, i);
	    --i;
	    ++ret;
	}
    }
    return ret;
}

void pp_tp_rs485_chip_notify_subscribers(pp_tp_rs485_chip_t* this,
					 unsigned char addr,
					 unsigned char val) {
    size_t i, sz;
    reg_subsc_t* s;

    sz = vector_size(this->reg_subscribers);
    for (i = 0; i < sz; ++i) {
	s = vector_get(this->reg_subscribers, i);
	if (s->addr == addr) {
	    s->subsc->reg_changed(s->subsc, addr, val);
	}
    }
}

