/**
 * tp_rs485_comdev.h
 *
 * abstract RS485 communication object
 *
 * (c) 2006 Peppercon AG, 2006/09/05 tbr@raritan.com
 */

#include <pp/bmc/tp_rs485_comdev.h>

void pp_tp_rs485_comdev_init(pp_tp_rs485_comdev_t* this,
			     pp_tp_obj_type_t type,
			     const char* id,
			     void (*dtor)(pp_tp_obj_t*),
			     int  (*read_data)(pp_tp_rs485_comdev_t* this,
					       unsigned char rs485addr,
					       unsigned char addr,
					       unsigned char len,
					       unsigned char* buf),
			     int  (*write_data)(pp_tp_rs485_comdev_t* this,
						unsigned char rs485addr,
						unsigned char addr,
						unsigned char len,
						unsigned char* buf),
			     int (*write_fwupd)(pp_tp_rs485_comdev_t* this,
						unsigned char rs485addr,
						const char* buf,
						unsigned char len,
						int timeout)) {
    pp_tp_obj_init((pp_tp_obj_t*)this, type, id, dtor);
    this->write_data = write_data;
    this->read_data = read_data;
    this->write_fwupd = write_fwupd;
}
