/**
 * serial_snoop.h
 *
 * (c) 2005 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 *
 * This file implements a serial handler for snooping the
 * connection while the serial client is connected to the
 * host (smux=host_chassis)
 */

#ifndef __SERIAL_SNOOP_H__
#define __SERIAL_SNOOP_H__

/** 
 * Init the serial snoop adapter
 */
int pp_serial_snoop_init(void);

/** 
 * Cleanup the serial snoop adapter
 */
void pp_serial_snoop_cleanup(void);

/**
 * Set a new channel access mode for the serial channel.
 * This also affects snooping.
 */
void bmc_serial_snoop_set_access_mode(unsigned char access_mode);

/**
 * Set the serial filedescriptor for snooping. This filedescriptor will
 * only be used if a switch from the serial_adapter to serial_snoop takes
 * place. Take care, calling this function while serial_snoop is activated
 * can mess up internal structures.
 */
void bmc_serial_snoop_set_fd(int serial_fd);

#endif

