#!/bin/bash
#
# command line tool for issueing RPC-OEM-Commands
#
# tbr@peppercon.de
#

# pls. change if needed
############################
USER=admin
PASSWD=pass
############################

HELP_MESSAGE="Usage:\n\t`basename $0` <host> <command> <parameter>\n\
where:\n\
<host> \t hostname or ip address of PDU
<command> can be:\n\
\t set_power_on_delay: \t minimum time between switch on of recepticles\n\
\t get_power_on_delay: \n\
\t set_receptacle_state: \t<arg1:[4-2]branch,[1-0]receptacle> <arg2:[0]state\n\
\t get_receptacle_state: \t<arg1:[4-2]branch,[1-0]receptacle>\n\
\t <more to come here>: \t ...\n"

#if [ $# -ne 3 ] ; then
#   echo -e "$HELP_MESSAGE" >&2
#    exit 1
#fi

HOST=$1

case $2 in
    set_power_on_delay) 
	CMD=0x10
	OPT=$3
	CMDLINE="ipmitool -H $HOST -U $USER -P $PASSWD raw 0x3c $CMD $OPT"
	;;
    get_power_on_delay)
	CMD=0x11
	CMDLINE="ipmitool -H $HOST -U $USER -P $PASSWD raw 0x3c $CMD"
	;;
    set_receptacle_state)
	CMD=0x12
	OPT=$3
	OPT1=$4
	CMDLINE="ipmitool -H $HOST -U $USER -P $PASSWD raw 0x3c $CMD $OPT $OPT1"
	;;
    get_receptacle_state) 
	CMD=0x13
	OPT=$3
	CMDLINE="ipmitool -H $HOST -U $USER -P $PASSWD raw 0x3c $CMD $OPT"
	;;
    *)
	echo -e "$HELP_MESSAGE" >&2
	exit 1
	;;
esac

echo $CMDLINE

eval $CMDLINE || exit 1
