#
# !/usr/bin/env python
#
# (C) 2005 Peppercon AG, Zwickau (Sachs)
# Frank Hofmann <fho@peppercon.de>
#
# Python-Script zur Umwandlung von c-Funktionskommentaren nach Peppercon DocBook
#
# Version 0.0.7 (2005-05-23)


#ppDoc:		('^\s*/\*[\t ]*[Pp][Pp][Dd][Oo][Cc]')
#name:		('^\s*\*\s*[Nn][Aa][Mm][Ee]')
#tpname:	('^\s*\*\s*[Tt][Pp][Nn][Aa][Mm][Ee]')
#desc:		('\s*\*\s*[Dd][Ee][Ss][Cc]')
#type:		('\[ *\S+[ *| *\S+]*\]')
#arg:		('\s*\*\s*[Aa][Rr][Gg][\t ]*[1-9]*')
#return:	('\s*\*\s*[Rr][Ee][Tt][Uu][Rr][Nn]')
#End of ppdoc:	('\s*\*/')

#TODO sortierung der Blocks

import sys
import sys
import xml.dom.minidom
import string
import os
import re
from time import strftime

import xmldtc
import standard

# init global variables
pathParts = ""
copyrightVersion = "comment2docbook 0.0.7 (2005-05-23)"
copyrightOwner = "(C) 2005 Peppercon AG, Zwickau (Sachs)"

ppTab = re.compile('\t')
ppBlank = re.compile(' ')

# the positions of the sums of the records
docs = 0
names = docs + 1 
descs = names + 1 
args = descs + 1
rets = args + 1 
tp = rets+1
# the beginning of the actual records
first = tp + 1
docPos = first 
namePos = docPos + 1
descPos = namePos + 1 
argPos = descPos + 1 
retPos = argPos + 1 
tpPos = retPos + 1 
# argDesPos is a list of extra description lines in the argument list
# the item of this list has the form: [[...], [...]]
# the position of the item corresponds to the arg_no
argDesPos = tpPos + 1

# macros
def getDoc(doc):
	"Retrieve the ppdoc item"
	ppDoc = re.compile('^\s*/\*[\t ]*[Pp][Pp][Dd][Oo][Cc]')
	if doc:
		d = ppDoc.match(doc)
		return d
	else:
		return ""

def endDoc(doc):
	"Retrieve the */ item"
	ppEnd = re.compile('\s*\*/')
	if doc:
		d = ppEnd.match(doc)
		if d:
			return d
		else:			
			return ""
	else:
		return ""

def getTP(doc):
	"Retrieve the topology name"
	ppTP = re.compile('^\s*\*\s*[Tt][Pp][Nn][Aa][Mm][Ee]')
	if doc:
		d = ppTP.match(doc)
		return d
	else:
		return ""

def getName(doc):
	"Retrieve the name item"
	ppName = re.compile('^\s*\*\s*[Nn][Aa][Mm][Ee]')
	if doc:
		d = ppName.match(doc)
		return d
	else:
		return ""

def getType(doc):
	"Retrieve the type item"
	ppType = re.compile('\[ *\S+[ *| *\S+]*\]')
	ppBlank = re.compile(' ')

	if doc:
		d = ppType.search(doc)
		# remove blanks
		if d == None:
			print "Count not get Type"
			return ""

		d = ppBlank.sub('', d.group())
		return d
	else:
		return ""

def getArg(doc):
	"Retrieve the argument list"
	ppArg = re.compile('\s*\*\s*[Aa][Rr][Gg][\t ]*[1-9]*')
	if doc:
		d = ppArg.match(doc)
		return d
	else:
		return ""

def getReturn(doc):
	"Retrieve the return item"
	ppReturn = re.compile('\s*\*\s*[Rr][Ee][Tt][Uu][Rr][Nn]')
	if doc:
		d = ppReturn.match(doc)
		return d
	else:
		return ""

def getDes(doc):
	"Retrieve the description item"
	if doc:
		ppDes = re.compile('\s*\*\s*[Dd][Ee][Ss][Cc]')
		d = ppDes.match(doc)
		return d
	else:
		return ""

def splitComment(doc):
	"Retrieve a whole comment line"
	ppTab = re.compile('\t')

	# the whole comment record
	#'(' and ')' are used because of the operation of groups
	ppComment = re.compile('[\S+((\t| )*\S+)*]+((\t| )*:[\S+((\t| )*\S+)*]+)*')

	if doc:
		ppGroups = ppComment.match(doc)
		# split the line into records, and substitute tabs with blanks
		ppRecords = re.split(':\s*', ppTab.sub(' ', ppGroups.group(0)))
		return ppRecords
	else:
		return ""

def verify(sourceFile):
	"check existance of the given source file"

	if (os.path.isfile(sourceFile)):
		return
	else:
		print "given source file not found (", sourceFile, ")"
		sys.exit(1)
	# end if

	return


def extractBlocks(collectedComments, dir, inputFiles):
	"check the input file and extract the PPDOC blocks, we assume that the file was verified"

	print "Accessing the directory: " + dir

	for inputFile in inputFiles:
		# get full path name relative to  where program is run; the
		# function os.path.join() adds the proper delimiter for the os
		print "Accessing the file: " + inputFile
		inputFile = os.path.join(dir, inputFile)
		if os.path.islink(inputFile): continue 
		if os.path.isfile(inputFile): 

			# get the basename of the file
			inputFileName = os.path.basename(inputFile)
			# access only the header files
			hFileName = re.match('(\s|\S)*.h$', inputFileName)
			if hFileName == None:
				#print inputFileName + "------------ignored"
				continue
			#else:
				#print "Accessing: " + inputFileName

			# load input file into buffer
			inputFileContent = standard.readFileContent(inputFile)

			if(inputFileContent == []):
				break	

			# discover comments
			commentMode = 0		# not in a comment

			for currentLine in inputFileContent:
				if (commentMode == 0):
					d = getDoc(currentLine)
					if d:
						commentMode = 1
						currentComment = []
						currentComment.append(currentLine)
				else:
					currentComment.append(currentLine)
					d = endDoc(currentLine)
					if d:
						commentMode = 0
						localBin = [0,0,0,0,0,0,[],[],[],[],[],[],[]] 
						for rec in currentComment: 
							rec = re.sub('\n|\t', '', rec)
							if getDoc(rec): 
								ppRec = re.split(':\s*',rec) 
								#pop away the key words 
								ppRec.pop(0)
								localBin[docPos].append(ppRec)
								localBin[docs] += 1

							if getName(rec):
								ppRec = re.split(':\s*',rec)
								ppRec.pop(0)
								localBin[namePos].append(ppRec)
								localBin[names] += 1

							if getDes(rec):
								ppRec = re.split(':\s*',rec)
								ppRec.pop(0)
								localBin[descPos].append(ppRec)
								localBin[descs] += 1

							if getArg(rec):
								t = getType(rec)
								ppRec = re.split(':\s*', rec)
								ppRec.pop(0)
								if t:
									localBin[argPos].append([ppRec[0]])
									localBin[argDesPos].append([])

									# the arg has description
									if len(ppRec) >= 2:
										# the descriptions will be dumped to an array belongs to the 
										# current arg
										for pos in range(1,len(ppRec)):
											localBin[argDesPos][localBin[args]].append([ppRec[pos]])

									localBin[args] += 1
								else:
									# the descriptions will be dumped to an array belongs to the 
									# current arg
									for pos in range(0,len(ppRec)):
										print localBin[args]
										localBin[argDesPos][localBin[args]-1].append([ppRec[pos]])

							if getReturn(rec):
								ppRec = re.split(':\s*', rec)
								ppRec.pop(0)
								localBin[retPos].append(ppRec)
								localBin[rets] += 1

							if getTP(rec):
								ppRec = re.split(':\s*', rec)
								ppRec.pop(0)
								localBin[tpPos].append(ppRec)
								localBin[tp] += 1

						collectedComments.append(localBin)

def dumpBlocks(docRoot, outputFileContent):

	collectedComments = []
	# call extractBlocks to access all the file unter the directory: docRoot
	print "\n************* working on " + docRoot + "\n"
	os.path.walk(docRoot, extractBlocks, collectedComments)

	# no comments in this directory
	if collectedComments == []:
		return
	
	# sorting
	collectedComments.sort(cmpComments)

	# analyze/extract the given comments

	# - add section 
	outputFileContent.append("<section xmlns:xinclude=\"http://www.w3.org/2001/XInclude\">\n")

	print("Creating the docbook section for " + docRoot)
	usrDocRoot = raw_input("Please input a name for this section: ")
	# id accepts only one token
	usrDocRoot = usrDocRoot.replace(" ","_")

	docRootS = re.split('/',docRoot)
	outputFileContent.append("<title> Code Reference: " + usrDocRoot + "</title>\n")

	# - add one section for each function
	sec_no = 0

	for block in collectedComments:

		outputFileSection = []
		
		outputFileSection.append("\n<section id=\"")
		# add topology (device) name
		if block[names] != 0:
			if (len(block[namePos][0]) == 0):
				commentName = usrDocRoot + "_Unknown_Device_or_Sensor_" + str(sec_no)
			else:
				commentName = block[namePos][0][0]
				if re.match('^\s*$', commentName):
					commentName = usrDocRoot + "_Unknown_Device_or_Sensor_" + str(sec_no)
		else:
			commentName = usrDocRoot + "_Unknown_Device_or_Sensor_" + str(sec_no)

		commentName = commentName.replace("(", "")
		commentName = commentName.replace(")", "")

		sec_no += 1

		outputFileSection.append(usrDocRoot)
		outputFileSection.append("_")
		outputFileSection.append(commentName.replace(" ","_"))
		outputFileSection.append("\">\n")
		outputFileSection.append("<title>" + commentName + "</title>\n\n")

		outputFileSection.append("<funcsynopsis>\n")
		outputFileSection.append("<funcprototype>\n")

		# add the function name
		if block[tp] != 0:
			commentName = block[tpPos][0][0]
		else:
			commentName = "Noname"

		if block[rets] != 0:
			commentReturn = block[retPos][0][0]
			outputFileSection.append("<funcdef>" + commentReturn + " <function>" + commentName + "</function></funcdef>\n")
		else:
			outputFileSection.append("<funcdef>" + "TBD" + " <function>" + commentName + "</function></funcdef>\n")

		# add parameters if available
		if block[args] > 0:
			sum = block[args]
			for pos in range(0, sum):
				type = getType(block[argPos][pos][0])
				#throw out the type to get the name
				name = string.replace(block[argPos][pos][0], type, '')
				#outputFileSection.append("<paramdef><parameter>" + type + "</parameter>" + name + "</paramdef>")
				outputFileSection.append("<paramdef><parameter>" + block[argPos][pos][0] + "</parameter></paramdef>")
		
		outputFileSection.append("</funcprototype>\n")
		outputFileSection.append("</funcsynopsis>\n")

		# description
		outputFileSection.append("<section><title>Description</title>\n")
		if block[descs] > 0:
			sum = block[descs]
			outputFileSection.append("<para>\n")
			for pos in range(1,sum):
				outputFileSection.append("\n" + block[descPos][pos][0] + "\n")
			outputFileSection.append("</para>\n")
			
		outputFileSection.append("</section>\n")
		
		# add description for each parameter if given
		outputFileSection.append("<section><title>Argument Description</title>\n")
		if block[args] > 0: 
			outputFileSection.append("<itemizedlist>\n")
			sum = block[args]
			for pos in range(0, sum):
				outputFileSection.append("\t<listitem>\n")
				outputFileSection.append("\t<para>" + block[argPos][pos][0] + "</para>\n")
				outputFileSection.append("\t<para>\n")
				for next in range(0, len(block[argDesPos][pos])):
					outputFileSection.append(block[argDesPos][pos][next][0] + "\n")

				outputFileSection.append("\t</para>\n")
				outputFileSection.append("\t</listitem>\n\n")
				
			outputFileSection.append("</itemizedlist>\n")
		outputFileSection.append("</section>\n")


		outputFileSection.append("</section>\n")

		for sec in outputFileSection:
			outputFileContent.append(sec)

		# dump the blocks to file
		print "================================================================================\n"
		docBookSourceFile = docbookDir + "/" + commentName + ".section"
		#if (os.path.isfile(docBookSourceFile)):
		#	confirm = raw_input("Given output file already exists. Overwrite? (y/n): ")
		#else:
		confirm = "y"
		if confirm.lower() == "y":
			# yes overwrite/create
			if standard.saveFileContent (docBookSourceFile, outputFileSection) == 0:
				print "Docbook section dumped into " + docBookSourceFile
			else:
				print "Cannot save output to file ", docBookSourceFile 


	#outputFileContent.append("</chapter>\n")
	outputFileContent.append("</section>\n")

def preamble(outputFileContent):
	# - xml type, iso id
	outputFileContent.append("<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>\n")

	# set copyright and comment2docbook id
	comment2docbookId = copyrightVersion + " " + copyrightOwner
	outputFileContent.append("<!-- " + comment2docbookId + " -->\n\n")

	# set docbook version
	docbookVersion = "-//OASIS//DTD DocBook XML V4.2//EN"

	# set dtd path
	# - official path:
	docbookDtdPath = "http://www.oasis-open.org/docbook/xml/4.2/docbookx.dtd"
	# - local path:
	# docbookDtdPath = "/usr/share/sgml/docbook/xml-dtd-4.2-1.0-6/docbookx.dtd"
	outputFileContent.append("<!DOCTYPE book PUBLIC \"" + docbookVersion + "\" \"" + docbookDtdPath + "\" [\n")

	# - included files and entitiy definitions if needed
	# + add today's date == publication/release date
	today = strftime("%d %B %Y")
	outputFileContent.append("<!ENTITY today \"" + today + "\">\n")

	outputFileContent.append("]>\n\n")

	# document info
	# use book
	# - set language (default: de)
	documentLanguage = ""
	if documentLanguage == "": documentLanguage = "de"
	# - set xml include namespace
	xinclude="xmlns:xinclude=\"http://www.w3.org/2001/XInclude\""
	outputFileContent.append("<book lang=\"" + documentLanguage + "\" " + xinclude + ">\n\n")

	# - add book info
	outputFileContent.append("<bookinfo>\n")
	outputFileContent.append("\t<mediaobject>\n")
	outputFileContent.append("\t<imageobject>\n")
	outputFileContent.append("\t<imagedata align=\"center\" depth=\"10cm\" fileref=\"companylogo.png\" format=\"PNG\" scale=\"15\" valign=\"bottom\" width=\"7cm\"/>\n")
	outputFileContent.append("\t</imageobject>\n")
	outputFileContent.append("\t</mediaobject>\n\n")

	# - add title
	outputFileContent.append("\t<title>Peppercon Code Reference</title>\n\n")
	# - add copyright		
	outputFileContent.append("\t<copyright>\n")
	outputFileContent.append("\t\t<year>2005</year>\n")
	outputFileContent.append("\t\t<holder>Peppercon AG, Zwickau (Saxony), Germany.</holder>\n")
	outputFileContent.append("\t</copyright>\n\n")
	# - update
	outputFileContent.append("\t<legalnotice>\n")
	outputFileContent.append("\t<para>Last updated on <today/></para>\n")
	outputFileContent.append("\t</legalnotice>\n")

	outputFileContent.append("</bookinfo>\n\n")

# compare the names of two localbins
def cmpComments(x, y):

	s = ""
	t = ""

	if x[tp] != 0:
		if len(x[tpPos][0]) == 0:
			s = ""
		else:
			s = x[tpPos][0][0]
	else:
		s = ""

	if y[tp] != 0:
		if len(y[tpPos][0]) == 0:
			t = ""
		else:
			t = y[tpPos][0][0]
	else:
		t = "" 

	return cmp(string.lower(s), string.lower(t))

# split the parameter into directory list
def getInputDirs(dirString):
	dirArray = re.split(' ', dirString)
	return dirArray
# ---------------------------------------main program --------------------------------------

# read and verify parameters --------------------

if (len(sys.argv) < 4):
	print "wrong number of arguments."
	print "python comment2docbook outputFile docbookDir \"project-directories\" "
	sys.exit(1)
# end if

outputFile = sys.argv[1]
docbookDir = sys.argv[2]
#dirs = getInputDirs(sys.argv[2]) 

# load input file into buffer
outputFileContent = []

# set preamble and open a book
preamble(outputFileContent)

# chapter buffer
chapterBuffer = []
chapterBuffer.append("<chapter><title>Code Reference</title>\n")

inputIndex = 3
while inputIndex < len(sys.argv):
	inputDir = sys.argv[inputIndex]
	#extract und dump PPDOC blocks into chapters 
	dumpBlocks(inputDir, chapterBuffer)
	inputIndex += 1

chapterBuffer.append("</chapter>\n")
# dump the blocks to file
print "================================================================================\n"
docBookSourceFile = docbookDir + "/code_reference.docbook"
if (os.path.isfile(docBookSourceFile)):
	confirm = raw_input("Given output file already exists. Overwrite? (y/n): ")
else:
	confirm = "y"
if confirm.lower() == "y":
	# yes overwrite/create
	if standard.saveFileContent (docBookSourceFile, chapterBuffer) == 0:
		print "Docbook chapters dumped into " + docBookSourceFile
	else:
		print "Cannot save output to file ", docBookSourceFile 

# close the book 
outputFileContent += chapterBuffer

outputFileContent.append("</book>\n")

# save output file ------------------------------
if (os.path.isfile(outputFile)):
	confirm = raw_input("Given output file already exists. Overwrite? (y/n): ")
else:
	confirm = "y"

if confirm.lower() == "y":
	# yes overwrite/create
	if standard.saveFileContent (outputFile, outputFileContent) == 0:
		print "docbook file saved to " + outputFile
	else:
		print "Cannot save output to file ", outputFile




