# !/usr/bin/env python
# -*- coding: ISO8859-15 -*-
# -------------------------------------------------
# project2docbook
# xml module
#
# taken from htc-py HyperText Converter for Python
# (C) 2002-04 Frank Hofmann, Chemnitz, Germany
# email fh@efho.de
# -------------------------------------------------

# other modules required
import re
import string

def get_node_text(node):
	"returns the value of a given text node"

	# set default value
	value = ""

	for subnode in node.childNodes:
		if subnode.nodeType == subnode.TEXT_NODE:
			# extract text nodes
			value = subnode.data
			break
		# end if
	# end for

	return value

def get_node(structure, node_list):
	"returns the referring node for a given node_list"

	# set default value
	value = None

	# extract tags
	tags = string.split(node_list, ".")
	items = len(tags)

	for node in structure.childNodes:
		# extract element nodes
		# print "(1): ", node
		if node.nodeType == node.ELEMENT_NODE:
			# print "(2): ", node
			if node.tagName == tags[0]:
				# print "(3): ", node.tagName
				if (items > 1):
					new_list = string.join(tags[1:], ".")
					value = get_node(node, new_list)
					break
				else:
					value = node
					# print "(4): ", value
					break
				# end if
			# end if
		# end if
	# end for
	return value

def get_node_value(structure, node_list):
	"returns the value of a given xml tag"

	# set default value
	value = ""

	node = get_node(structure, node_list)

	if (node == None):
		value = ""
	else:
		value = get_node_text(node)
	# end if

	return value
