#ifndef _PP_FEATURES_H
#define _PP_FEATURES_H

/*
 * Caution: always define boolean features to 1!!! (needed by build scripts)
 */

#if (									\
     (defined(OEM_PEPPERCON)						\
      && !defined(PRODUCT_XX01IP_ANY)					\
      && !defined(PRODUCT_WINGLE)					\
      && !defined(PRODUCT_ERICXP)					\
      && !defined(PRODUCT_ERICG4)					\
      && !defined(PRODUCT_LARAXP)					\
      && defined(PRODUCT_FORENSICCIM)					\
      && !defined(PRODUCT_ICPMMD)					\
      )									\
     || (defined(OEM_MINICOM)						\
	 && !defined(PRODUCT_RC1))					\
     || (defined(OEM_LONZA)						\
	 && !defined(PRODUCT_RC1))					\
     )
# define PP_FEAT_PEMX 1
#endif

#if defined(PRODUCT_FORENSICCIM)
#define PP_FEAT_NETEVENT 1
#endif

#if 0
#define PP_FEAT_SPI_BOOT 1
#endif

#if 0
#define PP_FEAT_USE_I2C6 1
#endif

/* for building a D-Link specific firmware for Tangtop */
#if defined(OEM_DLINK)				
# define OEM_TANGTOP
#endif

/* ESB2 sideband interface (on Intel KIM and ASMI G4) */
#if (defined (PRODUCT_INTELDC) || defined (PRODUCT_ASMIDC)) && defined(OEM_INTEL)
# define PP_FEAT_ESB2_TPT 1
# define PP_FEAT_ESB2_FNI 1
#endif

/* TODO: set this feature only for MasterConsole IP devices! */
/**
 * MC IP either is XX01IP with Raritan OEM or XX01IP with KIM G4, as there will
 * never be a XX01IP device with KIM G4.
 * In case of "never", change that feature again ;-)
 */
#if defined(PRODUCT_XX01IP_ANY) && (defined(OEM_RARITAN) || defined(KIRA_KIMG4))
#define PP_FEAT_MASTERCONSOLE_FW_UPDATE	1
#endif /* PRODUCT_XX01IP_ANY && (OEM_RARITAN || KIRA_KIMG4) */

#if defined(OEM_TANGTOP)
#define PP_FEAT_RS232_ENABLE_GPIO 1
#endif

#if defined(PRODUCT_XX01IP_ANY)
#define PP_FEAT_TELNET_KVM_PSWITCH 1
#endif

#undef PP_FEAT_RDP

#if defined(PRODUCT_ERICXP)
# define PP_FEAT_AD_ATMEL 1
#endif

#if defined PRODUCT_ERICG4
# define PP_FEAT_PCI_ADC 1
/* #define PP_FEAT_PSU_ADAPT 1 <- only for oem customers with special adapter cables !*/
#endif

#if defined(PRODUCT_ASMIDC) || defined(PRODUCT_ERICG4)
/* define this feature for 'PRODUCT_ERICG4' when hardware is patched !!*/
# define PP_FEAT_RESET_TO_DEFAULTS_PINS 1
#endif

#if defined(PRODUCT_RIPCKIMXN) || defined(PRODUCT_LARA) || defined(PRODUCT_XX01IP_ANY)
# define PP_FEAT_TARGET_PORT_SWITCHING 1
#endif

#if defined(PRODUCT_RIPCKIMXN)
# define PP_FEAT_KVM_MULTI_CHANNEL 1
#endif

#if defined(PRODUCT_LARAXP) || defined(PRODUCT_WINGLE) || defined(PRODUCT_FORENSICCIM)
# define PP_FEAT_SYSOK_BLINKING 1 
#endif

#if defined(PRODUCT_LARAXP) || defined(PRODUCT_WINGLE) || defined(PRODUCT_FORENSICCIM)
# define PP_FEAT_USBPOWERED 1
#endif

/* disable display of power supply (external/USB) on request
 * of Raritan (eMail from Martin: 20.9.2004),
 * because of the wrong meaning when USB power cable is used
 */ 
#if (defined(PRODUCT_LARAXP) && !defined(OEM_LANTRONIX)) || defined(PRODUCT_FORENSICCIM)
# define PP_FEAT_SHOW_USB_POWER
#endif

/* disabled in general for now */
#if 0 && !defined(PRODUCT_RC1) && !defined(PRODUCT_WINGLE)
# define PP_FEAT_AUTH_SSL 1
#endif

#if defined(PRODUCT_WINGLE)
# define PP_FEAT_WLAN 1
#endif

#if defined(PRODUCT_RC1) || defined(PRODUCT_WINGLE) || defined(PRODUCT_ERICXP) || defined(PRODUCT_ERICG4) || defined(PRODUCT_LARAXP)
# define PP_FEAT_RC1 1
#endif

#if (!defined(PRODUCT_RC1) \
     && !defined(PRODUCT_ERICXP) \
     && !defined(PRODUCT_LARAXP) \
     && !defined(PRODUCT_WINGLE) \
     && !defined(PRODUCT_FORENSICCIM)) \
    || (defined(PRODUCT_LARAXP) \
	&& defined(OEM_PROCOM))
# define PP_FEAT_AUTH_RADIUS 1
#endif

#if !defined(PRODUCT_WINGLE) && !defined(OEM_BELKIN) && !(defined(PRODUCT_RC1) && defined(OEM_RARITAN)) && !defined(PRODUCT_KX2)
# define PP_FEAT_CAN_SET_SETUP_PROTO 1
#endif

#if !defined(PRODUCT_PDU)
#define PP_FEAT_DYNDNS 1
#endif

#define PP_FEAT_PORT_CHANGE 1

#define PP_FEAT_BANDWIDTH_LIMIT 1

#if !defined(PRODUCT_WINGLE) && !defined(OEM_BELKIN)
# define PP_FEAT_NET_LANIF 1
#endif

#if defined(LARA_KACY) || ((defined(LARA_KIM) || defined(LARA_KIMMSI) || defined(LARA_KIMAMD)) && defined(PRODUCT_ICPMMD)) || defined(KXNG_VIA) || defined(KXNG_INTEL) || defined(KXNG_ATI128) || (defined(KIRA_KIMG4) && defined(PRODUCT_XX01IP_ANY)) || defined(KIRA_RPC)
# define PP_FEAT_JFFS2_ROOTFS 1
#endif

#if defined(LARA_KIMAMD) || defined(KIRA_KIMAMDG4)
# define PP_FEAT_OPMA_HW 1
#endif

/* ----------------------------------------------------------------------------
 * IPMI
 */

#if ((defined(OEM_PEPPERCON) || defined(OEM_DAXTEN)) && (defined(PRODUCT_ERIC2) || defined(PRODUCT_ERICXP) || defined(PRODUCT_ERICG4))) || defined(LARA_KIMINTEL) || defined(KIRA_KIMASMIG4) || defined (KIRA_KIMGIGAG4)
# define PP_FEAT_IPMI_CLIENT_IPMB 1
#endif

#if (defined(PRODUCT_LARA) || defined(PRODUCT_ERICG4) || \
	( (defined(OEM_PEPPERCON) || defined(OEM_PROCOM) || defined(OEM_LONZA) || defined(OEM_DAXTEN) || defined(OEM_GDM)) || defined(OEM_TRIPPLITE) \
	   && !defined(PRODUCT_RC1) && !defined(PRODUCT_XX01IP_ANY) && !defined(LARA_KIMINTEL) && !defined(KIRA_KIMASMIG4) )) && (!defined(KIRA_KIMGIGAG4))
# define PP_FEAT_IPMI_CLIENT_LAN 1
#endif

#if ( defined(PRODUCT_ERIC2) || defined(PRODUCT_LARA2) || defined(PRODUCT_ERICG4)) && defined(OEM_PEPPERCON) || defined(PRODUCT_LARAXP) && defined(OEM_LANTRONIX)
# define PP_FEAT_IPMI_CLIENT_SERIAL 1
#endif

#if defined(PRODUCT_LARA) || ((defined(OEM_PEPPERCON) || defined(OEM_PROCOM)) && (!defined(PRODUCT_WINGLE) && !defined(PRODUCT_RC1) && !defined(PRODUCT_XX01IP_ANY) && !defined(PRODUCT_ERICXP)  && !defined(PRODUCT_LARAXP) && !defined(PRODUCT_FORENSICCIM)))
# define PP_FEAT_IPMI_CLIENT_EVENTS 1
#endif

#if defined(PRODUCT_LARA) || defined(PRODUCT_ERICG4) || ((defined(OEM_PEPPERCON) || defined(OEM_PROCOM)) && (!defined(PRODUCT_WINGLE) && !defined(PRODUCT_RC1) && !defined(PRODUCT_XX01IP_ANY) && !defined(PRODUCT_ERICXP) && !defined(PRODUCT_LARAXP) && !defined(PRODUCT_FORENSICCIM)))
# define PP_FEAT_IPMI_CLIENT_SENSORS 1
#endif

#if defined(PRODUCT_MSIDC) || \
    defined(PRODUCT_SMIDC) || \
    defined(PRODUCT_AMDDC) || \
    defined(PRODUCT_ASMIDC) || \
    defined(PRODUCT_RACKABLEDC) || \
    defined(PRODUCT_LARA_BMC_TEST) || \
    (defined(PP_BOARD_KIRA) && !defined(KIRA_KIMG4) && defined(PRODUCT_LARA)) || \
    defined(PRODUCT_ICPMMD) || \
    defined(PRODUCT_PDU)
# define PP_FEAT_IPMI_SERVER 1
/* build BMC core only (no loop interface, no sensor lib) */
# if defined(PRODUCT_ASMIDC)
#  define PP_FEAT_BMC_OEMCMDS_ONLY 1
# endif
/* system management interface (inc. Event-Msg-Queue and Receive-Msg-Queue */
# if !defined(PRODUCT_PDU) && !defined(PRODUCT_ICPMMD) && !defined(PRODUCT_LARA_BMC_TEST)
#  define PP_FEAT_IPMI_SERVER_SMI_CHAN 1
# endif
/* primary IPMB */
# if defined(PRODUCT_ICPMMD)
#  define PP_FEAT_IPMI_SERVER_PRIMARY_IPMB_CHAN 1
# endif
/* secondary IPMB */
# if defined(PRODUCT_ICPMMD)
#  define PP_FEAT_IPMI_SERVER_SECONDARY_IPMB_CHAN 1
# endif
/* serial channel */
# if !defined(PRODUCT_PDU) && !defined(PRODUCT_ASMIDC)
#  define PP_FEAT_IPMI_SERVER_SER_CHAN 1
# endif
/* proprietary IPMI-over-SCSI channel */
# if defined(PRODUCT_RACKABLEDC) || defined(PRODUCT_ASMIDC)
#  define PP_FEAT_IPMI_SERVER_SCSI_CHAN 1
# endif
/* watchdog */
# if !defined(PRODUCT_PDU) && !defined(PRODUCT_ICPMMD) && !defined(PRODUCT_ASMIDC)
#  define PP_FEAT_IPMI_SERVER_WATCHDOG 1
# endif
/* chassis commands */
# if !defined(PRODUCT_PDU) && !defined(PRODUCT_ASMIDC)
#  define PP_FEAT_IPMI_SERVER_CHASSIS_CMDS 1
# endif
/* persist ipmi sensor thresholds */
# if defined(PRODUCT_PDU)
#  define PP_FEAT_IPMI_THRESHOLD_PERSIST 1
# endif
/* implement heartbeat timer */
# if !defined(PRODUCT_PDU)
#  define PP_FEAT_IPMI_SERVER_HEARTBEAT 1
# endif
/* sensor scan delay, maybe used to relax bus traffic, in ms */
# if defined(PRODUCT_PDU)
#  define PP_FEAT_IPMI_SERVER_SENS_SCAN_DELAY 50
# endif
/* allows for injecting funktions into BMC execution context   *
 * maybe used to get information out of BMC without libpp_ipmi */
# if defined(PRODUCT_PDU) || defined(PRODUCT_RACKABLE) || defined(PRODUCT_ASMIDC)
#  define PP_FEAT_IPMI_SERVER_FKT_INJECT 1
# endif
#endif

#if defined(PRODUCT_ASMIDC) && (defined(OEM_INTEL) || defined(OEM_LENOVO))
# define PP_FEAT_IPMI_CLIENT_QUERY_SENSORS_IN_BACKGROUND 1
#endif

#if defined(PP_FEAT_IPMI_CLIENT_QUERY_SENSORS_IN_BACKGROUND) && defined(PRODUCT_ASMIDC) && defined(OEM_INTEL)
# define PP_FEAT_IPMI_SHOW_SYSTEM_STATUS 1
#endif

#if defined(PRODUCT_ASMIDC) && (defined(OEM_INTEL) || defined(OEM_LENOVO))
# define PP_FEAT_IPMI_CLIENT_QUERY_SEL_IN_BACKGROUND 1
#endif

/* ---- IPMI meta features ------------------------------------------------- */

#if defined(PP_FEAT_IPMI_CLIENT_IPMB) || defined(PP_FEAT_IPMI_CLIENT_LAN) || defined(PP_FEAT_IPMI_CLIENT_SERIAL)
# define PP_FEAT_IPMI_CLIENT_POWER 1
#endif

#if defined(PP_FEAT_IPMI_CLIENT_POWER) || defined(PP_FEAT_IPMI_CLIENT_EVENTS) || defined(PP_FEAT_IPMI_CLIENT_SENSORS)
# define PP_FEAT_IPMI_CLIENT 1
#endif

/* ---- Baytech to IPMI protocoll adapter --------------------------------- */

#if defined(PRODUCT_PDU)
#  if !defined(PP_FEAT_IPMI_SERVER)
#     error PP_FEAT_BAYTECH_2_IPMI will not work without PP_FEAT_IPMI_SERVER
#  endif
#  define PP_FEAT_BAYTECH_2_IPMI 1
#endif

/* --- PowerCIM detection in boot code ------------------------------------*/

#if defined (PRODUCT_PDU)
/*#  define PP_FEAT_PDU_POWER_CIM_DETECT 1*/
#endif

/* --- PDU specfic stuff (that can't be expressed wiht another feature) --- */

#if defined(PRODUCT_PDU)
#  define PP_FEAT_PDU 1
#endif

/* ----------------------------------------------------------------------------
 * Video/Encoding related features
 */

/* use this in order to disable remote console in general, *
 * must be aligned with build_fw.cfg                       */
#if !defined(KIRA_RPC) && !defined(PP_BOARD_KXNG)
# define PP_FEAT_REMOTE_CONSOLE 1 
#endif

#if defined(PRODUCT_ERIC2) || defined(LARA_KIMMSI) || defined(LARA_KIMAMD) || defined(LARA_KIMINTEL) || defined(KIRA_KIMAMDG4) || defined(KIRA_KIMASMIG4) || defined(KIRA_KIMSMIG4) || defined (KIRA_KIMGIGAG4)
# define PP_FEAT_VSC_PANEL_INPUT 1
#endif

#if defined(LARA_KIM2) || defined(LARA_KIMMSI) || defined(LARA_KIMAMD) || defined(LARA_KIMSMI) || defined(LARA_KIMINTEL) || defined(PP_BOARD_KIRA) || defined(LARA_KACY)
# define PP_FEAT_VSC_HW_ENCODING 1
#endif

/* TODO: determine this from VSC register it this is supported */
#if defined(PP_FEAT_VSC_HW_ENCODING) && !defined(LARA_KIMMSI) && !defined(LARA_KIMAMD) && !defined(LARA_KIMSMI) && !defined(LARA_KIMINTEL)
# define PP_FEAT_VSC_HW_DOWNSCALING 1
#endif

#if defined(LARA_KIM2)
# define PP_FEAT_SIMPLERFB_SUPPORT 1
#endif

/* device has DDC data in memory */
#if defined(PP_BOARD_KIRA)
# define PP_FEAT_DDC 1
#endif

/* device is able to update an external DDC eeprom */
#if defined(PP_FEAT_DDC) && 0
# define PP_FEAT_UPDATE_EDID 1
#endif

/* device is DDC source */
#if defined(PP_FEAT_DDC) && 0
# define PP_FEAT_DDC_DEVICE 1
#endif

/* For KIRA only for prototype boards with the ADC bug
   or when trying to use the buggy KIRA DVI input */
/* ATTENTION: USE THIS FOR KIM G4 / KIRA EVALBOARDS OF REV.A ONLY */
#if (defined(PP_BOARD_KIRA) && (defined(KIRA_KIMSMIG4) || defined(KIRA_KIMGIGAG4)))
# define PP_FEAT_VSC_SINGLE_PIXEL 1
#endif

/* various VSC debug options (upload custom VSC binary, ...) */
#define PP_FEAT_DEBUG_VSC 1

/* -----------------------------------------------------
 * USB related stuff 
 */

/* Number of USB device controllers */
#if defined(KIRA_CPE)
#define PP_FEAT_NUM_USB_DEVICES 2
#else
#define PP_FEAT_NUM_USB_DEVICES 1
#endif

#if (                                                  \
		     !(defined(OEM_ADDER) && defined(PRODUCT_LARA)) && \
		     !(defined(PRODUCT_XX01IP_ANY)) &&                 \
		     !defined(KIRA_RPC)                                \
		     )
#if defined(PP_FEAT_REMOTE_CONSOLE)
# define PP_FEAT_USB 1
#endif
#endif

/* Lonza insist on having USB mass storage support disabled for security reasons */
/* chkr: HACK FIXME ALERT :-) deactivate MASS STORAGE for kacy right now to avoid problems starting the MSP threads (and the eric process) - libpp_usb must be changed for KX2.0 */
#if !defined(OEM_LONZA) && !defined(OEM_GDM) && !defined(KIRA_RPC) && !defined(PP_BOARD_KXNG) && !(PRODUCT_KX2)
#if defined (PP_FEAT_USB)
# define PP_FEAT_MASS_STORAGE 1
#endif
#endif

#if defined PP_FEAT_MASS_STORAGE
# if !(defined(PRODUCT_WINGLE) && defined(OEM_RARITAN)) && !defined(PRODUCT_XX01IP_ANY)
#  define PP_FEAT_DRIVE_REDIRECTION 1
# endif
#endif

/* USB force full speed (for BIOS compatibility) */
#if defined(OEM_INTEL) || defined(OEM_LENOVO)
# define PP_FEAT_USB_FORCE_FS 1
#endif

/* ----------------------------------------------------------------------------
 * Power Management
 */

/* enables support for power switching */
#if !defined(KXNG_VIA) && !defined(KXNG_INTEL) && !defined(KXNG_ATI128) && !defined(PP_FEAT_OPMA_HW)
# define PP_FEAT_POWERSWITCH    1
#endif /* !KXNG_VIA && !KXNG_INTEL && !KXNG_ATI128 && !PP_FEAT_OPMA_HW */

/* if undefined, no power controls will be shown in frontend */
/* FIXME: add some brackets! */
#if !(defined(PRODUCT_XX01IP_ANY) && defined(OEM_RARITAN) || defined(PRODUCT_LARA) && defined(OEM_DAXTEN)) && !defined(PRODUCT_SMARTIPC) && !defined(PRODUCT_ICPMMD) && !defined (OEM_BELKIN) && defined(PP_FEAT_POWERSWITCH)
# define PP_FEAT_POWER_CTRL_ENABLE 1
#endif

#if (defined(PRODUCT_ERIC2) || defined(PRODUCT_ERICXP) || defined(PRODUCT_ERICG4) || (defined(PRODUCT_LARA) && !defined(OEM_BELKIN))) && defined(PP_FEAT_POWERSWITCH)
# define PP_FEAT_POWER_CTRL_ATX 1
#endif

#if !(defined(PRODUCT_LARAXP) && defined(OEM_LANTRONIX)) && !defined(PRODUCT_XX01IP_ANY) && !defined(PRODUCT_ERICG4) && !defined(OEM_TANGTOP) && !(defined(PRODUCT_WINGLE) && defined(OEM_RARITAN)) && !(defined(PRODUCT_RC1) && defined(OEM_RARITAN)) && defined(PP_FEAT_POWERSWITCH)
# define PP_FEAT_POWER_IPM220 1
#endif

/* RS232 transceiver of 2nd serial port on LaraXP HW falls asleep when RX
 * is not connected -> does not work with IPM220 */
#if !defined(PRODUCT_LARAXP) && !defined(PRODUCT_ERICG4)
/* note: this feat only makes sense with PP_FEAT_SERIAL_PORT_2! */
# define PP_FEAT_IPM220_ON_SERIAL2 1
#endif

/* support for "external" (i.e. outside of target host) power switch devices
 *     other than IPM220 ("internal" would be ATX, for example) */
#if (!defined(PRODUCT_ERIC2) && !defined(PRODUCT_ERICXP) && !defined(PRODUCT_ERICG4) && !defined(PRODUCT_LARAXP) && !defined(PRODUCT_RC1) && !defined(PRODUCT_WINGLE) && !defined(PRODUCT_FORENSICCIM) || defined(PRODUCT_LARAXP) && defined(OEM_TANGTOP)) && defined(PP_FEAT_POWERSWITCH)
# define PP_FEAT_POWER_OTHER_EXTERNAL 1
#endif

/* allows the user to directly switch a port of a power switch device
 *     (as opposed to switching a KVM port, which triggers switching of any
 *     power ports assigned to it - see PP_FEAT_KVM_PORT_POWER) */
#if defined(PP_FEAT_POWERSWITCH) && !(defined(PRODUCT_LARA) && defined(OEM_BELKIN)) && !defined(PRODUCT_MSIDC) && !defined(PRODUCT_AMDDC) && !defined(PRODUCT_PDU) && !defined(PRODUCT_ASMIDC) && !defined(PRODUCT_SMIDC) && !defined (KIRA_KIMGIGAG4) && !defined(PRODUCT_ERICG4) && !defined(PRODUCT_RACKABLEDC) && !(defined(PRODUCT_LARAXP) && defined(OEM_LANTRONIX)) 
# define PP_FEAT_POWER_CONTROL_DIRECT 1
#endif

/* allows the user to assign power ports to each KVM port and to switch power
 *     by KVM port */
#if !(defined(PRODUCT_LARA) && defined(OEM_BELKIN)) && defined(PP_FEAT_POWERSWITCH)
# define PP_FEAT_KVM_PORT_POWER 1
#endif

/* special feature (Fujitsu Siemens TX600) */
#if 0
# define PP_FEAT_POWER_SWITCH_FJSMS 1
#endif

/* ----------------------------------------------------------------------------
 * Keyboard/Mouse
 */

#if defined(PRODUCT_LARA) && !defined (OEM_BELKIN)
# define PP_FEAT_MOUSE_G_UND_D 1
#endif

/* Forces mouse sync button and single/double mode button on.  See #887. */
#if defined(PRODUCT_WINGLE) && defined(OEM_RARITAN)
# define PP_FEAT_RC_MOUSEBTNS_ALWAYS_ON 1
#endif

/*** Cursor Action Tracking (tweb) ********************************************
 * CAT (Cursor Action Tracking):
 *     online manipulation of mouse pointer acceleration lookup table
 * KITTY CAT (Kindly Improved Transition TrajectorY by Cursor Action Tracking):
 *     supports intelli pointer moves by position correction but does not
 *     acceleration lookup table
 * Warning:
 *     never define both CAT and KITTY CAT as this will cause a catfight :-)
 */
/* #define PP_FEAT_CAT 1 */
/* #define PP_FEAT_KITTY_CAT 1 */

/* Automatically generates break code on timeout */
#define PP_FEAT_KBD_BREAK_TIMEOUT 1

/* ----------------------------------------------------------------------------
 * Video
 */

#if defined(PRODUCT_ERIC2)
# define PP_FEAT_VIDEO_SET_PANEL_ID 1
#endif

#if !defined(PRODUCT_ERIC2) && !defined(PRODUCT_RIPCKIMXN)
# define PP_FEAT_VIDEO_FORCE_COMPOSITE_SYNC 1
#endif

#if !defined(PRODUCT_ERIC2) && !defined(PRODUCT_ERICXP) && !defined(PRODUCT_ERICG4) && !(defined(PRODUCT_LARAXP) && !defined(OEM_LANTRONIX)) && !defined(PRODUCT_RIPCKIMXN) && !defined(PRODUCT_FORENSICCIM)
# define PP_FEAT_VIDEO_LOCAL_PORT_SWITCH 1
#endif

#if defined(PRODUCT_LARA) || defined(PRODUCT_XX01IP_ANY) || defined(PRODUCT_ERICG4)
# define PP_FEAT_VIDEO_CUSTOM_MODES 1
#endif

#if defined(LARA_KACY)
/* TODO: change this to 4 when testing for KX2 */
# define PP_FEAT_CHANNEL_COUNT 4
#elif defined (PRODUCT_KIMTESTERMST)
/* FPGA is used as passthrough to USB HC here, no VSC */
# define PP_FEAT_CHANNEL_COUNT 0
#else
# define PP_FEAT_CHANNEL_COUNT 1
#endif

#if defined(KXNG_VIA) || defined(KXNG_INTEL) || defined(KXNG_ATI128) || defined(PRODUCT_KX2)
/* really PRODUCT_KX2? */
# define PP_FEAT_LOCAL_VIDEO_CONSOLE 1
# if defined(KXNG_INTEL) || defined(PRODUCT_KX2)
   /* Xorg X11 only for kxng/intel at the moment */
#  define PP_FEAT_LOCAL_VIDEO_X_CONSOLE 1
# endif /* KXNG_INTEL */
# if defined(PRODUCT_KXNG)
#  define PP_FEAT_LOCAL_KVM_CONSOLE 1
# endif
#endif

/* ----------------------------------------------------------------------------
 * RC Settings
 */

#if defined(PRODUCT_FORENSICCIM)
# define PP_FEAT_DISABLE_KVM_OVER_IP 1
#endif

#if !(defined(PRODUCT_RC1) && !defined(OEM_TRIPPLITE)) && !defined(PRODUCT_WINGLE) && ( !defined(PRODUCT_XX01IP_ANY) || defined(PRODUCT_0801IPTT) )
# define PP_FEAT_RC_ENCODING_FIX 1
#endif

#if !defined(PRODUCT_WINGLE) && ( !defined(PRODUCT_XX01IP_ANY) || defined(PRODUCT_0801IPTT) )
# define PP_FEAT_RC_ENCODING_ADV 1
#endif

#if !defined(PRODUCT_WINGLE) && ( !defined(PRODUCT_XX01IP_ANY) || defined(PRODUCT_0801IPTT) )
# define PP_FEAT_RC_ENCODING_AUTO 1
#endif

#if !defined(PRODUCT_RC1)
# define PP_FEAT_RC_MONITOR_MODE 1
#endif

/* exclusive mode can be configured and used */
#if !defined(PRODUCT_RC1) || (defined(PRODUCT_RC1) && defined(OEM_RARITAN)) || defined(OEM_BELKIN)
# define PP_FEAT_RC_EXCLUSIVE_MODE 1
#endif

/* enable explicit "allow exclusive mode" option for machines without ACL management */
#if defined(PRODUCT_WINGLE)
# define PP_FEAT_RC_ALLOW_CHANGING_EXCLUSIVE_PERM 1
#endif

/* activex console viewer no longer supported! */
#undef PP_FEAT_RC_ACTIVEX

/* ----------------------------------------------------------------------------
 * Users/Groups/Permissions
 */


#if defined(PRODUCT_WINGLE) && defined(OEM_RARITAN) || defined(PRODUCT_RC1)
/* use simple usermanagement: two predefined users, only names can be changed */
# define PP_FEAT_USER_MANAGEMENT_SIMPLE 1
#endif

/* adds code to block/unblock users that enter their password incorrectly */
#if !defined(PRODUCT_RC1) && !defined(PRODUCT_WINGLE) && !defined(PRODUCT_ERICXP) && !defined(PRODUCT_LARAXP) && !defined(OEM_BELKIN) && !defined(PRODUCT_FORENSICCIM)
# define PP_FEAT_USER_BLOCKING 1
#endif

/* enable full permission management. usually disabled for simple user management only */
#if !defined(PRODUCT_RC1) && !defined(PRODUCT_WINGLE) && !defined(PRODUCT_ERICXP) && !defined(PRODUCT_LARAXP) && !defined(OEM_BELKIN) && !defined(PRODUCT_FORENSICCIM)
# define PP_FEAT_PERM_MANAGEMENT 1
#endif

/* enable simplified raritan permissions, requires full permission management. */
#if defined(PP_FEAT_PERM_MANAGEMENT) && defined(PRODUCT_KX2)
# define PP_FEAT_RARITAN_PERMISSIONS 1
#endif

/* extends common acls with 64 permissions to control kvm port access and 
   64 permissions to control vm port access (requires PP_FEAT_PERM_MANAGEMENT) */
#if defined(PP_FEAT_PERM_MANAGEMENT) && defined(PRODUCT_KX2)
# define PP_FEAT_EXTENDED_PORT_ACLS 1
#endif

/**
 * authentication procedure according to common security requirements document
 * same as RP, but fallback to local authentication, if remote AS is unreachable
 */
#if defined(PRODUCT_KX2) || defined(PRODUCT_XX01IP_ANY)
# define PP_FEAT_COMMON_SECURITY_REMOTE_AS 1
#endif /* PRODUCT_KX2 || PRODUCT_XX01IP_ANY */

/**
 * basic remote authentication: 
 *   In contrast to the "common security requirements document", this method 
 *   does not use group names from the AS. Instead, a user with the same name
 *   must exist locally. User settings and group is taken from the local user.
 *
 * Should be defined for all Peppercon OEM products.
 * Todo: please recheck for CC integration!
 */
#if !defined(PRODUCT_KX2)
# define PP_FEAT_BASIC_REMOTE_AUTHENTICATION 1
#endif /* PRODUCT_ASMIG4 */


/**
 * strong password support, refer to common security requirements
 *
 * replaces
 * #if defined(OEM_GDM)
 * # define PP_FEAT_PASSWORD_CHECK 1
 * # define PP_FEAT_MIN_PASSWORD_LENGTH 7
 * #endif
 */
#if defined(PRODUCT_KX2) || defined(PRODUCT_XX01IP_ANY) || defined(OEM_GDM) || defined(OEM_BELKIN) && defined(PRODUCT_LARA)
# define PP_FEAT_STRONG_PASSWORDS 1
#endif /* PRODUCT_KX2 || PRODUCT_XX01IP_ANY || OEM_GDM */

/* if defined, setting weak passwords for users other than root is allowed */
#if defined(PP_FEAT_STRONG_PASSWORDS) && (defined(OEM_BELKIN) && defined(PRODUCT_LARA))
# define PP_FEAT_STRONG_PASSWORDS_ONLY_ROOT 1
#endif

/**
 * use case insensitive login names
 */
#if defined(PRODUCT_KX2) || defined(PRODUCT_XX01IP_ANY)
# define PP_FEAT_CASE_INSENSITIVE_LOGINS 1
#endif /* PRODUCT_KX2 || PRODUCT_XX01IP_ANY */

/**
 * device has "<None>" group as specified in RAASIP
 * not used for KX 2.0 and due to common sense security critical!
 */
/* #define PP_FEAT_HAS_NONE_GROUP 1 */

/**
 * use raritan style LDAP settings
 */
#if defined(PRODUCT_KX2) || defined(PRODUCT_XX01IP_ANY)
# define PP_FEAT_RARITAN_STYLE_LDAP_SETTINGS 1
#endif /* PRODUCT_KX2 || PRODUCT_XX01IP_ANY */

/* ----------------------------------------------------------------------------
 * Miscellaneous
 */

/* web frontend context help */
#if defined(PRODUCT_ASMIDC) && (defined(OEM_INTEL) || defined(OEM_LENOVO))
# define PP_FEAT_CONTEXT_HELP 1
#endif

#if defined(PRODUCT_ASMIDC) && (defined(OEM_INTEL) || defined(OEM_LENOVO))
# define PP_FEAT_ACL_LINK_CHECK 1
#endif

/* enable KVM session timeout configuration */
#if defined(PRODUCT_ASMIDC) && (defined(OEM_INTEL) || defined(OEM_LENOVO))
# define PP_FEAT_KVM_SESSION_TIMEOUT 1
#endif

/* enable virtual media session timeout configuration */
#if defined(PRODUCT_ASMIDC) && (defined(OEM_INTEL) || defined(OEM_LENOVO))
# define PP_FEAT_VMEDIA_SESSION_TIMEOUT 1
#endif

#if !defined(PRODUCT_RC1) && !defined(PRODUCT_WINGLE) && !defined(PRODUCT_ERICXP) && !defined(PRODUCT_FORENSICCIM) && (!defined(PRODUCT_LARAXP) || defined(OEM_GDM)) && !defined(PRODUCT_ERICG4)
# define PP_FEAT_FIREWALL 1
#endif

#if !defined(PRODUCT_ERICG4) && !defined(PRODUCT_RIPCKIMXN)
# define PP_FEAT_GROUP_BASED_ACCESS_CONTROL 1
#endif

#if defined(PRODUCT_ERIC2) || defined(PRODUCT_ERICG4) || (defined(PRODUCT_LARA) && !defined(OEM_DAXTEN)) || defined(PRODUCT_RC1)
# define PP_FEAT_SERIAL_PORT_2 1
#endif

#if defined(PRODUCT_WINGLE)
# define PP_FEAT_CHECK_WLAN_INSTEAD_OF_FLASH_ID 1
#endif

#if defined(PRODUCT_WINGLE) && defined(OEM_RARITAN)
/* allow special users to login on the console with the system root passwd */
/*# define PP_FEAT_FUNCTION_USERS 1*/
# warning PP_FEAT_FUNCTION_USERS feature was hacked into tinylogin; To get this feature back we should implement a menu system for the serial console that allows executing special commands to avoid a login shell.
#endif

#if defined(PRODUCT_RIPCKIMXN)
# define PP_FEAT_ETH_MAC_DIRECT_CONNECT 1
#endif

/* the number of USB mass storage devices
   must be set to a number >= 1
   CAUTION: don't undef this! */
#ifdef PP_FEAT_MASS_STORAGE
# if defined(PRODUCT_LARAXP) || defined(PRODUCT_ERICXP)
#  define PP_FEAT_USB_MASS_STORAGE_NO	1
# elif defined(PRODUCT_ASMIDC) && defined(OEM_INTEL)
#  define PP_FEAT_USB_MASS_STORAGE_NO	4
# else
#  define PP_FEAT_USB_MASS_STORAGE_NO	2
# endif
#else
# define PP_FEAT_USB_MASS_STORAGE_NO	0
#endif

#if !(defined(LARA_KIMMSI) || defined(LARA_KIMSMI) || defined(LARA_KIMAMD) || defined(LARA_KIMINTEL) || defined(LARA_KACY) || defined(PP_BOARD_KIRA))
# define PP_FEAT_CHECK_FLASHID 1
#endif

/*
 * calculate and write flash id in case
 * its not yet locked
 * ONLY FOR intermediate firmware 040000!
 */
#if 0
# define PP_FEAT_CREATE_FLASHID 1
#endif

/* WS Management */
#if (defined(PRODUCT_MSIDC) || defined(PRODUCT_SMIDC) || defined(PRODUCT_AMDDC) || defined(PRODUCT_RACKABLEDC) || defined(PRODUCT_LARA_BMC_TEST) || defined(PRODUCT_PDU) || defined(PRODUCT_ASMIDC) || defined (PRODUCT_KX2)) && !defined(OEM_LENOVO)
# define PP_FEAT_WS_MANAGEMENT 1
/* # define PP_FEAT_CIM_PORT      1   // this is for demonstration purposes only, do not activate for real firmware */
#endif

#if defined(PRODUCT_KX2)
# define PP_FEAT_CIM_PORT 1
#endif

/* SMASH Command Line Protocol (CLP) */
#if (defined(PRODUCT_MSIDC) || defined(PRODUCT_SMIDC) || defined(PRODUCT_AMDDC) || defined(PRODUCT_RACKABLEDC) || defined(PRODUCT_LARA_BMC_TEST) || defined(PRODUCT_PDU) || defined(PRODUCT_ASMIDC) || (defined(PP_BOARD_KIRA) && defined(KIRA_CPE) && !defined(PRODUCT_RC1) && !defined(PRODUCT_LARAXP) ) || defined(PRODUCT_KX2)) && !defined(OEM_LENOVO)
# define PP_FEAT_CLP 1
#endif

/* Common Information Model (CIM) Server */
#if defined(PP_FEAT_CLP) || defined(PP_FEAT_WS_MANAGEMENT)
# define PP_FEAT_CIM 1
#endif

#if defined(PP_BOARD_LARA) || defined(PP_BOARD_KIRA) || defined(PP_BOARD_KXNG)
# define PP_FEAT_DEVICE 1
#endif

#if !defined(PRODUCT_MSIDC) && !defined(PRODUCT_SMIDC) && !defined(PRODUCT_KX2)
/* This feature currently only disables the visiblity of telnet in 
 * the webpages. The telnetd itself is still compiled and linked,
 * it simply is not started. */
# define PP_FEAT_TELNET 1
#endif

#if !defined(PRODUCT_MSIDC) && !defined(PRODUCT_KXNG) && !defined(PRODUCT_KX2)
/* This feature currently only disables the visiblity of ssh in 
 * the webpages. The sshd itself is still compiled and linked,
 * it simply is not started. */
# define PP_FEAT_SSH 1
#endif

/* Ethernet failover */
#if defined(PRODUCT_KX2)
# define PP_FEAT_ETHERNET_FAILOVER 1
#endif

/* Jumbo frame support */
#if defined(PRODUCT_KX2)
# define PP_FEAT_JUMBO_FRAME_SUPPORT 1
#endif

#if defined(PRODUCT_ICPMMD)
# define PP_FEAT_TERMINAL_SERVER 1
#endif

#if 0
/* add config option to disable web access for users */
#define PP_FEAT_DISABLE_WEBACCESS
#endif

#if (defined(PRODUCT_LARA) && !defined(KIRA_CPE)) || (defined(PRODUCT_LARAXP) && !defined(OEM_TANGTOP) && !defined(OEM_LANTRONIX)) || defined(PRODUCT_ERICXP) || defined(PRODUCT_ERICG4) || defined(PRODUCT_PDU) || defined(PRODUCT_XX01IP_ANY) || defined(PRODUCT_FORENSICCIM) || defined(PRODUCT_KX2) || defined(PRODUCT_LARA_BMC_TEST)
/* add config option to enable the raritan design*/
#define PP_FEAT_RARITAN_DESIGN 1
#endif

#if defined(OEM_BELKIN)
/* use pre-rendered GIF buttons instead of standard HTM buttons 
 * (you could use a ".button" section in style.asp to modify button design)
 */
#define PP_FEAT_IMAGE_BUTTONS 1
#endif

#if !defined(PP_FEAT_IPMI_SERVER) && (defined(PP_FEAT_RARITAN_DESIGN))
/* use checkboxes in front of the permission name instead of drop down lists behind the name */
#define PP_FEAT_USE_CHECKBOXES_FOR_ACL 1
#endif

#if defined(PRODUCT_KX2) || defined(PRODUCT_LARA_BMC_TEST)
/* this options only switches behaviour of tmpl_um_users.inc and tmpl_um_groups.inc
 * you must also use um_users.asp?user_table_view=1 & um_users.asp
 * and um_groups.asp?group_table_view=1 & um_groups.asp in your menu.def */
#define PP_FEAT_RARITAN_STYLE_UM_PAGES 1
#endif

#if defined(PRODUCT_KX2) || defined(PRODUCT_LARA_BMC_TEST)
/* add config option to disable asterisks on each page to indicate default values */
#define PP_FEAT_DISABLE_ASTERISK_TO_INDICATE_DEFAULT 1
#endif

#if defined(PRODUCT_KX2) || defined(PRODUCT_LARA_BMC_TEST)
/* add config option to display asterisks on webpages to indicate required fields */
#define PP_FEAT_DISPLAY_ASTERISK_TO_INDICATE_REQUIRED 1
#endif

#if defined(PRODUCT_RIPCKIMXN)
/* enables rpc config (master & slave kim) */
#define PP_FEAT_RPCCFG 1
#endif

#if defined(PRODUCT_FORENSICCIM)
# define PP_FEAT_SESSION_REDIRECTOR 1
#endif

#if !defined(LARA_KIMAMD) && !defined(KIRA_KIMAMDG4) && !defined(PRODUCT_ICPMMD) && !defined(LARA_KACY) && !defined(KXNG_VIA) && !defined(KXNG_INTEL) && !defined(KXNG_ATI128) && !(defined(KIRA_KIMG4) && defined(PRODUCT_XX01IP_ANY)) && !defined(KIRA_RPC) && !defined(KIRA_KIMASMIG4)
/* compress the kernel with bzip2, uncompressing is much slower
   but uses less space, only for linuxnew currently! */
# define PP_FEAT_KERNEL_COMPRESSION_BZIP2	1
# if defined(PP_FEAT_JFFS2_ROOTFS)
#    error Do not define PP_FEAT_JFFS2_ROOTFS & PP_FEAT_KERNEL_COMPRESSION_BZIP2!
# endif
#endif

#if !defined(KXNG_VIA) && !defined(KXNG_INTEL) && !defined(KXNG_ATI128)
# define PP_FEAT_PROPCHANGE     1
#endif /* !KXNG_VIA && !KXNG_INTEL && !KXNG_ATI128 */

#if !defined(KXNG_VIA) && !defined(KXNG_INTEL) && !defined(KXNG_ATI128)
# define PP_FEAT_HARDWAREREVISION  1
#endif /* !KXNG_VIA && !KXNG_INTEL && !KXNG_ATI128 */

#if !defined(KXNG_VIA) && !defined(KXNG_INTEL) && !defined(KXNG_ATI128)
# define PP_FEAT_CONFIGMODE     1
#endif /* !KXNG_VIA && !KXNG_INTEL && !KXNG_ATI128 */

#if !defined(KXNG_VIA) && !defined(KXNG_INTEL) && !defined(KXNG_ATI128)
# define PP_FEAT_TERMINAL_CONSOLE       1
#endif /* !KXNG_VIA && !KXNG_INTEL && !KXNG_ATI128 */

#if !defined(KXNG_VIA) && !defined(KXNG_INTEL) && !defined(KXNG_ATI128) && !defined(LARA_KACY)
# define PP_FEAT_SNMP_TRAP  1
#endif /* !KXNG_VIA && !KXNG_INTEL && !KXNG_ATI128 && !LARA_KACY */

#if !defined(KXNG_VIA) && !defined(KXNG_INTEL) && !defined(KXNG_ATI128) && !defined(LARA_KACY)
# define PP_FEAT_SNMP_TRAPD     1
#endif /* !KXNG_VIA && !KXNG_INTEL && !KXNG_ATI128 && !LARA_KACY*/

#if !defined(KXNG_VIA) && !defined(KXNG_INTEL) && !defined(KXNG_ATI128) && !defined(LARA_KACY)
# define PP_FEAT_SNMP_AGENT     1
#endif /* !KXNG_VIA && !KXNG_INTEL && !KXNG_ATI128 && !LARA_KACY*/

#if defined(LARA_KACY)
# define PP_FEAT_NETSNMP_TRAP  1
#endif /* LARA_KACY*/

#if defined(LARA_KACY)
# define PP_FEAT_NETSNMP_TRAPD     1
#endif /* LARA_KACY*/

#if defined(LARA_KACY)
# define PP_FEAT_NETSNMP_AGENT     1
#endif /* LARA_KACY*/

#if defined(LARA_KACY)
# define PP_FEAT_DIAGNOS     1
# define PP_FEAT_REMOTE_SYSLOG 1
#endif /* LARA_KACY*/

/* implemented for RAASIP but seems as we will not need that for KX2 */
// define PP_FEAT_HAS_DIALBACK

/* ----------------------------------------------------------------------------
 *  defines using PP_FEATs:
 *    - must be at the end of the file
 *    - don't use PRODUCT or OEM specific defines here!
 */

/* Drive Redirection in Java */
#if 1 && defined(PP_FEAT_DRIVE_REDIRECTION)
# define PP_FEAT_DRIVE_JAVA_REDIRECTION 1
#endif

#if !defined(__ASSEMBLER__) && !defined(__ASSEMBLY__) && !defined(__KERNEL__)
/* runtime check whether a feature is supported
   the feature must be submitted as string, e.g "PP_FEAT_RC1" */
int pp_feature_supported(char *feature);
#endif /* !__ASSEMBLER__ && !__ASSEMBLY__ && !__KERNEL__ */

/* copy some files from webpages dir to oem.tgz, should be used if initrd becomes
 * too large.
 * caution: if this is activated, firmware have to be created with oem_flashdisk_files.tgz
 */
#if defined(PRODUCT_SMIDC) || defined(KIRA_KIMAMDG4) || defined(KIRA_KIMASMIG4) || defined(PRODUCT_MSIDC) || defined(KIRA_CPE)
# define PP_FEAT_FILES_TO_FLASHDISK 1
#endif

/* copy translation files to flashdisk
 * caution: if this is activated, firmware have to be created with i18n_flashdisk_files.tgz
 */
#if defined(KIRA_KIMASMIG4) && (defined(OEM_INTEL) || defined(OEM_LENOVO))
# define PP_FEAT_I18N_TO_FLASHDISK 1
#endif

#if defined(PRODUCT_KX2) || defined(PRODUCT_ERICG4) || defined(PRODUCT_LARAXP)
# define PP_FEAT_RDM_SUPPORT 1
#endif

/* some features for the ever yesterday's ones.. ;-) *
 * will vanish soon... 
 * 
 * basically disable c++ usage for built
 */
#if !defined(PRODUCT_PDU) /* should be removed very soon... */
# define PP_FEAT_CPPUNIT_TEST 1
#endif

#if defined (PRODUCT_PDU)
# define PP_FEAT_PURE_C_ONLY  1
#endif

#endif /* !_PP_FEATURES_H */

