package nn.pp.drvredir;

import java.io.*;
import java.awt.*;

import nn.pp.rc.*;

class ConnectionHandlerDrive extends ConnectionHandler {
    DrvRedirNative drvNative;
    String drive;
    boolean readOnly;
    
    ConnectionHandlerDrive(RFBProfile prof, DrvRedirSettingsPanel panel, DrvRedirNative drvNative,
                           PrintStream logger, int msIndex, boolean readOnly) {
        super(prof, panel, drvNative, logger, msIndex);
        this.drvNative = drvNative;
        this.drive = drive;
        this.readOnly = readOnly;
    }
    
    static void debug(String s) {
        if (true) System.out.println(s);
    }
    
    void chooseDrive(Frame frame) throws IOException {
        DriveSelectionDialog dlg = new DriveSelectionDialog(frame, drvNative, logger, readOnly);
        dlg.show();
        
        if (dlg.ok) {
            drive = dlg.drive;
            writeSupport = dlg.writeSupport;
        } else {
            throw new IOException(T._("Cancelled Drive redirection"));
        }
    }
    
    void connect() throws Exception {
    	drvNative.initDriveRedirection();
    	drvNative.openDrive(drive);
    	drvNative.lockDriveAccess(false, true, false);
    	if (false) {
    	    drvNative.lockDriveRemoval(false);
    	}
    	
    	doConnect();
    }
    
    void disconnect() {
        doDisconnect();
        
    	if (false) {
    	    try {
    	    	drvNative.lockDriveRemoval(true);
    	    } catch (Exception ignore) { }
    	}
    	try {
    	    drvNative.lockDriveAccess(false, true, true);
    	} catch (Exception ignore) { }
    	try {
    	    drvNative.closeDrive();
    	} catch (Exception ignore) { }
    	drvNative.cleanupDriveRedirection();
    }
    
    void mediumRemovedForChange() throws Exception {
        drvNative.mediumRemovedForChange();
        proto.sendMediumRemoval();
    }
    
    void mediumInsertedAfterChange() throws Exception {
        // close the drive
        if (false) {
            drvNative.lockDriveRemoval(true);
        }
        drvNative.lockDriveAccess(false, false, true);
        drvNative.closeDrive();
        
        // open the drive again
        drvNative.openDrive(drive);
        drvNative.lockDriveAccess(false, false, false);
        if (false) {
            drvNative.lockDriveRemoval(false);
        }
        
        // medium change done
        drvNative.mediumInsertedAfterChange();

        proto.sendMediumChange();
    }
}
