package nn.pp.drvredir;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;

import nn.pp.rc.*;

public class DrvRedirPanel extends CloseablePanel implements FocusHandler {
    int msNo = 0;
    boolean readOnly = false;
    DrvRedirSettingsPanel settingsPanels[];
    Logger logpanes[];
    PrintStream loggers[];
    DrvRedirNative drvAccess[];
    Panel mainPanel;
    Label initLabel;
    URL codeBase;
    RFBProfile profile;
    public boolean codeLoaded = false;
    
    boolean debug = true;
    
    public DrvRedirPanel(URL codeBase, RFBProfile profile) {
    	this.profile = profile;
	this.codeBase = codeBase;
    	addLayout();
    	initLabel = new Label(T._("Please wait for the Drive Redirection to load."));
    	add(initLabel, BorderLayout.CENTER);
    }
    
    public void setNumberOfDrives(int msNo) {
        this.msNo = msNo;
	drvAccess = new DrvRedirNative[msNo];
    }
    
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }
    
    public void open(Frame frame) {
    	if (!codeLoaded) {
    	    try {
    	    	frame.pack();
    	    	//Thread.sleep(1000);
		for (int i = 0; i < msNo; i++) {
		    try {
		        drvAccess[i] = loadNativeCode(codeBase);
		    } catch (Exception e) {
		        System.out.println("Drive Redirection not possible: " + e);
		        drvAccess[i] = null;
		    }
		}
    	    	remove(initLabel);
    	    	loadPanels(profile);
    	    } catch (Exception e) {
    	    	System.out.println("Drive Redirection not possible: " + e);
    	    	remove(initLabel);
    	    	add(new Label(T._("Drive Redirection not available") + ": " + e.getMessage()), BorderLayout.CENTER);
    	    }
    	}
    	codeLoaded = true;
    }
    
    private void addLayout() {
    	setLayout(new BorderLayout());
    	
    	Label l = new Label(T._("Drive Redirection"), Label.CENTER);
    	l.setFont(new Font("Helvetica", Font.BOLD | Font.ITALIC, 14));
    	add(l, BorderLayout.NORTH);
    	mainPanel = new Panel(new GridLayout(msNo, 1));
    	
    	add(new Label(" "), BorderLayout.EAST);
    	add(new Label(" "), BorderLayout.WEST);
    }
    
    public void loadPanels(RFBProfile profile) {
    	settingsPanels = new DrvRedirSettingsPanel[msNo];
    	logpanes = new Logger[msNo];
    	loggers = new PrintStream[msNo];
    	
    	for (int i = 0; i < msNo; i++) {
    	    Panel panel = new Panel(new BorderLayout());
    	    
    	    logpanes[i] = new Logger("", this, debug);
    	    loggers[i] = logpanes[i].getPrintStream();
            
    	    settingsPanels[i] = new DrvRedirSettingsPanel(profile, loggers[i], msNo, i, drvAccess[i], readOnly);
    	    panel.add(settingsPanels[i], BorderLayout.NORTH);
            
    	    Panel logpaneContainer = new Panel();
    	    logpaneContainer.setLayout(new BorderLayout(3, 1));
    	    logpaneContainer.add(logpanes[i], BorderLayout.CENTER);
    	    // this is just for auto resizing the logger panel
    	    logpaneContainer.add(new Label(""), BorderLayout.EAST);
    	    
    	    panel.add(logpaneContainer, BorderLayout.CENTER);
    	    panel.add(new Label(" "), BorderLayout.SOUTH);
    	    
    	    mainPanel.add(panel);
    	}
    	
    	add(mainPanel, BorderLayout.CENTER);
    }
    
    private DrvRedirNative loadNativeCode(URL codeBase) throws Exception {
    	DrvRedirNative drvAccess = new DrvRedirNative(codeBase);
    	
    	if (!drvAccess.isSupportedByOSVersion()) {
    	    throw new IOException(T._("Windows Version not supported."));
    	}
    	
    	return drvAccess;
    }

    public void close() {
    	if (settingsPanels != null) {
    	    for (int i = 0; i < settingsPanels.length; i++) {
    	    	settingsPanels[i].close();
    	    }
    	}
    }

    public void setEnabled(boolean enabled) {
    	if (!enabled && settingsPanels != null) {
    	    for (int i = 0; i < settingsPanels.length; i++) {
    	    	settingsPanels[i].setEnabled(enabled);
    	    }
    	}
    	super.setEnabled(enabled);
    }
    
    public void handleFocus(Component c) {
    }
}
