package nn.pp.rc;

import java.awt.*;
import java.awt.image.*;
import java.io.*;

/**
 * Painter specialiced for java 1.1
 * @author Thomas Breitfeld, Peppercon AG
 * @version $Id: J11TrueColorRFBRenderer.java,v 1.3 2005-06-13 15:15:45 miba Exp $
 */
public class J11TrueColorRFBRenderer extends TrueColorRFBRenderer {

    private boolean repaint_done;

    public J11TrueColorRFBRenderer(Component comp) {
	super(comp);
    }	

    public void sendUpdateMsg() throws IOException {
	rfb.writeFullFramebufferUpdateRequest();
    }

    public void setRenderSize(Dimension d) {
	super.setRenderSize(d);
    	if(vimg != null) vimg.flush();
	if(gvimg != null) gvimg.dispose();
	vimg = comp.createImage(d.width, d.height);
	gvimg = vimg.getGraphics();
    }

    public void paint(Graphics g, boolean scale, Dimension scalesize) {
	if(vimg != null) {
	    paintContent(g, scale, scalesize);
	}
	synchronized(this) {
	    repaint_done = true;
	    notifyAll();
	}
    }

    /*
     * MS JVM blanck drawing operations in case we draw during a
     * repaint, so we will wait until the repaint is really done
     */
    public void repaint() {
	synchronized(this) {
	    comp.repaint();
	    repaint_done = false;
	    while(!repaint_done) {
		try { wait(); } catch(InterruptedException ignore) {}
	    }
	}
    }

    public void setInterpol(boolean ip) {
	// ignore
    }
    
    public String toString() {
	return getClass().toString();
    }
}
