package nn.pp.rc;

import java.awt.*;
import java.awt.event.*;
import java.io.*;

/**
 * Mouse button mask handler for Java >= 1.4
 */
public class J14MouseBtnMaskHandler {
    public int processMouseBtnEvent(MouseEvent e, int currBtns) {
	int btn = e.getButton();
	int btnMask = 0;
	int newBtns = 0;

	if (btn == e.BUTTON1) {
	    btnMask = 1;
	} else if (btn == e.BUTTON2) {
	    btnMask = 2;
	} else if (btn == e.BUTTON3) {
	    btnMask = 4;
	}

	if ((currBtns & btnMask) == 0) {
	    newBtns = currBtns | btnMask;
	} else {
	    newBtns = currBtns & ~btnMask;
	}

	return newBtns;
    }
}
