/**
* MenuLabel is a class that acts like a typical root menu
* item in some MenuBar but is actually only a Label
* so it can be mixed with other components as wanted
*
* created 11.11.2001 by Thomas Breitfeld, Peppercon AG
*/
package nn.pp.rc;

import java.awt.*;
import java.awt.event.*;

public class MenuLabel extends Label
    implements MouseListener, MouseMotionListener {

    private boolean over = false;
    private PopupMenu menu;

    public MenuLabel(PopupMenu m) {
  	super(m.getLabel(), Label.CENTER);
	m.setLabel(null);
	menu = m;
	registerActionListener(m, new MenuListener());
	add(menu);
	setBackground(SystemColor.control);
	addMouseListener(this);
	addMouseMotionListener(this);
    }

    private void registerActionListener(Menu m, MenuListener l) {
	for(int i=0; i<m.getItemCount(); ++i) {
	    MenuItem it = m.getItem(i);
	    if(it instanceof Menu) {
	    	registerActionListener((Menu)it, l);
	    } else if(it instanceof CheckboxMenuItem) {
	    	((CheckboxMenuItem)it).addItemListener(l);
	    } else {
	    	it.addActionListener(l);
    	    }
	}
    }

    public void paint(Graphics g) {
	super.paint(g);
	if(over) {
	    int w = getSize().width-1;
	    int h = getSize().height-1;
	    g.setColor(SystemColor.controlHighlight);
	    g.drawLine(0, 0, w, 0);
	    g.drawLine(0, 0, 0, h);
	    g.setColor(SystemColor.controlShadow);
	    g.drawLine(0, h, w, h);
	    g.drawLine(w, 0, w, h);
	}
    }

    public void update(Graphics g) {
	g.setColor(SystemColor.control);
	g.drawRect(0, 0, getSize().width-1, getSize().height-1);
	paint(g);
    }

    public void mouseEntered(MouseEvent e) {
	over = true;
	repaint();
    }
    public void mouseExited(MouseEvent e) {
	over = false;
	repaint();
    }
    public void mousePressed(MouseEvent e) {
	Label b = (Label)e.getSource();
	menu.show(b, 0, b.getSize().height);
    }
    public void mouseReleased(MouseEvent e) {}
    public void mouseClicked(MouseEvent e) {}
    public void mouseDragged(MouseEvent e) {}
    public void mouseMoved(MouseEvent e) {}

    /**
    * the MenuListener tries to catch any menu action
    * in order to reset the appearance of our MenuLabel
    */
    class MenuListener implements ActionListener, ItemListener {
    	public void actionPerformed(ActionEvent e) {
	    over = false;
	    repaint();
 	}
	public void itemStateChanged(ItemEvent e) {
	    over = false;
	    repaint();
	}
    }
}
