package nn.pp.rc;

import java.io.*;

public class MonitoringOutputStream extends DataOutputStream
                                    implements MonitoringStream {
    OutputStream out;
    int count;
    
    public MonitoringOutputStream(OutputStream out) {
	super(out);
	this.out = out;
    }

    public void write(int b) throws IOException {
	out.write(b);
	synchronized (this) {
	    count++;
	}
    }

    public void write(byte b[], int off, int len) throws IOException {
	out.write(b, off, len);
	synchronized (this) {
	    count += len;
	}
    }
    
    public void write(byte b[]) throws IOException {
    	write(b, 0, b.length);
    }
    
    public final void writeUnsignedShort(int s) throws IOException {
    	write((s >> 8) & 0xff);
    	write(s & 0xff);
    }

    public final void writeUnsignedInt(long s) throws IOException {
    	write((int)((s >> 24) & 0xff));
    	write((int)((s >> 16) & 0xff));
    	write((int)((s >> 8) & 0xff));
    	write((int)(s & 0xff));
    }

    synchronized public MonitorData getAndClearIn() {
	return new MonitorData(0);
    }
    
    synchronized public int getAndClearOut() {
	int ret = count;
	count = 0;
	return ret;
    }
}
