package nn.pp.rc;

import java.io.IOException;

/**
 * interface RCProto
 *
 * this collects some functions which are common in
 * RFB and RDP protocol classes
 *
 * implementing classes: RFBProto, RDPProto
 */

public interface RCProto {
    // close the connection
    public void close();
    
    // is a connection active?
    public boolean connected();

    // if true, mouse moves, keyboard events, and port switches will be blocked
    public void setMonitorMode(boolean val);
    
    // write a pointer event (needed by mouse handlers)
    public void writePointerEvent(boolean relative,
				  int x, int y, int z, int pointerMask)
				  throws IOException;
    
    public void writeMouseSyncEvent(byte subevent) throws IOException;
    
    // write a keyboard event
    public void writeKeyboardEvent(byte keycode) throws IOException;
}
