package nn.pp.rc;

import java.io.*;
import java.net.*;
import java.lang.*;
import java.util.*;

class RFBHandlerFactory {
    public static RFBHandler loadRfbHandler(RFBProfile profile, PrintStream logger) {
    	try {
            System.out.println("Reading protocol version from network.");
            
            RFBprotoVersionNegotiator neg = new RFBprotoVersionNegotiator(profile, logger);
            neg.establishConnection();
            
            String major = "" + neg.serverMajor;
            if (neg.serverMajor < 10) major = "0" + major;
            String minor = "" + neg.serverMinor;
            if (neg.serverMinor < 10) minor = "0" + minor;
            String className = "nn.pp.rc.RFBHandler_" + major + "_" + minor;
            
            RFBHandler handler = (RFBHandler)Class.forName(className).newInstance();
            handler.setProtocolVersion(neg.serverMajor, neg.serverMinor);
            handler.setSocket(neg.sock);
            handler.setSecDesc(neg.getSecDesc());
            
            return handler;
    	} catch (Throwable e) {
    	    e.printStackTrace();
    	}
    	
    	return null;
    }
}
