package nn.pp.rc;

import java.util.Date;
import java.awt.Color;

/**
 * RFBProfile is used to configure the RFB applet
 * application with respect to connection, protocoll
 * and grapical representations at the local system
 *
 * @author Thomas Breitfeld, Peppercon AG
 */
public class RFBProfile {
    /* ---------------------- host, port, connection type ---------------------------------*/

    /**
     * remote system to contact via the RFB protocol
     */
    public String remoteHost;

    /**
     * first port used for the rfb connection in case
     * there is no ssl available and required
     */
    public int primaryPort;

    /**
     * port to use in case ssl is available and 
     * required. This is the default behaviour
     */
    public int sslPort;

    /**
     * indicated whether the connection should be 
     * made using a secure connection exclusively
     */
    public boolean sslRequired;

    /**
     * indicated whether the connection should be 
     * made using a secure connection; however,
     * if no secure connection is available, an
     * insecure connection is allowed
     */
    public boolean sslRequested;

    /**
     * indicates whether the Profile contains a valid
     * proxy host and port setting what can be used 
     * in case the direct connnection to the remote
     * host goes wrong
     */
    public boolean useProxy;
    
    /**
     * the name of the proxy host to use in case a direct
     * connection fails
     */
    public String proxyHost;

    /**
     * the port number of the proxy host to use in case
     * a direct connection fails
     */
    public int proxyPort;

    /* ---------------------- target/port/channel to connect to -----------------------------*/

    /**
     * the port ID, sent to the server during init,
     * determines which port (video path) to connect to
     */
    public int portId;          /* former peppercon port id parameter */
    public String portIdRDM;    /* new rdm compliant (video) port id, will replace portId */
    public int channelId;	/* probably we should rename this to avoid confusion */
    public int targetId;	/* target number (kx2) */
    public boolean doInitSwitch;	/* indicates if initial switch is required (kx2) */
    
    /* ---------------------- authentication information ---------------------------------*/

    /**
     * the ID that is going to be used to contact the 
     * vnc server
     */
    public String connectId;
    
    /**
     * the login that is going to be used to contact the 
     * vnc server
     */
    public String username;
    public String password;

    /**
     * the rdm session that is going to be used to contact the 
     * vnc server
     */
    public String rdmSession;
    /**
     * the rdm connectionID for CC proxy mode connections.
     */
    public String rdmConnectionID;
    
    /* ---------------------- replay parameters (CC-F specific) ---------------------------------*/

    /**
     * replay console options
     */
    public int replaySessionID;
    
    public int replayCimId;
    public Date replayStartTime;
    public Date replayEndTime;

    /**
     * enable forensic console?
     */
    public boolean forensicConsole = false;
    public boolean forensicNoKeyboard = false;
    public boolean forensicFilterKeyboard = false;
        
    /* ---------------------- constructors and methods ---------------------------------*/

    /**
     * creates a new RFBProfile with default values.
     * The only value that has to be set after this 
     * constructor is the name of the remote host.
     */
    public RFBProfile() {
	this("",		// connectId
	     null,		// username
	     null,		// password
	     0,			// channelId
	     0,			// targetId
	     false,		// doInitSwitch
	     "",		// remoteHost
	     443,		// primaryPort
	     443,		// sslPort
	     false,		// sslRequired
	     false,		// useProxy
	     null,		// proxyHost
	     0,			// proxyPort
	     false,		// sslRequested
	     -1,		// replaySessionID
	     -1,		// replayCimId
	     null,		// replayStartTime
	     null		// replayEndTime
	     );
    }

    /**
     * creates a custom RFBProfile and requires any single
     * parameter to be set.
     * @see RFBProfile() for a default constructor
     */
    public RFBProfile(String connectId, String username, String password, int channelId, int targetId, boolean doInitSwitch, String remoteHost,
		      int primaryPort, int sslPort, boolean sslRequired,
		      boolean useProxy, String proxyHost, int proxyPort, boolean sslRequested,
		      int replaySessionID, int replayCimId, Date replayStartTime, Date replayEndTime) {
	this.connectId = connectId;
	this.channelId = channelId;
	this.targetId = targetId;
	this.doInitSwitch = doInitSwitch;
	this.username = username;
	this.password = password;
	this.remoteHost = remoteHost;
	this.primaryPort = primaryPort;
	this.sslPort = sslPort;
	this.sslRequired = sslRequired;
	this.useProxy = useProxy;
	this.proxyHost = proxyHost;
	this.proxyPort = proxyPort;
	this.sslRequested = sslRequested;
	this.replaySessionID = replaySessionID;
	this.replayCimId = replayCimId;
	this.replayStartTime = replayStartTime;
	this.replayEndTime = replayEndTime;
    }

    public String toString() {
	return ""
	    + "\nconnectId = " + connectId
	    + "\nusername = " + username
	    + "\nchannelId = " + channelId
	    + "\ntargetId = " + targetId
	    + "\ndoInitSwitch = " + doInitSwitch
	    + "\nremoteHost = " + remoteHost
	    + "\nprimaryPort = " + primaryPort
	    + "\nsslPort = " + sslPort
	    + "\nsslRequired = " + sslRequired
	    + "\nuseProxy = " + useProxy
	    + "\nproxyHost = " + proxyHost
	    + "\nproxyPort = " + proxyPort
	    + "\nsslRequested = " + sslRequested
	    ;
    }
}
