package nn.pp.rc;

public class RecordedSessionInfo {
    public final static int colorDepthUnknown    = 0x00;
    public final static int colorDepth1BitBW     = 0x01;
    public final static int colorDepth2BitGrey   = 0x02;
    public final static int colorDepth3BitGrey   = 0x03;
    public final static int colorDepth4BitGrey   = 0x04;
    public final static int colorDepth4BitColor  = 0x05;
    public final static int colorDepth7BitColor  = 0x06;
    public final static int colorDepth15BitColor = 0x07;
    
    public final static int keyboardNormal       = 0x00;
    public final static int keyboardNoKbd        = 0x01;
    public final static int keyboardFilter       = 0x02;
    public final static int keyboardAllFilterPb  = 0x03;
    
    public int colorDepth;
    public int keyboardMode;
    public boolean useJpeg;
    public int jpegLevel;
    public boolean useZlib;
    public int zlibLevel;
    public int keyframeInterval;
    public String hostName;
    public String hostAddress;
    
    public RecordedSessionInfo() {
        this.colorDepth = colorDepthUnknown;
        this.keyboardMode = keyboardNormal;
        this.useJpeg = false;
        this.jpegLevel = 100;
        this.useZlib = false;
        this.zlibLevel = 0;
        this.keyframeInterval = 0;
        this.hostName = T._("no host");
        this.hostAddress = T._("no address");
    }
    
    public RecordedSessionInfo(int colorDepth, int keyboardMode, boolean useJpeg, int jpegLevel,
                               boolean useZlib, int zlibLevel, int keyframeInterval, String hostName,
                               String hostAddress) {
        this.colorDepth = colorDepth;
        this.keyboardMode = keyboardMode;
        this.useJpeg = useJpeg;
        this.jpegLevel = jpegLevel;
        this.useZlib = useZlib;
        this.zlibLevel = zlibLevel;
        this.keyframeInterval = keyframeInterval;
        this.hostName = hostName;
        this.hostAddress = hostAddress;
    }
    
    public String getColorDepth() {
        switch (colorDepth) {
            case colorDepth1BitBW:
                return T._("1 Bit b/w");
            case colorDepth2BitGrey:
                return T._("2 Bit grey");
            case colorDepth3BitGrey:
                return T._("3 Bit grey");
            case colorDepth4BitGrey:
                return T._("4 Bit grey");
            case colorDepth4BitColor:
                return T._("4 Bit colored");
            case colorDepth7BitColor:
                return T._("7 Bit colored");
            case colorDepth15BitColor:
                return T._("15 Bit colored");
            case colorDepthUnknown:
            default:
                return T._("unknown");
        }
    }
    
    public String getKeyboardMode() {
        switch (keyboardMode) {
            case keyboardNormal:
                return T._("Normal");
            case keyboardNoKbd:
                return T._("No keyboard");
            case keyboardFilter:
                return T._("Filtered");
            case keyboardAllFilterPb:
                return T._("Normal with filtered playback");
            default:
                return T._("unknown");
        }
    }
    
    public String getUseJpeg() {
        return useJpeg ? T._("true") : T._("false");
    }
    
    public String getJpegLevel() {
        return useJpeg ? ("" + jpegLevel + "%") : T._("n/a");
    }
    
    public String getUseZlib() {
        return useZlib ? T._("true") : T._("false");
    }
    
    public String getZlibLevel() {
        return useZlib ? ("" + zlibLevel) : T._("n/a");
    }
    
    public String getKeyframeInterval() {
        return "" + keyframeInterval + " " +  T._("seconds");
    }
}
