package nn.pp.rc;

import java.applet.*;
import java.awt.*;
import java.text.*;
import java.awt.image.ImageObserver;
import java.net.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import java.beans.PropertyChangeEvent;
import nn.pp.rckbd.*;

public class RemoteConsoleLoader extends Panel {
    ParameterReader reader;
    StateMessageInterface stateMessenger;
    
    ServerConsolePanelBase scpanel = null;
    ServerConsoleFrame scframe = null;
    boolean inFrame;
    
    RemoteConsoleLoader(ParameterReader reader, StateMessageInterface stateMessenger) {
    	this.reader = reader;
    	this.stateMessenger = stateMessenger;
    }
    
    public void destroy() {
	if(scframe != null) scframe.close();
	else scpanel.close();
	scpanel = null; // just in case applet ref gets not released
	TimerQueue.cleanUp();
    }
    
    public void setOnCloseURL(String url, String target) {
    	if (scframe != null) {
    	    scframe.setOnCloseURL(url, target);
    	}
    }
    
    public boolean displayStateMsg() {
    	if (scpanel != null) {
    	    return scpanel.displayStateMsg();
    	} else {
    	    return false;
    	}
    }
    
    public int adjustStateMsgPos(int height) {
    	if (scpanel != null) {
    	    return scpanel.adjustStateMsgPos(height);
    	} else {
    	    return 0;
    	}
    }

    public void init(boolean inFrame) throws Exception {
    	init(inFrame, null, null);
    }
    
    public void init(boolean inFrame, URL codeBase, AppletContext appletContext) throws Exception {
    	this.inFrame = inFrame;
    	String s;

	KbdFactory.applet_codebase = codeBase;
	JVMVersionInfo verInfo = JVMVersionInfo.getJVMVersionInfo();
	
	//printMemInfo("rca init... ");
	setLayout(new BorderLayout());

	// parse all applet params and construct our graphics
	RFBProfile profile = readProfile();
	    
	// HACK: getLocale raises an exception if the applet is not yet
	//       added to a containment hierarchy such that the locale can
	//       be determined from the containing parent.
	//       Sometimes this is triggered if an applet is closed and
	//       started again. A possible workaround might be to wait until
	//       we have a parent but this seems not to work. Now we call
	//       getLocale() in a loop until it returns normally or a timeout
	//       occurs.
	Locale loc = null;
	for (int i = 0; i < 10; i++) {
	    try {
		loc = getLocale();
		break;
	    } catch (IllegalComponentStateException icse) {
		try { Thread.sleep(500); } catch(Exception e) {}
	    }
	}
	
	if (loc == null) {
	    loc = Locale.US;
	}

	scpanel = ServerConsolePanelFactory.createPanel();
	scpanel.init(codeBase, getClass().getClassLoader(), inFrame, stateMessenger, verInfo, loc);

	if(inFrame) { // yes, extra frame
	    String cluster_port_id = reader.readParameter("CLUSTER_PORT_ID", false);
	    String channel_id = reader.readParameter("CHANNEL_ID", false);
	    String title_extension = "";

	    if (cluster_port_id == null) cluster_port_id = "";
	    if (channel_id == null) channel_id = "";	    

	    if (!cluster_port_id.equals("")) {
		title_extension = " (" + T._("Port") + " " + cluster_port_id + ")";
	    } else if (!channel_id.equals("")) {
		title_extension = " (" + T._("Channel") + " " + String.valueOf(Integer.parseInt(channel_id) + 1) + ")";
	    }

	    title_extension += " - " + profile.remoteHost;
	    
	    String boardname = reader.readParameter("BOARD_NAME", false);
	    if (boardname == null) boardname = profile.remoteHost;
	    
	    scframe = new ServerConsoleFrame(codeBase, appletContext, getClass().getClassLoader(),
					     profile, boardname, title_extension,
					     scpanel);
	    scpanel.setSCFrame(scframe);
	    scframe.addNotify();
	    scframe.pack();
	    scframe.show();
	} else {                           // we use the applet graphics
	    add(scpanel, BorderLayout.CENTER);
	    scpanel.canvasSizeChanged(new Dimension(getSize()));
	}
	scpanel.start(profile);
    }

    // the alt param desides whether to read the standard or
    // the alternate rfb profile. The alternate RFB profile
    // will be used for direct RFB connections to the host
    private RFBProfile readProfile() throws Exception {
	RFBProfile prof = new RFBProfile();

        /* parse host, port, connection type */
	try {
	    prof.primaryPort = Integer.parseInt(reader.readParameter("PORT", false));
	    prof.sslPort = Integer.parseInt(reader.readParameter("SSLPORT", false));
	} catch (Exception ignore) {}
	
	prof.remoteHost = reader.readParameter("HOST", false);
	if(prof.remoteHost == null)
	    prof.remoteHost = reader.getRemoteHost();
	prof.proxyHost = reader.readParameter("PROXY_HOST", false);
	try { 
	    prof.proxyPort=Integer.parseInt(reader.readParameter("PROXY_PORT", false));
	} catch(Exception ignore) {}
	if(prof.proxyHost != null && prof.proxyPort != 0) 
	    prof.useProxy = true;
	String s = reader.readParameter("SSL", false);
	if(s != null && s.equals("force")) prof.sslRequired = true;
	if(s != null && s.equals("try")) prof.sslRequested = true;

        /* parse target/port/channel to connect to */
	try {
	    prof.channelId = Integer.parseInt(reader.readParameter("CHANNEL_ID", false));
	} catch(Exception ignore) {}

	try {
	    prof.targetId = Integer.parseInt(reader.readParameter("TARGET_ID", false));
	} catch(Exception ignore) {}

	String initSwitchS = null;
	try {
	    initSwitchS = reader.readParameter("DO_INIT_SWITCH", false);
	} catch(Exception ignore) {}
	prof.doInitSwitch = ((initSwitchS != null) && initSwitchS.equals("yes")) ? true : false;

        /* parse authentication information */
	if (reader.readParameter("connection", false) != null) {
	        /*
		System.out.println("IPAddress = " + reader.readParameter("connection.IPAddress", false));
		System.out.println("TCPPort   =   " + reader.readParameter("connection.TCPPort", false));
		System.out.println("SessionID =   " + reader.readParameter("connection.SessionID", false));
		System.out.println("SessionKey=   " + reader.readParameter("connection.SessionKey", false));
		System.out.println("ID =   " + reader.readParameter("connection.ID", false));
		System.out.println("ConnectionID =   " + reader.readParameter("connection.ConnectionID", false));
		*/

		// read RDM referral session parameters
		int remoteTCPPort = 0;
		int remoteIP = 0;
		String rdmSession;
		String remoteHost;
		String remoteKVMPort;
		String connectionID;
		try {
		    remoteTCPPort = Integer.parseInt(reader.readParameter("connection.TCPPort", false));
		    remoteIP = Integer.parseInt(reader.readParameter("connection.IPAddress", false));
		} catch (Exception ignore) {}
		
		rdmSession = "\"" + reader.readParameter("connection.SessionID", false) + "\":\"" +
		                    reader.readParameter("connection.SessionKey", false) + "\"";
		remoteHost = "" +
		             ((remoteIP >> 24) & 0xFF) + "." + 
		             ((remoteIP >> 16) & 0xFF) + "." + 
		             ((remoteIP >> 8) & 0xFF) + "." + 
			      (remoteIP & 0xFF);
		remoteKVMPort = reader.readParameter("connection.ID", false);
		connectionID = reader.readParameter("connection.ConnectionID", false);
		
		if ((remoteTCPPort != 0) && (remoteIP != 0)) {
		    prof.rdmSession = rdmSession;
		    prof.remoteHost = remoteHost;
		    prof.primaryPort = remoteTCPPort;
		    prof.portIdRDM = remoteKVMPort;
		    prof.rdmConnectionID = connectionID;
		    
		    //System.out.println("setting profile to rfb values");
		}
	}

	prof.connectId = reader.readParameter("SESSION_ID", false);
	prof.username = reader.readParameter("username", false);
	prof.password = reader.readParameter("password", false);
	if ((prof.connectId == null) &&
	    ((prof.username == null) || (prof.password == null)) &&
	    (prof.rdmSession == null))
	{
	    reader.parameterError("No authentication parameters found");
	}
	
        /* parse replay parameters (CC-F specific) */
	try {
	    prof.replaySessionID = Integer.parseInt(reader.readParameter("REPLAY_SESSION", false));
	} catch (Exception ignore) {}
	
	try {
	    prof.replayStartTime = new Date(Long.parseLong(reader.readParameter("REPLAY_START", false)) / 1000);
	    prof.replayEndTime = new Date(Long.parseLong(reader.readParameter("REPLAY_END", false)) / 1000);
	    prof.replayCimId = Integer.parseInt(reader.readParameter("REPLAY_CIM", false));
	} catch (Exception ignore) {}

	s = reader.readParameter("FORENSIC_CONSOLE", false);
	if(s != null && s.equals("yes")) prof.forensicConsole = true;
	s = reader.readParameter("FORENSIC_NOKBD", false);
	if(s != null && s.equals("yes")) prof.forensicNoKeyboard = true;
	s = reader.readParameter("FORENSIC_FILTERKBD", false);
	if(s != null && s.equals("yes")) prof.forensicFilterKeyboard = true;

	return prof;
    }
}
