package nn.pp.rc;

import java.lang.reflect.*;
import java.util.*;
import java.text.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;
import java.beans.*;
import nn.pp.rckbd.*;
import nn.pp.drvredir.*;

/**
 * The ServerConsolePanel is the main Panel of the
 * Remote Console displaying all the controls.
 * In order to contact a server the Frame has to be
 * made working using the work method that requires
 * a profile parameter defining all protocol specific
 * parameters
 */
abstract public class ServerConsolePanelBase
    extends Panel
    implements FocusHandler, ItemListener, ActionListener
{

    public class TrafficLabel extends FixedLabel {
	TrafficLabel() {
	    super(T._("   Fps: 88 In: 8888 KB/s Out: 888 KB/s "));
	}
    }

    private static final int MOUSE_MODE_ABSOLUTE = 0;
    private static final int MOUSE_MODE_INTELLI = 1;
    private static final int MOUSE_MODE_STANDARD = 2;

    public  final static boolean debug = false;
    public  static String defkbd;
    private final static int SPRIM = 4; //border needed around scrollpane
    private MenuItem sc100;
    private MenuItem sc50;
    private MenuItem sc25;
    private MenuItem sc2fit;
    private MenuItem scfilter;
    private MenuItem currentScale = sc100;
    private Menu laymi;
    private Menu mapmi;
    private MenuItem hardmapmi;
    private String curlayout;
    private Locale locale;
    private Locale curmapping;
    private Locale curhardmapping;
    private boolean showReduced = false;
    private boolean useScrollPane = false;
    private boolean truecolor = false;
    private ButtonPanel buttonpane;
    private String buttonpane_loc;
    private KeyEventHandler keh;
    private Window softkbdwin = null;
    private SoftKbd softkbd = null;
    private RFBProfile profile;
    private Component sccpanel;
    private Panel scp;
    private ScrollPane sccsp;
    private ChatFrame chat;
    private String boardname;
    private MenuItem cursormi;
    private Image imageButtons;
    private Image wlanimageButtons;
    private Image sharemodeButtons;
    private CheckboxMenuItem itemRO;
    private CheckboxMenuItem itemVNC;	// thre: FIXME: comment all itemVNC appearances out
    private CheckboxMenuItem itemExcl = null;
    private CheckboxMenuItem itemChat;
    private CheckboxMenuItem itemSoftKbd;
    private CheckboxMenuItem itemVideoSettings;
    private ImageButton btnRO = null;
    private ImageButton btnWL = null;
    private ToolTip btnWLToolTip = null;
    private ImageButton btnSM = null;
    private Dimension btnDim;
    private MenuItem miMouseSyncFast;
    private MenuItem miMouseSyncHard;
    private MenuItem miMouseSingle; /* single mouse mode */
    private MenuItem miMouseDouble; /* double mouse mode */
    private MenuItem miMouseAbsolute;
    private MenuItem miMouseIntelligent;
    private MenuItem miMouseStandard;
    private MenuItem miVideoRefresh;
    private int mouseMode = MOUSE_MODE_INTELLI;
    private Menu mMouse;
    private Menu mMouseMode;
    private Menu kbd;
    private Menu encodingMenu;
    private Menu fixSubMenu;
    private Menu compSubMenu;
    private Menu colorSubMenu;
    private CheckboxMenuItem lossymi = null;
    private MenuItem mScreenshot;
    protected boolean showEncodingMenu = true;
    protected boolean showSoftKbdMenu = true;
    protected boolean showHotkeys = true;
    private String synckey;
    protected boolean bneedmouse;
    protected boolean vs_type_full;
    private VideoSettingsFrame vsframe = null;
    private boolean monitorModeOn;
    private boolean monitorPerm;
    private boolean exclusiveAccessPerm = false;
    private boolean exclusiveAccessOn = false;
    private PopupMenu optionmenu;
    private TrafficLabel trafficlabel;
    int drvRedirIndex = 0;
    protected ImageButton btnDrvRedir = null;
    protected ImageButton btnMouseSync;
    protected ToolTip btnMouseSyncToolTip = null;
    protected ImageButton btnMouseMode;
    protected ToolTip btnMouseModeToolTip = null;
    protected ImageButton btnAA;
    protected ImageButton btnForensic = null;
    protected ToolTip btnAAToolTip = null;
    protected PopupMenu hotkey_menu;
    protected PopupMenu kvmkey_menu;
    protected Label menu;
    protected Panel stdbtnpane;
    protected Panel stdbtnpanecontent[];
    protected Panel ctrlpane;
    protected Panel statusbar;
    protected Panel menupane;
    protected Logger logpane;

    private URL codeBase;
    private ClassLoader classLoader;
    private boolean inFrame;
    ServerConsoleFrame scframe = null;

    RCCanvasPanel  console;
    RFBHandler     primeRFBHandler;
    RFBHandler     currentRFBHandler;
    MouseHandler   mhandler, mhandler_abs, mhandler_rel=null;
    PrintStream    logger;
    TrafficMonitor traffic;
    CustomCursor   cursors;
    CursorType	   currentCursor;
    DrvRedirPanel  drvRedirPanel = null;

    private boolean is_wlanEnabled;
    private String softKbdMapping;
    private String localKbdMapping;
    private String kbdLayout;
    private JVMVersionInfo verInfo;
    private StateMessageInterface stateMessenger;
    ForensicPanel  forensicPanel;

    private boolean exclusive = false;
    private boolean showDriveRedirection = false;
    private boolean showForensic = false;
    private int userscount = 0;

    private CheckboxMenuItem itemRFB;
    private String noRelativeMouseHandlerReason = null;
    private SCPFocusHandler focusHandler;

    // full screen stuff
    GraphicsDevice graphicsDevice;
    DisplayMode orgdm;
    Frame fullFrame;
    boolean isFullScreenMode = false;

    /**
     * Constructs the complete Panel with all elements
     * without trying to do an actual connection to a
     * server.
     * After the Panel has been constructed it can be
     * displayed.
     * In order to connect to a server it needs to be
     * activated by callling the work method.
     * it can be deactivated using the stopwork method
     * though the frame will stay visible unless it will
     * be disposed
     */
    public ServerConsolePanelBase() {};

    protected void LoadROButton(boolean monitorMode) {
    	btnRO = new ImageButton(imageButtons, btnDim, (monitorMode) ? 5 : 4, true);
    }

    protected void LoadWLButton() {
    	btnWL = new ImageButton(wlanimageButtons, btnDim, 0, true);
    }

    protected void LoadSMButton() {
    	btnSM = new ImageButton(sharemodeButtons, btnDim, 0, true);
    }

    public void init(URL codeBase, ClassLoader classLoader, boolean inFrame,
		     StateMessageInterface stateMessenger,
		     JVMVersionInfo verInfo, Locale locale) {

	ActionListener atl;
	ItemListener itl;
	Integer  mIndex;

	this.codeBase = codeBase;
	this.classLoader = classLoader;
	this.inFrame = inFrame;
	this.stateMessenger = stateMessenger;
	this.locale = locale;
	this.verInfo = verInfo;

	setLayout(new BorderLayout());
	ctrlpane = new Panel(new BorderLayout());
	ctrlpane.setBackground(SystemColor.control);
	menupane = new Panel(new BorderLayout());
	stdbtnpane = new Panel(new BorderLayout());
	stdbtnpanecontent = new Panel[2];
	stdbtnpanecontent[0] = new Panel(new BorderLayout());
	stdbtnpanecontent[1] = new Panel(new BorderLayout());
	stdbtnpane.add(stdbtnpanecontent[0], BorderLayout.WEST);
	stdbtnpane.add(stdbtnpanecontent[1], BorderLayout.EAST);

	// load the correct focusHandler for 11 or 14
	if (verInfo.isJava14()) {
	    focusHandler = new J14SCPFocusHandler();
	} else {
	    focusHandler = new J11SCPFocusHandler();
	}

	keh = new KeyEventHandler(KbdFactory.getInstance().
				  getKbdLayout("pc104"));

	// logger
	logpane = new Logger("", this, redirectLogger());
	logger = logpane.getPrintStream();

	// preparate image buttons
	btnDim = new Dimension(30, 26);
	ImageLoader imgloader = new ImageLoader(codeBase);
	imageButtons = imgloader.loadImage("nn/pp/rc/buttons.gif");

	// preparate image buttons
	wlanimageButtons = imgloader.loadImage("nn/pp/rc/wlanbars.gif");

	// preparate image buttons
	sharemodeButtons = imgloader.loadImage("nn/pp/rc/sharemode.gif");

	statusbar = new Panel(new BorderLayout());
	statusbar.add(logpane, BorderLayout.CENTER);
	statusbar.add(new Label(""), BorderLayout.EAST);

	// start traffic monitor
	traffic = new TrafficMonitor(this);

	// create RFB canvas panel
	console = new RCCanvasPanel(this, locale, logger, 640, 480);

	// build gui
	scp = new Panel(new BorderLayout());
	sccsp = new ScrollPane(ScrollPane.SCROLLBARS_AS_NEEDED);
	add(scp, BorderLayout.CENTER);
	useScrollPane(true, false);

	placeStatusBar();

	enableEvents(ComponentEvent.COMPONENT_RESIZED);
    }

    void setDrvRedirPanel(DrvRedirPanel p) {
    	drvRedirPanel = p;
    }
    
    synchronized void createButtonsAndMenu() {
	this.boardname = currentRFBHandler.params.boardname;
        this.bneedmouse = currentRFBHandler.params.use_iip;
	this.monitorPerm = currentRFBHandler.params.monitorPerm;
	this.monitorModeOn = currentRFBHandler.params.monitorOn;
	this.exclusiveAccessPerm = currentRFBHandler.params.exclusivePerm;
	this.exclusiveAccessOn = currentRFBHandler.params.exclusiveOn;
	this.synckey = currentRFBHandler.params.synckey;
	this.vs_type_full = currentRFBHandler.params.vs_type_full;
	this.softKbdMapping = currentRFBHandler.params.softKbdMapping;
	this.localKbdMapping = currentRFBHandler.params.localKbdMapping;
	this.is_wlanEnabled = currentRFBHandler.params.isWlanEnabled;
        
        if (boardname != null && scframe != null) {
            scframe.setBoardName(boardname);
        }
        
        currentRFBHandler.rdr.setOSDColorAndPosition(currentRFBHandler.params.osdBgColor,
            currentRFBHandler.params.osdFgColor, currentRFBHandler.params.osdAlpha,
            currentRFBHandler.params.osdPosition);
        
	// initialize keyboard handler with default layout
	if (kbdLayout == null) {
            defkbd = currentRFBHandler.rfbProto.kbdlayout;
            if (( defkbd == null ) || ( defkbd.length() < 2 ))
                defkbd = "pc104";
            if (( defkbd == null ) || ( defkbd.length() < 2 ))
                defkbd = currentRFBHandler.params.kbdLayout;
            curlayout = defkbd;
            kbdLayout = defkbd;
        } else {
            curlayout = kbdLayout;
        }
	setSoftKbdLayout(curlayout);

	// drive redirection
	if (currentRFBHandler.params.driveRedirectionNoDrives > 0) {
	    drvRedirPanel.setNumberOfDrives(currentRFBHandler.params.driveRedirectionNoDrives);
	    drvRedirPanel.setReadOnly(currentRFBHandler.params.driveRedirectionForceReadOnly);
	    btnDrvRedir = new ImageButton(imageButtons, btnDim, 6);
	    btnDrvRedir.addActionListener(this);
	}

	// mouse handling
	if (bneedmouse) {
	    btnMouseSync = new ImageButton(T._("Sync"), imageButtons, btnDim, 2);
	    btnMouseSync.addActionListener(this);

	    btnMouseMode = new ImageButton(imageButtons, btnDim, 1);
	    btnMouseMode.addActionListener(this);
	}

	// local cursor shape
	cursors = new CustomCursor(currentRFBHandler.params.localcursor);
	currentCursor = cursors.getCurrentCursor();

	// read only indicator
	LoadROButton(currentRFBHandler.params.monitorOn);
	if (btnRO != null) {
	    btnRO.setEnabled(false);
	    btnRO.addMouseListener(new MouseAdapter() {
		public void mouseClicked(MouseEvent e) {
		    if(e.getClickCount() > 2) {
			if (e.isAltDown()) {
			    //change renderer somehow
			} else if (e.isMetaDown()) {
			    primeRFBHandler.switchFPS();
			} else {
			    console.debug = !console.debug;
			    logger.println(T._("Kbd Debug") + " "
					   + (console.debug ? T._("on") :
					                      T._("off")));
			}
		    }
		}
	    });
	}

	if (is_wlanEnabled) {
	    LoadWLButton();
	    if (btnWL != null) {
	    	btnWL.setEnabled(false);
	    	btnWL.setImageIndex(2); /* default to single */
	    }
	    btnWLToolTip = new ToolTip(T._("n/a"), btnWL);
	}

	LoadSMButton();
	if (btnSM != null) btnSM.setEnabled(false);

	// create video settings frame
	if (currentRFBHandler.params.vs_perms != 0) {
	    vsframe = new VideoSettingsFrame(this, boardname, logger, debug,
					     currentRFBHandler.params.monitorOn,
					     currentRFBHandler.params.vs_perms,
					     currentRFBHandler.params.vs_type_full);
	}

	// create hotkey and kvmkey menus
        kvmkey_menu = new HotkeyMenu(T._("KVM keys"), this, keh,
                                     currentRFBHandler.params.hotkeys,
				     currentRFBHandler.params.hotkeycodes,
				     currentRFBHandler.params.hotkeynames,
				     logger, true, currentRFBHandler.params.keypause);


	hotkey_menu = new HotkeyMenu(T._("Hotkeys"), this, keh,
	                             currentRFBHandler.params.hotkeys,
				     currentRFBHandler.params.hotkeycodes,
				     currentRFBHandler.params.hotkeynames,
				     logger, false, currentRFBHandler.params.keypause);

	// create chatframe
	try {
	    chat = new ChatFrame(this, logger, codeBase);
	    currentRFBHandler.setChat(chat);
	} catch (Exception ignore) {}

	// create RFB canvas panel
        console.setParameters(currentRFBHandler.params.monitorOn,
                              currentRFBHandler.params.synckeycodes,
                              currentRFBHandler.params.fskeycodes, keh);

	// the Button Keys
	buttonpane = new ButtonPanel(this, keh, currentRFBHandler.params.hotkeys,
	                             currentRFBHandler.params.hotkeycodes,
				     currentRFBHandler.params.hotkeynames,
				     logger, currentRFBHandler.params.monitorOn,
				     currentRFBHandler.params.keypause);
	buttonpane.setPreferredWidth(console.getPreferredSize().width);

	// build the option menu
	optionmenu = new PopupMenu(T._("Options"));
	menu = new MenuLabel(optionmenu);
	populateMenu();

	if (showEncodingMenu && currentRFBHandler.params.encodingPerm) addEncodingMenu();

	// build standard button panel
	populateStdBtnPane();

	// load the mouse handler(s)
	mhandler = mhandler_abs = new MouseHandlerAbsolute(console, (ContentScalingInfo)console);
	noRelativeMouseHandlerReason = null;
	if (bneedmouse) {
	    if (verInfo.isJava13() &&
		synckey != null && synckey.length() > 0) {
		try {
		    mhandler_rel = new MouseHandlerRelative(console, (ContentScalingInfo)console, cursors,
							    logger, synckey);
		    switchMouseHandler(currentRFBHandler.params.exclusiveMouse);
		}
		catch (AWTException ignore) {
		    noRelativeMouseHandlerReason = new String("Relative mouse mode not supported");
		    System.out.println(noRelativeMouseHandlerReason);
		}
		catch (SecurityException ignore) {
		    noRelativeMouseHandlerReason = new String("Entering the single mouse mode is not possible\ndue to security restrictions in the Java VM.\nThe most common reason for the problem is\nan applet which is not trusted by the user.\n\nPlease try to restart your browser and\nanswer the question whether the applet should be\ntrusted with \"Yes\" or \"Always\".\nIf this does not help solving the problem,\nlook into the manual about other possible solutions.");
		    System.out.println(noRelativeMouseHandlerReason);
		}
	    }
	    if (mhandler_rel == null) {
		switchMouseHandler(false);
	    }
	} else {
	    console.setMouseHandler(mhandler);
	}
	currentRFBHandler.setMouseHandlers(mhandler_abs, mhandler_rel);
        console.setCursor(currentCursor.cursor);
	allowMouseHandling(!currentRFBHandler.params.monitorOn);

	// build gui
	useScrollPane(true, false);

	Component paneladd;
	paneladd = getCtrlPanelWest();
	if (paneladd != null) ctrlpane.add(paneladd, BorderLayout.WEST);
	paneladd = getCtrlPanelCenter();
	if (paneladd != null) ctrlpane.add(paneladd, BorderLayout.CENTER);
	paneladd = getCtrlPanelSouth();
	if (paneladd != null) ctrlpane.add(paneladd, BorderLayout.SOUTH);
	paneladd = getMenuPanelWest();
	if (paneladd != null) menupane.add(paneladd, BorderLayout.WEST);
	paneladd = getMenuPanelCenter();
	if (paneladd != null) menupane.add(paneladd, BorderLayout.CENTER);
	paneladd = getMenuPanelEast();
	if (paneladd != null) menupane.add(paneladd, BorderLayout.EAST);

	ctrlpane.add(menupane, BorderLayout.EAST);
	placeCtrlPane();

	statusbar = new Panel();
	Panel statusbar2 = new Panel();
	statusbar2.setLayout(new BorderLayout());
	statusbar.setLayout(new BorderLayout());
	Panel trayarea = new Panel();
	trafficlabel = new TrafficLabel();

	/* count all "tray" buttons */
	int cbtns = 0;
	if (btnRO != null) cbtns++;
	if (btnWL != null) cbtns++;
	if (btnSM != null) cbtns++;

	trayarea.setLayout(new GridLayout(1,cbtns));

	if (btnSM != null) trayarea.add(btnSM);
	if (btnRO != null) trayarea.add(btnRO);
	if (btnWL != null) trayarea.add(btnWL);

	statusbar2.add(trayarea, BorderLayout.EAST);
	statusbar2.add(trafficlabel, BorderLayout.WEST);

	statusbar.add(statusbar2, BorderLayout.EAST);
	statusbar.add(logpane, BorderLayout.CENTER);

	placeStatusBar();

	adjustGUIArbitrarily();
	
	adjustLayout();

    }

    ForensicPanel addForensicButton(boolean showEvents, boolean localOnly, boolean noKbd, boolean showReplay) {
    	ServerConsoleFrame parent = (ServerConsoleFrame)getParent();
    	forensicPanel = parent.addForensicPanel(showEvents, localOnly, noKbd, showReplay, kbdLayout);
    	if (forensicPanel == null) {
    	    return null;
    	}
    	btnForensic = new ImageButton(imageButtons, btnDim, 8);
    	statusbar.add(btnForensic, BorderLayout.WEST);
    	btnForensic.addActionListener(this);
    	switchForensic();
    	return forensicPanel;
    }

    Locale getCurMapping() {
    	return curmapping;
    }

    /*
     * get different parts of the panel top,
     * may be overridden in subclasses to change arragement of the GUI
     */
    protected Component getCtrlPanelWest() {
	if (showHotkeys && !verInfo.isPJava() &&
	    suggestButtonLocation(true).equals(BorderLayout.WEST)) {
	    return buttonpane;
	}
	return null;
    }
    protected Component getCtrlPanelCenter() {
	return null;
	//	return logpane;
    }
    protected Component getCtrlPanelSouth() {
	if (!verInfo.isPJava() &&
	    suggestButtonLocation(true).equals(BorderLayout.SOUTH)) {
	    return buttonpane;
	}
	return null;
    }
    protected Component getMenuPanelWest() {
	if (!verInfo.isPJava()) {
	    return stdbtnpane;
	}
	return null;
    }
    protected Component getMenuPanelCenter() {
	return menu;
    }
    protected Component getMenuPanelEast() {
	return null;
    }

    protected void placeCtrlPane() {
	add(ctrlpane, BorderLayout.NORTH);
    }

    protected void placeStatusBar() {
    	add(statusbar, BorderLayout.SOUTH);
    }

    /*
     * build the gui parts, to be overridden
     */
    abstract protected void populateMenu();
    abstract protected void populateStdBtnPane();

    /*
     * build single gui entries, to be called
     * from populate functions during creation
     */

    /* ------------- menu ------------------ */

    protected void addMonitorModeMenu() {
	if (monitorPerm) {
	    itemRO = createCBMenuItem(T._("Monitor Only"), this, monitorModeOn);
	    optionmenu.add(itemRO);
	}
    }

    protected void addExclusiveAccessMenu() {
	if(exclusiveAccessPerm) {
	    itemExcl = createCBMenuItem(T._("Exclusive Access"), this, exclusiveAccessOn);
	    optionmenu.add(itemExcl);
	}
    }

    protected void addInterpolationMenu() {
	if(verInfo.isJava13()) {
	    optionmenu.add(scfilter = createCBMenuItem(T._("Readability Filter"), this, false));
	}
    }

    protected void addScreenshotMenu() {
	if(verInfo.isJava13()) {
            mScreenshot = createMenuItem(T._("Screenshot to clipboard"), this);
            optionmenu.add(mScreenshot);
        }
    }

    protected void addScalingMenu() {
	Menu scale = new Menu(T._("Scaling"));
	scale.add(sc25= createCBMenuItem(T._("25%"), this, false));
	scale.add(sc50= createCBMenuItem(T._("50%"), this, false));
	scale.add(sc100 = createCBMenuItem(T._("100%"), this, true));
	scale.add(sc2fit = createCBMenuItem(T._("Scale to fit"), this, false));
	optionmenu.add(scale);
    }

    protected void addMouseHandlingMenu(boolean showMode) {
	if (bneedmouse) {
	    mMouse = new Menu(T._("Mouse Handling"));

	    miMouseSyncFast = createMenuItem(T._("Fast Sync") + " "
		       + ((synckey != null && synckey.length() > 0) ?
			  ("("+synckey+")") : ""), this);
	    miMouseSyncHard = createMenuItem(T._("Intelligent Sync"), this);

	    mMouseMode = new Menu(T._("Mouse Mode"));
	    miMouseSingle = createCBMenuItem(T._("Single Mouse Mode"), this, false);
	    mMouseMode.add(miMouseSingle);

	    if (showMode) {
	        miMouseAbsolute = createCBMenuItem(T._("Absolute Mouse Mode"), this, false);
	        miMouseIntelligent = createCBMenuItem(T._("Intelligent Mouse Mode"), this, true);
	        miMouseStandard = createCBMenuItem(T._("Standard Mouse Mode"), this, false);
                mMouseMode.add(miMouseAbsolute);
                mMouseMode.add(miMouseIntelligent);
                mMouseMode.add(miMouseStandard);
	    } else {
	        miMouseDouble = createCBMenuItem(T._("Double Mouse Mode"), this, true);
                mMouseMode.add(miMouseDouble);
	    }

	    mMouse.add(miMouseSyncFast);
	    mMouse.add(miMouseSyncHard);

	    mMouse.add(mMouseMode);

	    optionmenu.add(mMouse);
	}
    }
    protected void addLocalCursorMenu() {
	if (!verInfo.isPJava()) {
	    optionmenu.add(cursormi = createCBMenu(T._("Local Cursor"),
						   cursors.getCursors(),
						   this, currentCursor));
	}
    }
    protected void addChatMenu() {
	itemChat = createCBMenuItem(T._("Chat Window"), this, false);
	optionmenu.add(itemChat);
    }

    protected void addVideoSettings() {
	// LARA Video Settings
	itemVideoSettings = createCBMenuItem(T._("Video Settings"), this, false);
	optionmenu.add(itemVideoSettings);
	if (vsframe == null) itemVideoSettings.setEnabled(false);
    }

    protected void addVideoRefresh() {
	// Video Refresh
	miVideoRefresh = createMenuItem(T._("Refresh Video"), this);
	optionmenu.add(miVideoRefresh);
    }

    protected void addSoftKbdMenu() {
        String langCode;
	langCode = softKbdMapping;

	kbd = new Menu(T._("Soft Keyboard"));
	itemSoftKbd = new CheckboxMenuItem(T._("Show"));
	itemSoftKbd.addItemListener(this);
	kbd.add(itemSoftKbd);

	// softkbd settings
	if ( (langCode != null) && (langCode.length() > 3) )
	    curmapping = new Locale(langCode.substring(0,2),
				    langCode.substring(3));
	if ( curmapping == null )
	    curmapping = locale;

	/*kbd.add(laymi = createCBMenu(T._("Layout"), KbdFactory.getInstance().
				     getKbdLayoutNames(), itl, curlayout));
	*/
	kbd.add(mapmi = createCBMenu(T._("Mapping"),
	                             KbdFactory.getInstance().getKbdMappingNames(),
				     this, curmapping));
	if (showSoftKbdMenu) {
	    optionmenu.add(kbd);
	}
    }

    protected void addHardKbdMenu() {
        String langCode;
	langCode = localKbdMapping;

	if ( (langCode != null) && (langCode.length() > 3))
	    curhardmapping = new Locale(langCode.substring(0,2),
					langCode.substring(3));
	if ( curhardmapping == null )
	    curhardmapping = locale;

	console.setKbdLocale(curhardmapping);

	hardmapmi = createCBMenu(T._("Local Keyboard"),
	                         KbdFactory.getInstance().getKbdTranslatorNames(),
	                         this, curhardmapping);
	optionmenu.add(hardmapmi);
    }

    protected void addHotkeyMenu() {
	if (!inFrame) return;
	if (! ((HotkeyMenu)kvmkey_menu).isEmpty()) {
	    optionmenu.add(((HotkeyMenu)kvmkey_menu).getPlainMenu("KVM keys"));
	}
	if (! ((HotkeyMenu)hotkey_menu).isEmpty()) {
	    optionmenu.add(((HotkeyMenu)hotkey_menu).getPlainMenu("Hotkeys"));
	}
    }

    protected void addEncodingMenu() {
	RFBEncoding enc = currentRFBHandler.params.encoding;
	String[] names;

	encodingMenu = new Menu(T._("Encoding"));

	names = enc.getFixNames();
	fixSubMenu = new Menu(T._("Predefined"));
	for (int i = 0; i < names.length; i++) {
	    Object o = names[i];
	    String n = (o instanceof Locale) ?
		((Locale)o).getDisplayName() : T._(o.toString());

	    MenuItem mi = new MenuItem(n);
	    mi.addActionListener(this);
	    fixSubMenu.add(mi);
	}

	names = enc.getCompressionNames();
	compSubMenu = createCBMenu(T._("Compression"),
				   names, this, enc.getCurrentCompName());

	names = enc.getColorNames();
	colorSubMenu = createCBMenu(T._("Color Depth"),
				    names, this, enc.getCurrentColorName());

	encodingMenu.add(fixSubMenu);
	encodingMenu.add(compSubMenu);
	encodingMenu.add(colorSubMenu);
	if (enc.isHwSupported()) {
	    lossymi = createCBMenuItem(T._("Lossy"), this, enc.isLossy());
	    encodingMenu.add(lossymi);
	}

	optionmenu.add(encodingMenu);
	adjustEncodingSubmenus();
    }

    /* ------------- std button panel ------------------ */

    protected void addDrvRedirButton(int index, String location) {
	if (btnDrvRedir != null) {
	    drvRedirIndex = index;
	    stdbtnpanecontent[index].add(btnDrvRedir, location);
	}
    }

    void hideDrvRedirButton() {
	if (btnDrvRedir != null) {
	    stdbtnpanecontent[drvRedirIndex].remove(btnDrvRedir);
	}
    }

    protected void addAAButton(int index, String location) {
	btnAA = new ImageButton(imageButtons, btnDim, 3);
	btnAA.addActionListener(this);
	stdbtnpanecontent[index].add(btnAA, location);
	btnAAToolTip = new ToolTip(T._("Auto Adjust Video"), btnAA);
    }

    protected void addMouseSyncButton(int index, String location) {
	if (!verInfo.isPJava() && bneedmouse) {
	    stdbtnpanecontent[index].add(btnMouseSync, location);
	    btnMouseSyncToolTip = new ToolTip(T._("Synchronize Mouse"), btnMouseSync);
	}
    }

    protected void addMouseModeButton(int index, String location) {
	if (!verInfo.isPJava() && bneedmouse) {
	    stdbtnpanecontent[index].add(btnMouseMode, location);
	    btnMouseModeToolTip = new ToolTip(T._("Single/Double Mouse Mode"), btnMouseMode);
	}
    }

    /* --------------------- misc ----------------------- */
    protected void adjustGUIArbitrarily() {};
    protected boolean redirectLogger()   { return false; }
    public boolean displayStateMsg() { return true; }
    public int adjustStateMsgPos(int height) {
	return height-3;
    }

    /*
     * starts a RFBHandler Thread that connects to the
     * Profile and paints our canvas
     */
    public void start(RFBProfile profile) {
	this.profile = profile;
	currentRFBHandler = primeRFBHandler = RFBHandlerFactory.loadRfbHandler(profile, logger);

	if (currentRFBHandler == null) {
	    logger.println("Unable to load protocol handler!");
	    return;
	}

	currentRFBHandler.init(this, console, chat, traffic, vsframe,
		mhandler_abs, mhandler_rel, logger, profile);

	primeRFBHandler.connect();
	primeRFBHandler.proto.setMonitorMode(monitorModeOn);
    }

    /*
     * disconnects all active Handlers
     */
    public void stop() {
	primeRFBHandler.disconnect();
    }

    /**
     * this is the cleanup function that stops the current operation
     * and frees all resources associated with this frame
     */
    public void close() {
	stop();
	logpane.close();
	if (chat != null) chat.close();
	if (vsframe != null) vsframe.close();
	if(softkbdwin != null) {
	    softkbdwin.hide();
	    softkbdwin.dispose();
	}
    }

    /**
     * callback methods for the handler to notify about successful
     * connection or disconnection
     */
    public void connected(RCHandler handler) {
        console.setRCHandler(handler);
	createButtonsAndMenu();

	switchCtrlPaneButtons (true);
	menu.setEnabled(true);
	if (handler == primeRFBHandler) {
	    if (stateMessenger != null) stateMessenger.setStateMessage(true);
	    if(exclusiveAccessOn) try {
		primeRFBHandler.rfbProto.writeUserPropChangeEvent("exclusive", "on");
	    } catch (IOException ex) { ex.printStackTrace(); }
	}
	setShareIcon();
        changeMonitorState(currentRFBHandler.params.monitorOn);
    }

    public void disconnected(RCHandler handler) {
	switchCtrlPaneButtons (false);
	if (stateMessenger != null) stateMessenger.setStateMessage(false);
	setExclusive(itemRFB);
	setShareIcon();
    }

    /**
     * Switches the buttons in the control pane (at top) on and off.  This is
     * a helper method.
     */
    protected void switchCtrlPaneButtons (boolean switchOn) {
	// Disabling the whole control pane does not properly disable the
	// single buttons -> disable each button individually.
	if (btnMouseMode != null) {
	    btnMouseMode.setEnabled(switchOn);
	}
	if (btnAA != null) {
	    btnAA.setEnabled(switchOn);
	}
	if (btnMouseSync != null) {
	    btnMouseSync.setEnabled(switchOn);
	}
	if (btnDrvRedir != null) {
	    btnDrvRedir.setEnabled(switchOn);
	}
	menu.setEnabled(switchOn);
	// hot keys
	buttonpane.setEnabled(switchOn);
	// drive redirection
	if (drvRedirPanel != null) {
	    drvRedirPanel.setEnabled(switchOn);
	}
    }

    public void handleFocus(Component c) {
	focusHandler.handleFocus(console);
    }

    public void setTitle(String title) {
	trafficlabel.setText(title);
    }

    public void setSCFrame(ServerConsoleFrame scframe) {
	this.scframe = scframe;
    }

    //set to full screen mode
    private void fullScreenMode() {
        if ((scframe == null) || !verInfo.isJava14()) {
            return;
        }
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        graphicsDevice = env.getDefaultScreenDevice();
        orgdm = graphicsDevice.getDisplayMode();
        fullFrame = new Frame("Full Screen Mode");
        fullFrame.setUndecorated(true);
        sccsp.removeAll();
        scframe.setVisible(false);
        fullFrame.setLayout(new BorderLayout());
        fullFrame.add(console, BorderLayout.CENTER);
        graphicsDevice.setFullScreenWindow(fullFrame);
        //choose either way
        //graphicsDevice.setDisplayMode(orgdm);
        graphicsDevice.setDisplayMode(new DisplayMode(console.fbsize.width,
                                                      console.fbsize.height,
                                                      orgdm.getBitDepth(),
                                                      DisplayMode.REFRESH_RATE_UNKNOWN));
	handleFocus(null);
    }

    //set to windows mode
    private void windowScreenMode() {
        if ((scframe == null) || !verInfo.isJava14()) {
            return;
        }
        graphicsDevice.setFullScreenWindow(null);
        sccsp.add(console);
        Dimension d = scframe.getSize();
        //force redraw
        scframe.setSize(new Dimension(d.width,d.height+1));
        scframe.setSize(new Dimension(d.width,d.height));
        fullFrame.dispose();
        scframe.setVisible(true);
	handleFocus(null);
    }

    public void changeWindowMode(){
        if(isFullScreenMode){
            windowScreenMode();
            isFullScreenMode = false;
        }else{
            fullScreenMode();
            isFullScreenMode = true;
        }
    }

    /*
     * returns the size that is not taken up by other elements
     * like Buttons, statebars or something like that...
     */
    public Dimension getBlankSize() {
	Dimension myd = getSize();
	Dimension ctd = ctrlpane.getSize();
	Dimension stb = statusbar.getSize();
	return new Dimension(myd.width, myd.height - ctd.height - stb.height);
    }

    class J14GetGraphicsConfigurationHelper {
    	public Insets getScreenInsets(Frame f) {
    	    GraphicsConfiguration gc = f.getGraphicsConfiguration();
    	    return Toolkit.getDefaultToolkit().getScreenInsets(gc);
    	}
    }

    public void canvasSizeChanged(Dimension d) {
	Component p = useScrollPane == true ? (Component)sccsp : this;
	p.setSize(d.width + SPRIM, d.height + SPRIM);
	if (p instanceof java.awt.ScrollPane) {
	    /* here we set the scrollposition to 0,0
	       setting to 1,1 before is necessary to avoid a
	       bug in microsofts jvm (widget in the scrollpane is displayed
	       with an offset on top (white bar)), this fixes bug #367 */
	    sccsp.setScrollPosition(1,1);
	    sccsp.setScrollPosition(0,0);
	}
	buttonpane.setPreferredWidth(d.width);
	// in case we are in a Frame, call pack,
	// otherwise, just validate
	if(getParent() instanceof java.awt.Frame) {
	    Frame f = (Frame)getParent();
	    Dimension nd = f.getPreferredSize();
	    Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
	    if(verInfo.isJava14()) {
	    	// determine the non-usable desktop area
	    	Insets insets = new J14GetGraphicsConfigurationHelper().
		    getScreenInsets(f);
	    	sd.width -= (insets.left + insets.right);
	    	sd.height -= (insets.top + insets.bottom);
	    }
	    if(nd.width > sd.width) nd.width = sd.width;
	    if(nd.height > sd.height) nd.height = sd.height;
	    f.setSize(nd);
	}
	validate();
	handleFocus(null);
    }

    public void adjustLayout() {
	if (verInfo.isPJava()) return;

	if(buttonpane_loc != suggestButtonLocation(true)) {
	    ctrlpane.remove(buttonpane);
	    ctrlpane.add(buttonpane, suggestButtonLocation(false));
	}
    }

    public synchronized void processComponentEvent(ComponentEvent e) {
	if(buttonpane != null && e.getID() ==  ComponentEvent.COMPONENT_RESIZED) {
	    buttonpane.setPreferredWidth(getSize().width);
	}
	if (console != null) console.processEvent(e);
    }

    public void setSoftKbdLayout(String kbdlayout) {
	this.kbdLayout = kbdlayout;
	if(softkbd != null) softkbd.setLayout(kbdlayout);
	else keh.init(KbdFactory.getInstance().
		      getKbdLayout(kbdlayout));
	if (forensicPanel != null) forensicPanel.newKbdLayout(kbdlayout);
	if (softkbd != null) softkbd.setMapping(curmapping);
	if (forensicPanel != null) forensicPanel.newKbdMapping(curmapping);
    }

    // ---- private/protected methods ----

    protected String suggestButtonLocation(boolean renew) {
	// that's a first rough trial, not sure whether it's
	// that easy... we simply assume, buttons shouldn't take more
	// than half of the minimum canvas size of 640.
	// Otherwise, if we take a more adaptive scenario, it may
	// happen that the location changes with the size of the
	// canvans what is not necessarily intended either... let's see
	if(null == buttonpane_loc || renew) {
	    if(buttonpane.getPreferredSize().width > getMaxButtonPaneSize())
		buttonpane_loc = BorderLayout.SOUTH;
	    else
		buttonpane_loc = BorderLayout.WEST;
	}
	return buttonpane_loc;
    }

    protected int getMaxButtonPaneSize() {
	return 260;
    }

    private void showReduced(boolean so, boolean validate) {
	if (verInfo.isPJava()) return;
	if(so == showReduced) return;
	showReduced = so;
	if(showReduced) {
	    logpane.setTiny(true);
	    ctrlpane.remove(buttonpane);
	} else {
	    logpane.setTiny(false);
	    ctrlpane.add(buttonpane, suggestButtonLocation(false));
	}
	if(validate) validate();
    }

    private void useScrollPane(boolean sp, boolean validate) {
	if(sp == useScrollPane) return;
	useScrollPane = sp;
	if(useScrollPane) {
	    scp.remove(console);
	    Dimension d = console.getPreferredSize();
	    sccsp.setSize(d.width + SPRIM, d.height + SPRIM);
	    scp.add(sccsp,  BorderLayout.CENTER);
	    sccsp.add(console);
	} else {
	    sccsp.remove(console);
	    scp.remove(sccsp);
	    sccsp.setSize(0, 0);
	    scp.add(console, BorderLayout.CENTER);
	}
	if(validate) validate();
    }

    private MenuItem createMenuItem(String label, ActionListener l) {
	MenuItem i = new MenuItem(label);
	i.addActionListener(l);
	return i;
    }

    private CheckboxMenuItem createCBMenuItem(String label, ItemListener l,
					      boolean checked) {
	CheckboxMenuItem i = new CheckboxMenuItem(label, checked);
	i.addItemListener(l);
	return i;
    }

    private Menu createCBMenu(String label, Object[] names,
			      ItemListener l, Object def) {
	Menu m = new Menu(label);
	for(int i = 0; i<names.length; i++) {
	    Object o = names[i];
	    String n = (o instanceof Locale) ?
		((Locale)o).getDisplayName() : T._(o.toString());

	    CheckboxMenuItem mi = new MyCBMenuItem(n, o, o.equals(def));

	    mi.addItemListener(l);
	    m.add(mi);
	}

	return m;
    }

    /**
     * little helper for setting a CheckboxMenuItem as
     * the one and only check item in a row of such items
     */
    private void setExclusive(CheckboxMenuItem mi) {
	if (mi == null) return;

	Menu c = (Menu)mi.getParent();
	for(int i=0; i<c.getItemCount(); ++i) {
	    MenuItem _i = (MenuItem)c.getItem(i);
	    if (_i instanceof CheckboxMenuItem) {
	        CheckboxMenuItem ci = (CheckboxMenuItem)c.getItem(i);
	        if(ci != mi) ci.setState(false);
	    }
	}
	mi.setState(true);
    }

    private void allowMouseHandling(boolean allow) {
	if (bneedmouse) {
	    if (mhandler.needMouseHandling()) {
		if (btnMouseSync != null) btnMouseSync.setEnabled(allow);
		if (miMouseSyncFast != null) miMouseSyncFast.setEnabled(allow);
		if (miMouseSyncHard != null) miMouseSyncHard.setEnabled(allow);
	    }
	}
    }

    private void switchMouseHandler(boolean relative) {
	if (relative) {
	    mhandler = mhandler_rel;
	    setExclusive((CheckboxMenuItem)miMouseSingle);
	} else {
	    mhandler = mhandler_abs;
	    if (miMouseDouble == null) {
	        MenuItem mi = miMouseIntelligent;
	        switch (mouseMode) {
	            case MOUSE_MODE_ABSOLUTE:
	                mi = miMouseAbsolute;
	                break;
	            case MOUSE_MODE_INTELLI:
	                mi = miMouseIntelligent;
	                break;
	            case MOUSE_MODE_STANDARD:
	                mi = miMouseStandard;
	                break;
	        }
	        setExclusive((CheckboxMenuItem)mi);
	    } else {
	        setExclusive((CheckboxMenuItem)miMouseDouble);
	    }
	}

	if (mhandler.needMouseHandling()) {
	    if (miMouseSyncFast != null) miMouseSyncFast.setEnabled(!monitorModeOn);
	    if (miMouseSyncHard != null) miMouseSyncHard.setEnabled(!monitorModeOn);
	    if (btnMouseSync != null) btnMouseSync.setEnabled(!monitorModeOn);
	    if (mhandler_rel != null) btnMouseMode.setImageIndex(1);
	} else {
	    if (miMouseSyncFast != null) miMouseSyncFast.setEnabled(false);
	    if (miMouseSyncHard != null) miMouseSyncHard.setEnabled(false);
	    if (btnMouseSync != null) btnMouseSync.setEnabled(false);
	    if (mhandler_rel != null) btnMouseMode.setImageIndex(0);
	}

	console.setMouseHandler(mhandler);
	// if setting the relative mouse, just try a fast sync here
	// fixes #738 and hopefully breaks nothing...
	if (!relative) {
	    try {
		if (primeRFBHandler != null) {
		    primeRFBHandler.rfbProto.writeMouseSyncEvent(RFBproto.MouseSyncFast);
		}
	    } catch (IOException ec) {
		ec.printStackTrace();
	    }
	}
    }

    // ---- handler methods for all the controls ----
    private boolean wlChatReg = false, wlVideoReg = false;

    // buttons and action menu items
    public void actionPerformed(ActionEvent e) {
	Object src = e.getSource();

	try {
	    boolean handleFocus = true;

	    // drive redirection
	    if (src == btnDrvRedir) {
	    	switchDriveRedirection();
	    }

	    // SAS button
	    else if (src == btnForensic) {
	    	switchForensic();
	    	if (showForensic) {
	    	    handleFocus = false;
	    	}
	    }

	    // Mouse sync button
	    else if (src == btnMouseSync) {
	       primeRFBHandler.rfbProto.writeMouseSyncEvent(RFBproto.MouseSyncNorm);
	    }

	    // screenshot
	    else if (src == mScreenshot) {
	        console.rdr.createScreenshot();
	    }

	    // Mouse sync menu items
	    else if (src == miMouseSyncFast) {
	       primeRFBHandler.rfbProto.writeMouseSyncEvent(RFBproto.MouseSyncFast);
	    }

	    else if (src == miMouseSyncHard) {
	       primeRFBHandler.rfbProto.writeMouseSyncEvent(RFBproto.MouseSyncHard);
	       Date date = new Date();
	       MouseEvent me = new MouseEvent(console, MouseEvent.MOUSE_MOVED,
					      date.getTime(), 0,
					      mhandler.oldPos.x,
					      mhandler.oldPos.y, 0, false);
	       console.processEvent(me);
	    }

	    // Auto Adjust Button
	    else if (src == btnAA) {
		primeRFBHandler.rfbProto.
		    writeVideoSettingsEvent(vsframe.VSAutoAdjust,(short)0);
	    }

	    // Video Refresh
	    else if (src == miVideoRefresh) {
		primeRFBHandler.rfbProto.writeVideoRefresh();
	    }

	    // Single/Double Mouse mode
	    else if (src == btnMouseMode) {
		if (mhandler == mhandler_abs) {
		    setMouseSingle();
		} else {
		    setMouseDouble();
		}
	    }
	    // Encoding - predefined, Fix encoding
	    else if (((MenuItem)src).getParent() != null &&
		     ((MenuItem)src).getParent() == fixSubMenu) {
		final MenuItem item = (MenuItem) src;
		RFBEncoding enc = currentRFBHandler.params.encoding;
		String oldColorName = enc.getCurrentColorName();
		boolean needReadjust = enc.setFixEncoding(item.getLabel());
		boolean requestFBUpdate = (oldColorName.equals(enc.getCurrentColorName()) == false);
		if (needReadjust) {
		    adjustEncodingSubmenus();
		    currentRFBHandler.pendingFormatChange = true;
		    if (requestFBUpdate) {
			try {
			    currentRFBHandler.sendFullFramebufferUpdateRequest();
			} catch (IOException ec) {
			    logger.println(T._("Unable to send Full Framebuffer Update Request message"));
			}
		    }
		}
	    }
	    if (handleFocus) {
	    	handleFocus(null);
	    }
	}
	catch (IOException ec) {
	    ec.printStackTrace();
	}
    }

    // toggle menu items
    public void itemStateChanged(ItemEvent e) {
	MenuItem mi = (MenuItem)e.getSource();

	// Monitor Mode
	if (mi == itemRO) {
	    boolean moni=e.getStateChange()==ItemEvent.SELECTED ? true:false;
	    changeMonitorState(moni);
	}
	// Exclusive Access
	else if (mi == itemExcl) {
	    String ex = e.getStateChange()==ItemEvent.SELECTED ? "on":"off";
	    try {
		primeRFBHandler.rfbProto.writeUserPropChangeEvent("exclusive",
							     ex);
	    } catch (Exception ec) {
		logger.println(T._("Exclusive") + " " + ex + " " + ec.getMessage());
	    }
	    handleFocus(null);
	}
	// Readability Filter
	else if (mi == scfilter) {
	    if(e.getStateChange() == ItemEvent.SELECTED) {
		console.setInterpol(true);
	    } else {
		console.setInterpol(false);
	    }
	    handleFocus(null);
	}
	// Scaling
	else if (mi == sc100 ||
		 mi == sc50 ||
		 mi == sc25 ||
		 mi == sc2fit) {

	    if(currentScale != mi) {
		currentScale = mi;
		if(mi == sc2fit) {
		    showReduced(false, false);
		    useScrollPane(false, true);
		    console.setScaleToFit(true);
		} else if(mi == sc100) {
		    showReduced(false, false);
		    useScrollPane(true, true);
		    console.setScaleToFit(false);
		    console.setScale(1.0, 1.0);
		} else {
		    showReduced(true, false);
		    useScrollPane(true, false);
		    console.setScaleToFit(false);
		    if(mi == sc50) console.setScale(0.5, 0.5);
		    else if(mi == sc25) console.setScale(0.25, 0.25);
		}
	    }
	    setExclusive((CheckboxMenuItem)mi);
	    handleFocus(null);
	}

	// Chat
	else if (mi == itemChat) {
	    if (chat != null) {
	    	if(e.getStateChange() == ItemEvent.SELECTED) {
		    if(!wlChatReg) {
		    	final CheckboxMenuItem myItem =
				(CheckboxMenuItem)e.getSource();
		    	chat.getAsWindow().addWindowListener(new WindowAdapter() {
			    	public void windowClosing(WindowEvent e) {
				    myItem.setState(false);
			    	}
			    });
		    	wlChatReg = true;
		    }
		    chat.setVisible(true);
	    	} else {
		    chat.setVisible(false);
		}
	    }
	    handleFocus(null);
	}

	// Soft Keyboard
	else if (mi == itemSoftKbd) {
	    final CheckboxMenuItem myItem = (CheckboxMenuItem) mi;
	    if(null == softkbdwin && myItem.getState()) {
		// create the soft keyboard window
		softkbd = KbdFactory.getInstance().
		    getSoftKbd(keh, curmapping, boardname, true);
		if (softkbd != null) {
		    softkbdwin = softkbd.getAsWindow(ServerConsolePanelBase.this);
		    softkbdwin.addWindowListener(new WindowAdapter() {
			    public void windowClosing(WindowEvent e) {
				myItem.setState(false);
			    }
			});
		}
		else {
		    // no or invalid mapping selected (unlikely), deselect item
		    myItem.setState(false);
		    softkbdwin = null;
		    logger.println("Show failed, please choose a soft keyboard mapping first");
		}
	    }
	    if(myItem.getState() && (softkbdwin != null)) {
		// show softkbd window and set position
		ServerConsolePanelBase scp = ServerConsolePanelBase.this;
		Point p = scp.getLocationOnScreen();
		// +4 is for the frame width
		Dimension scpdim = scp.getSize();
		Dimension softdim = softkbdwin.getSize();
		int x = scpdim.width - softdim.width + 4;
		int y = scpdim.height - softdim.height + 4;
		p.translate(x, y);
		softkbdwin.setLocation(p);
		softkbdwin.show();
	    } else {
		// destruct softkbd window if we have one
		if (softkbdwin != null) {
		    softkbdwin.hide();
		    softkbdwin.dispose();
		}
		softkbdwin = null;
	    }
	}

	// Keyboard Options
	else if (mi.getParent() != null &&
		 (mi.getParent() == mapmi) || (mi.getParent() == hardmapmi))
	{
	    final MyCBMenuItem item = (MyCBMenuItem) mi;

	    if(mapmi == mi.getParent()) {
		curmapping = (Locale)item.item;
		if(softkbd != null) softkbd.setMapping(curmapping);
		if (forensicPanel != null) forensicPanel.newKbdMapping(curmapping);
		try {
		    primeRFBHandler.rfbProto.
			writeUserPropChangeEvent("softkbd_mapping",
						 curmapping.toString());
		} catch (Exception ec) {
		    ec.printStackTrace();
		}
	    } else if(hardmapmi == mi.getParent()) {
		curhardmapping = (Locale)item.item;
		console.setKbdLocale(curhardmapping);

		try {
		    primeRFBHandler.rfbProto.
			writeUserPropChangeEvent("localkbd_mapping",
						 curhardmapping.toString());
		} catch (Exception ec) {
		    ec.printStackTrace();
		}
	    }
	    setExclusive(item);
	}

	// Local Cursor
	else if (mi.getParent() != null &&
		 mi.getParent() == cursormi) {
	    final MyCBMenuItem item = (MyCBMenuItem) mi;

	    currentCursor = (CursorType) item.item;
	    cursors.setCurrentCursor(currentCursor);
	    console.setCursor(currentCursor.cursor);
	    try {
		primeRFBHandler.rfbProto.
		    writeUserPropChangeEvent("rc.local_cursor",
					     currentCursor.sName);
	    } catch (Exception ec) {
		ec.printStackTrace();
	    }

	    setExclusive(item);
	}

	// Video Settings
	else if (mi == itemVideoSettings) {
	    if(e.getStateChange() == ItemEvent.SELECTED) {
		if(!wlVideoReg) {
		    final CheckboxMenuItem myItem =
			(CheckboxMenuItem)e.getSource();
		    vsframe.getAsWindow().
			addWindowListener(new WindowAdapter() {
			    public void windowClosing(WindowEvent e) {
				myItem.setState(false);
			    }
			});
		    wlVideoReg = true;
		}
		vsframe.setVisible(true);
	    } else {
		vsframe.setVisible(false);
	    }
	}

	// Single/Double Mouse mode
	else if (mi == miMouseSingle) {
	    setMouseSingle();
	} else if (mi == miMouseDouble) {
	    setMouseDouble();
	} else if (mi == miMouseAbsolute) {
	    setMouseAbsolute();
	} else if (mi == miMouseIntelligent) {
	    setMouseIntelligent();
	} else if (mi == miMouseStandard) {
	    setMouseStandard();
	}

	// Encoding submenu
	else if (mi.getParent() == compSubMenu || mi.getParent() == colorSubMenu || mi == lossymi) {
	    RFBEncoding enc = currentRFBHandler.params.encoding;
	    boolean needReadjust = false;
	    boolean requestFBUpdate = true;

	    // Compression
	    if (mi.getParent() == compSubMenu) {
		final MyCBMenuItem item = (MyCBMenuItem) mi;

		String name = (String)item.item;
		String oldColorName = enc.getCurrentColorName();

		needReadjust = enc.setCompression(name);
		requestFBUpdate = (oldColorName.equals(enc.getCurrentColorName()) == false);
	    }
	    // Color Depth
	    else if (mi.getParent() == colorSubMenu) {
		final MyCBMenuItem item = (MyCBMenuItem) mi;

		String name = (String)item.item;
		needReadjust = requestFBUpdate = currentRFBHandler.params.encoding.setColorDepth(name);
	    }
	    // Lossy
	    else if (mi == lossymi) {
		needReadjust = currentRFBHandler.params.encoding.setLossyState(lossymi.getState());
	    }

	    // apply changes
	    if (needReadjust) {
		adjustEncodingSubmenus();
		currentRFBHandler.pendingFormatChange = true;
		if (requestFBUpdate) {
		    try {
			currentRFBHandler.sendFullFramebufferUpdateRequest();
		    } catch (IOException ec) {
			logger.println(T._("Unable to send Full Framebuffer Update Request message"));
		    }
		}
	    }
	}
    }

    // --------- functions used by handler parts -----------
    // Monitor Mode
    private void changeMonitorState(boolean moni) {
	console.setMonitorMode(moni);
	buttonpane.setMonitorMode(moni);
	if (vsframe != null) vsframe.setMonitorMode(moni);
	if (btnRO != null) btnRO.setImageIndex((moni)?5:4);
	handleFocus(null);
	allowMouseHandling(!moni);

	monitorModeOn = moni;
    }

    // Drive Redirection
    private void switchDriveRedirection() {
    	showDriveRedirection = !showDriveRedirection;
    	btnDrvRedir.setImageIndex((showDriveRedirection) ? 7 : 6);
    	ServerConsoleFrame parent = (ServerConsoleFrame)getParent();
    	parent.showDriveRedirection(showDriveRedirection);
    }

    // Forensic button
    private void switchForensic() {
    	showForensic = !showForensic;
    	btnForensic.setImageIndex((showForensic) ? 9 : 8);
    	ServerConsoleFrame parent = (ServerConsoleFrame)getParent();
    	parent.showForensic(showForensic);
    }


    /**
     * adjust compression and color menus
     * (disable/enable, set check)
     */
    private void adjustEncodingSubmenus()
    {
	RFBEncoding enc = currentRFBHandler.params.encoding;
	MyCBMenuItem ci;
	String currentName;
	Menu m;

	// fix encoding menu has no checks for now
	m = (Menu)fixSubMenu;
	for(int j = 0; j < m.getItemCount(); j++) {
	    MenuItem mi = (MenuItem)m.getItem(j);
	    mi.setEnabled(true);
	}

	// compression menu
	m = (Menu)compSubMenu;
	currentName = enc.getCurrentCompName();
	for(int j = 0; j < m.getItemCount(); j++) {
	    ci = (MyCBMenuItem)m.getItem(j);
	    String name = (String) ci.item;
	    ci.setState(name.equals(currentName) ? true : false);
	}

	// color depth menu, change depending on compression
	m = (Menu)colorSubMenu;
	currentName = enc.getCurrentColorName();
	for(int j = 0; j < m.getItemCount(); j++) {
	    ci = (MyCBMenuItem)m.getItem(j);
	    String name = (String) ci.item;
	    ci.setEnabled(enc.isColorPossible(name) ? true : false);
	    ci.setState(name.equals(currentName) ? true : false);
	}

	// lossy menu item
	if (enc.isHwSupported()) {
	    lossymi.setState(enc.isLossy() ? true : false);
	}
    }

    protected String get_hotkey_settings_string() {
	return new String(T._("Please define a mouse hotkey in \"User Console\" Settings."));
    }

    public void setWLANQuality(int quality) {
	int min_index = 0;
	int max_index = 5;
	int index;

	if (quality <= 0) {
	    index = 0;
	} else if (quality >= 100) {
	    index = max_index;
	} else {
	    index = ((max_index - min_index) * quality) / 100 + min_index + 1;
	}
	if (btnWL != null) {
	    btnWL.setImageIndex(index);
	    btnWLToolTip.setTip(T._("WLAN link quality: ") + quality + "%");
	}
    }


    public void setExclusiveMode(boolean ex) {
	exclusive = ex;
	if (itemExcl != null) {
	    itemExcl.setState(exclusive);
	}
	setShareIcon();
    }

    public void setShareMode(int users) {
	userscount = users;
	setShareIcon();
    }

    private void setShareIcon() {
	if (btnSM == null) return;
	if (exclusive) {
	    boolean co = true;
	    try {
		co = currentRFBHandler.rfbProto.connected();
	    } catch (Exception e) {};
	    if (co) {
		btnSM.setImageIndex(2);
	    } else {
		btnSM.setImageIndex(3);
	    }
	} else if (userscount > 1) {
	    btnSM.setImageIndex(1);
	} else {
	    btnSM.setImageIndex(0);
	}
    }


    // Single/Double Mouse
    public void setMouseSingle() {
	if (mhandler_rel == null) {
	    String s;
	    if (!verInfo.isJava14()) {
		s = new String(T._("Java VM version not suported. Version 1.4 or higher required."));
	    } else if (synckey == null || synckey.length()==0) {
		s = this.get_hotkey_settings_string();
	    } else {
		s = noRelativeMouseHandlerReason;
		if (s == null) {
		    s = new String(T._("Unknown error while activating single mouse mode."));
		}
	    }
	    ConfirmDialog d = new ConfirmDialog(s, T._("Could not activate single mouse mode"), ConfirmDialog.OK, true);
	    d.show();
	    d.dispose();
	    d = null;
	    switchMouseHandler(false);
	    return;
	}
	switchMouseHandler(true);
	logger.println(T._("Single mouse mode (click into screen to start)"));
	saveSingleMouseMode("yes");
	return;
    }

    public void setMouseDouble() {
	switchMouseHandler(false);
	logger.println(T._("Double mouse mode (use 'Keyboard/Mouse Settings' to setup)"));
	saveSingleMouseMode("no");
    }
    
    public void setMouseAbsolute() {
	mouseMode = MOUSE_MODE_ABSOLUTE;
	try {
	    primeRFBHandler.rfbProto.writeGlobalPropChangeEvent("usb_type", "absolute");
	    primeRFBHandler.rfbProto.writeGlobalPropChangeEvent("unit._e_.0.port._e_." + console.currentKvmPort + ".mouse.mode", "direct");
	} catch (IOException ex) {
	    logger.println(T._("Applying mouse mode failed:") + " " + ex.getMessage());
	}
	setMouseDouble();
    }

    public void setMouseIntelligent() {
	mouseMode = MOUSE_MODE_INTELLI;
	try {
	    primeRFBHandler.rfbProto.writeGlobalPropChangeEvent("usb_type", "relative");
	    primeRFBHandler.rfbProto.writeGlobalPropChangeEvent("unit._e_.0.port._e_." + console.currentKvmPort + ".mouse.mode", "auto");
	} catch (IOException ex) {
	    logger.println(T._("Applying mouse mode failed:") + " " + ex.getMessage());
	}
	setMouseDouble();
    }

    public void setMouseStandard() {
	mouseMode = MOUSE_MODE_STANDARD;
	try {
	    primeRFBHandler.rfbProto.writeGlobalPropChangeEvent("usb_type", "relative");
	    primeRFBHandler.rfbProto.writeGlobalPropChangeEvent("unit._e_.0.port._e_." + console.currentKvmPort + ".mouse.mode", "direct");
	} catch (IOException ex) {
	    logger.println(T._("Applying mouse mode failed:") + " " + ex.getMessage());
	}
	setMouseDouble();
    }

    public void saveSingleMouseMode(String ss) {
	try {
	    primeRFBHandler.rfbProto.writeUserPropChangeEvent("exclusive_mouse", ss);
	} catch (IOException ex) {
	    logger.println(T._("Saving single mouse mode failed:")
			   + " " + ex.getMessage());
	}
    }

    public void releaseSingleMouse() {
        if (mhandler == mhandler_rel) {
            mhandler_rel.handleMouseSyncKey();
        }
    }

    public void saveDoubleMouseMode(String ss) {
	try {
	    primeRFBHandler.rfbProto.writeUserPropChangeEvent("exclusive_mouse", ss);
	} catch (IOException ex) {
	    logger.println(T._("Saving single mouse mode failed:")
			   + " " + ex.getMessage());
	}
    }

    private Object[] toArray(Vector v) {
        Object[] os = new Object[v.size()];
        for(int i=0; i<v.size(); ++i) os[i] = v.elementAt(i);

        return os;
    }

    public void setOptionsMenuLabel(String caption){
        menu.setText(caption);
    }

	public void removeStatusBar(){
	    remove(statusbar);
	}

}

// little helper to store our actual item object in
// the menu item itself
class MyCBMenuItem extends CheckboxMenuItem {
    public Object item;
    public MyCBMenuItem(String label, Object item, boolean checked) {
	super(label, checked);
	this.item = item;
    }
}

abstract class SCPFocusHandler {
    abstract protected void handleFocus(Component c);
}

class J11SCPFocusHandler extends SCPFocusHandler {
    public void handleFocus(Component c) {
	c.requestFocus();
    }
}

class J14SCPFocusHandler extends SCPFocusHandler {
    public void handleFocus(Component c) {
	c.requestFocusInWindow();
    }
}
