package nn.pp.rc;

import java.awt.*;
import java.applet.*;
import java.awt.event.*;
import java.util.*;

public class ToolTip extends Canvas {

    protected String tip;
    protected Component owner;

    private Container mainContainer;
    private LayoutManager mainLayout;

    protected Timer delayTimer = null;
    protected TimerTask delayTimerTask = null;
    private final int DELAY = 500;

    private boolean shown;

    private final int VERTICAL_OFFSET = 10;
    private final int HORIZONTAL_ENLARGE = 10;
    

    public ToolTip(String tip, Component owner) {
	this.tip = tip;
	this.owner = owner;
	owner.addMouseListener(new MAdapter());
	setBackground(new Color(255,255,220));
    }

    public void setTip(String tip) {
	this.tip = tip;
	if (shown) {
	    repaint();
	}
    }

    public void paint(Graphics g) {
	g.drawRect(0,0,getSize().width -1, getSize().height -1);
	g.drawString(tip, 3, getSize().height - 3);
    }

    private void addToolTip() {
	synchronized (this) {
	    findMainContainer();
	    mainContainer.setLayout(null);

	    FontMetrics fm = getFontMetrics(owner.getFont());    		
	    setSize(fm.stringWidth(tip) + HORIZONTAL_ENLARGE, fm.getHeight());

	    // calc location of tooltip - must be visible 
	    {
		int mx = mainContainer.getLocationOnScreen().x;
		int my = mainContainer.getLocationOnScreen().y;
		int mw = mainContainer.getSize().width;
		int mh = mainContainer.getSize().height;
		int ox = owner.getLocationOnScreen().x;
		int oy = owner.getLocationOnScreen().y;
		int ow = owner.getSize().width;
		int oh = owner.getSize().height;
		int w = getSize().width;
		int h = getSize().height;
		int x;
		int y;

		// X: align left tooltip border with horiz middle of tooltip owner
		x = ox - mx + (ow / 2);
		if (x > mw - w) x = mw - w;

		// Y: place below owner with a VERTICAL_OFFSET gap
		// if (partly) outside of mainContainer, place above owner
		y = (oy - my) + oh + VERTICAL_OFFSET;
		if (y > mh - h) {
		    y = (oy - my) - h - VERTICAL_OFFSET;
		}

		setLocation(x, y);
	    }

	    mainContainer.add(this, 0);
	    mainContainer.validate();
	    repaint();
	    shown = true;
	}
    }

    private void removeToolTip() {
	synchronized (this) {
	    if (shown) {
		mainContainer.remove(0);
		mainContainer.setLayout(mainLayout);
		mainContainer.validate();
	    }
	    shown = false;
	}
    }

    private void findMainContainer() {
	Container parent = owner.getParent();
	while (true) {
	    if ((parent instanceof Applet) || (parent instanceof Frame)) {
		mainContainer = parent;
		break;				
	    } else {
		parent = parent.getParent();
	    }
	}		
	mainLayout = mainContainer.getLayout();
    }

    // schedules tooltip to be shown after DELAY
    private void startToolTip() {
	if (delayTimer != null) return;
	delayTimer = new Timer();
	delayTimer.schedule(new TimerTask() { public void run() { addToolTip(); } }, DELAY);
    }

    // removes tooltip or cancels a scheduled one
    private void stopToolTip() {
	if (delayTimer != null) {
	    delayTimer.cancel();
	    delayTimer = null;
	}
	removeToolTip();
    }

    class MAdapter extends MouseAdapter {
	public void mouseEntered(MouseEvent me) {
	    startToolTip();
	}
	public void mouseExited(MouseEvent me) {
	    stopToolTip();
	}
	public void mousePressed(MouseEvent me) {
	    stopToolTip();
	}
    }
}
