package nn.pp.rc;

import java.awt.*;
import java.awt.event.*;
import java.text.*;
import java.lang.*;

public class TrafficMonitor implements ActionListener {
    MonitoringStream in;
    MonitoringStream out;
    ServerConsolePanelBase panel;
    GenericTimer timer;
    boolean showFPS = false;
    int fpsCount = 0;
    
    TrafficMonitor(ServerConsolePanelBase panel) {
	this.panel = panel;
	timer = new GenericTimer(1000, this);
    }

    public void setStreams(MonitoringStream in,
			   MonitoringStream out) {
	this.in = in;
	this.out = out;
	timer.start();
    }
    
    public void enableFPS(boolean fps) {
    	showFPS = fps;
    }
    
    public void increaseFPSCount() {
    	synchronized(this) {
    	    fpsCount++;
    	}
    }
    
    private int getAndClearFPS() {
    	int ret;
    	synchronized(this) {
    	    ret = fpsCount;
    	    fpsCount = 0;
    	}
    	return ret;
    }

    public void actionPerformed(ActionEvent e) {
	updateInfo();	
    }
    
    private void updateInfo() {
	String info = "";
	int outc;
	MonitorData indata;

	indata = in.getAndClearIn();
	outc= out.getAndClearOut();
	
	if (showFPS) {
	    info += " " + T._("Fps:") + " " + getAndClearFPS();
	}
	info += MessageFormat.format(" " + T._("In: {0} Out: {1}"),
				     new Object[] { buildPart(indata.countC), buildPart(outc)});

	panel.setTitle(info);
    }

    private String buildPart(int count) {
	String sval;

	if (count > 1024) {
	    sval = Integer.toString(count/1024) + " " + T._("KB/s");
	} else {
	    sval = Integer.toString(count) + " " + T._("B/s");
	}

	return sval;
    }
}
