
package nn.pp.rckbd;

import java.util.*;
import java.awt.event.*;
import nn.pp.rc.*;

/**
 * base class for all concrete KeyTranslators
 * used to have the possibility for static initialization
 * and inheritance for concrete KeyTranslators
 * each subclass must add its key translation table
 * with addKeyTranslations in the constructor
 */
public abstract class KeyTranslatorBase {

    private Hashtable codetable = null;
    private Hashtable chartable = null;
    private Vector    initcode  = null;
    private Vector    initchar  = null;
    private J14EventStuff j14stuff = null;

    /**
     * constructor ony initialices the intitrans vector
     */
    public KeyTranslatorBase() {
	initcode = new Vector();
	initchar = new Vector();

	if (JVMVersionInfo.getJVMVersionInfo().isJava14()) {
	   j14stuff  = new J14EventStuff();
	}
    }
    
    /**
     * translates KeyEvents of a specific locale
     * to rckbd key numbers
     * try char translation first, if this fails, try
     * again with key code translation...
     */
    public class J14EventStuff {
	int getKeyLocation(KeyEvent kev) {
	    return kev.getKeyLocation();
	}
    }
    
    public Short translateKeyEvent(KeyEvent evt) {
	if(null == codetable) createTranstables();
	char c = evt.getKeyChar();
	
	Short r = (java.lang.Short) chartable.get(new Character(c));
	if(r == null) {
	    r = (java.lang.Short)codetable.get(new Integer(evt.getKeyCode()));
	}
	/*
	 * this stuff is really hacky, we should change that
	 * rather earlier than later to some extra table taking care
	 * of the key location information provided in java versions 1.4
	 */
	if (r != null && j14stuff != null
	    && j14stuff.getKeyLocation(evt) == KeyEvent.KEY_LOCATION_RIGHT) {
	    switch (r.intValue()) {
	      case 55: r = new Short((short)57); break; // RALT
	      case 41: r = new Short((short)53); break; // RSHIFT
	      case 54: r = new Short((short)58); break; // RCTRL
	    }
	}
	return r;
    }

    /**
     * needs to be called by a subclass of KeyTranslation Base
     * in order to registers its translation table
     * this method can be called by many subclasses overwriting
     * each other... but ATTENTION only during construction time
     * ones createTranstable() has beeb called a null pointer
     * will be generated
     */
    protected void addKeyTranslation(int[][] translations) {
	initcode.addElement(translations);
    }
    protected void addCharTranslation(int[][] translations) {
	initchar.addElement(translations);
    }

    /**
     * needs to be overwritten by a subclass and returns the
     * appropriate Local Object for this key translator
     */
    public abstract Locale getLocale();

    /**
     * creates the translation hashtable out of the initialization
     * arrays that have been added to inittrans by all our subclassses
     */
    private void createTranstables() {
	codetable = new Hashtable();
	chartable = new Hashtable();
	for(int i=0; i<initcode.size(); ++i) {
	    int[][] t = (int[][])initcode.elementAt(i);
	    for(int k=0; k<t.length; ++k) {
		codetable.put(new Integer(t[k][0]), new Short((short)t[k][1]));
	    }
	}
	for(int i=0; i<initchar.size(); ++i) {
	    int[][] t = (int[][])initchar.elementAt(i);
	    for(int k=0; k<t.length; ++k) {
		chartable.put(new Character((char)t[k][0]),
			      new Short((short)t[k][1]));
	    }
	}
	initcode  = null; // make sure vectors get garbage collected
	initchar  = null;
    }
}
