package nn.pp.rcrdp;

import java.awt.image.IndexColorModel;

public class ColorTranslator {
    
    private RDPProfile profile;
    
    // color map
    private int colors[];
    private int nColors;
    /*
    private byte alphas[];
    private byte reds[];
    private byte greens[];
    private byte blues[];
    private IndexColorModel cm;
    */
    
    public void setProfile(RDPProfile profile) {
    	this.profile = profile;
    }
    
    // set a new color map
    public void setColorMap(int colors[], int nColors) {
    	this.colors = colors;
    	this.nColors = nColors;
    	/*
    	alphas = new byte[nColors];
    	reds = new byte[nColors];
    	greens = new byte[nColors];
    	blues = new byte[nColors];
    	for(int i = 0; i < nColors; i++) {
    	    alphas[i] = (byte) ((colors[i] >> 24) & 0xff);
    	    reds[i] = (byte) ((colors[i] >> 16) & 0xff);
    	    greens[i] = (byte) ((colors[i] >> 8) & 0xff);
    	    blues[i] = (byte) (colors[i] & 0xff);
    	}
    	cm = new IndexColorModel(8, nColors, alphas, reds, greens, blues);
    	*/
    }

    // build a color from a 15 bit value
    private int splitColor15(int col) {
	int red = (col & 0x7c00) >> 10;
	red = (red * 0xff) / 0x1f;
	int green = (col & 0x03e0) >> 5;
	green = (green * 0xff) / 0x1f;
	int blue = (col & 0x1f);
	blue = (blue * 0xff) / 0x1f;
	
	// java wants colors in aarrggbb
	// alpha is always set to opaque
	return (0xff000000 | (red << 16) | (green << 8) | blue);
    }
    
    // build a color from a 16 bit value
    private int splitColor16(int col) {
	int red = (col & 0xf800) >> 11;
	red = (red * 0xff) / 0x1f;
	int green = (col & 0x07e0) >> 5;
	green = (green * 0xff) / 0x3f;
	int blue = (col & 0x001f);
	blue = (blue * 0xff) / 0x1f;
	
	return (0xff000000 | (red << 16) | (green << 8) | blue);
    }
    
    // build a color from a 24 bit value
    private int splitColor24(int col) {
	int red = (col & 0xff0000) >> 16;
	int green = (col & 0xff00) >> 8;
	int blue = (col & 0xff);
	
	return (0xff000000 | (red << 16) | (green << 8) | blue);
    }
    
    // translate a byte array with 8 bit (palette) colors
    private void translate8To32(int colOut[], int indexOut, byte colIn[], int indexIn, int len) {
    	
    	int j = indexIn;
    	int k = indexOut;
    	int c[] = colors;	// our color table
    	int min = Math.min(len, Math.min(colIn.length - indexIn, colOut.length - indexOut));
    	for(int i = 0; i < min; i++) {
    	    colOut[k++] = c[colIn[j++] & 0xff];
    	}
    	
    	//cm.getRGBs(colOut);
    }

    // translate a byte array with 15 bit colors
    private void translate15To32(int colOut[], int indexOut, byte colIn[], int indexIn, int len) {
    	int j = indexIn;
    	int k = indexOut;
    	int c;
    	int min = Math.min(len, Math.min(colIn.length / 2  - indexIn, colOut.length - indexOut));
    	for(int i = 0; i < min; i++) {
    	    c = (colIn[j++] & 0xff);
    	    c |= ((colIn[j++] & 0xff) << 8);
    	    colOut[k++] = splitColor15(c);
    	}
    }

    // translate a byte array with 16 bit colors
    private void translate16To32(int colOut[], int indexOut, byte colIn[], int indexIn, int len) {
    	int j = indexIn;
    	int k = indexOut;
    	int c;
    	int min = Math.min(len, Math.min(colIn.length / 2  - indexIn, colOut.length - indexOut));
    	for(int i = 0; i < min; i++) {
    	    c = (colIn[j++] & 0xff);
    	    c |= ((colIn[j++] & 0xff) << 8);
    	    colOut[k++] = splitColor16(c);
    	}
    }

    // translate a byte array with 24 bit colors
    private void translate24To32(int colOut[], int indexOut, byte colIn[], int indexIn, int len) {
    	int j = indexIn;
    	int k = indexOut;
    	int c;
    	int min = Math.min(len, Math.min(colIn.length / 3 - indexIn, colOut.length - indexOut));
    	for(int i = 0; i < min; i++) {
    	    c = (colIn[j++] & 0xff);
    	    c |= ((colIn[j++] & 0xff) << 8);
    	    c |= ((colIn[j++] & 0xff) << 16);
    	    colOut[k++] = splitColor24(c);
    	}
    }

    // build a color
    public int translateColor(int col) {
    	switch(profile.hostBpp) {
    	    case 8:
    	    	return colors[col & 0xff];
    	    case 15:
    	    	return splitColor15(col);
    	    case 16:
    	    	return splitColor16(col);
    	    case 24:
    	    	//return splitColor24(col);
    	    	// Windows XP and 2003 Server actually supply 16 Bit, even if 24 Bit is requested!!!
    	    	return splitColor16(col);
    	}
    	// should never happen
    	return 0;
    }
    
    // translate a byte array with colors
    //
    // indexIn is for bpp > 8 the nth color, not the nth byte!
    public void translateColor(int colOut[], int indexOut, byte colIn[], int indexIn, int len) {
    	switch(profile.hostBpp) {
    	    case 8:
    	    	translate8To32(colOut, indexOut, colIn, indexIn, len);
    	    	break;
    	    case 15:
    	    	translate15To32(colOut, indexOut, colIn, indexIn, len);
    	    	break;
    	    case 16:
    	    	translate16To32(colOut, indexOut, colIn, indexIn, len);
    	    	break;
    	    case 24:
    	    	// translate24To32(colOut, colIn);
    	    	// Windows XP and 2003 Server actually supply 16 Bit, even if 24 Bit is requested!!!
    	    	translate16To32(colOut, indexOut, colIn, indexIn, len);
    	    	break;
    	}
    }
    
    public int[] translateColor(byte colIn[], int size) {
    	int colOut[] = new int[size];
    	translateColor(colOut, 0, colIn, 0, size);
    	return colOut;
    }
    
}
