package nn.pp.rcrdp;

import java.awt.*;
import java.awt.image.*;

class RDPBitmap {
    private int[] pixel = null;
    int width;
    int height;
    private Image img;
    //private BufferedImage img;
    
    public RDPBitmap() {
    	pixel = null;
    }
    
    // the pix parameter is not copied here; make sure you don't reuse
    // this array on another place in the code
    public RDPBitmap(int[] pix, int w, int h, Component comp) {
    	width = w;
    	height = h;
    	/*
    	pixel = new int[w * h];
    	System.arraycopy(pix, 0, pixel, 0, w * h);
    	*/
    	pixel = pix;
    	MemoryImageSource sImgSrc = new MemoryImageSource(w, h, pix, 0, w);
    	img = comp.createImage(sImgSrc);
    	/*
    	// the version with a BufferedImage is much slower than the MemoryImageSource
    	img = new BufferedImage(w, h, BufferedImage.TYPE_INT_ARGB);
    	img.setRGB(0, 0, w, h, pix, 0, w);
    	*/
    	// allocating a VolatileImage here would also be very slow
    	// because one call to createVolatileImage costs about 1 ms which sums up to a very
    	// long time because we often create a RDPBitmap
    }
    
    public int[] getPixels() {
    	return pixel;
    }
    
    public Image getImage() {
    	return img;
    }
    
    public int getWidth() {
    	return width;
    }
    
    public int getHeight() {
    	return height;
    }
    
    public void dispose() {
    	img.flush();
    	pixel = null;	// let the GC collect the pixels
    }
    
}
