package nn.pp.rcrdp;

import java.awt.*;
import java.awt.image.*;
import java.io.*;

public class RDPRendererJ14 extends RDPRenderer {
    
    private VolatileImage vvimg;
    
    static RenderingHints rhsmoth
	= new RenderingHints(RenderingHints.KEY_INTERPOLATION,
			     RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    private boolean interpolcabable = true;
    private boolean interpol = false;
    
    public RDPRendererJ14(Component comp) {
    	super(comp);
    	debug("RDP new RDPRendererJ14");
    	comp.setFocusTraversalKeysEnabled(false);
    }
    
    public void setInterpol(boolean ip) {
	if(interpol != ip) {
	    interpol = ip;
	    repaint();
	}
    }
    
    public void setRenderSize(Dimension d) {
    	createVImg(d);
    	super.setRenderSize(d);
    	debug("RDP RDPRendererJ14 setRenderSize");
    }

    public void paint(Graphics g, boolean scale, Dimension scalesize) {
	if(vimg == null) return;
    	
	do {
	    switch(vvimg.validate(comp.getGraphicsConfiguration())) {
	      case VolatileImage.IMAGE_INCOMPATIBLE:
		  System.out.println("VolatileImage.IMAGE_INCOMPATIBLE");
		  // old vImg doesn't work with new Graphics, re-create it
		  createVImg(mysize);
	      case VolatileImage.IMAGE_RESTORED:
		  System.out.println("VolatileImage.IMAGE_RESTORED");
		  gvimg.dispose();
		  gvimg = vvimg.createGraphics();
		  gvimg.setColor(Color.black);
		  gvimg.fillRect(0, 0, mysize.width, mysize.height);
		  if(sImgMem == null) {
		      System.out.println("Cannot restore image");
		      break;
		  }
		  // Contents need to be restored
		  if(clipSet) {
		      gvimg.setClip(0, 0, mysize.width, mysize.height);
		  }
		  MemoryImageSource sImgSrc = new MemoryImageSource(mysize.width, mysize.height, sImgMem, 0, mysize.width);
		  Image sImg = comp.createImage(sImgSrc);
		  gvimg.drawImage(sImg, 0, 0, null);
		  if(clipSet) {
		      gvimg.setClip(clipLeft, clipTop, clipWidth, clipHeight);
		  }
	    }
	    Graphics2D g2d = (Graphics2D)g;
	    if(scale) {
    		// we have to set different clippings here
    		// because of the scaling
    		setClippingForScaling(g, scalesize);
		if(interpolcabable && interpol) {
		    g2d.setRenderingHints(rhsmoth);
		}
		try {
		    // we set a clipping above, so we don't have to give
		    // any dimensions here
		    g.drawImage(vimg, 0, 0, scalesize.width, scalesize.height, null);
		} catch(ImagingOpException e) {
		    interpolcabable = false;
		}
	    } else {
		g.drawImage(vimg, 0, 0, null);
	    }
	} while (vvimg.contentsLost());
    }

    public void repaint() {
	comp.repaint();
    }

    public void repaint(int x, int y, int w, int h) {
	comp.repaint(x, y, w, h);
    }

    private void createVImg(Dimension d) {
	if(vimg != null) vimg.flush();
	if(gvimg != null) gvimg.dispose();

	vimg = vvimg = comp.createVolatileImage(d.width, d.height);
	gvimg = vvimg.createGraphics();
	
	/*
	ImageCapabilities ic = vvimg.getCapabilities();
	if(ic.isTrueVolatile()) {
	    System.out.println("RDPRenderer: created volatile image");
	}
	else {
	    System.out.println("RDPRenderer: created image");
	}
	if(ic.isAccelerated()) {
	    System.out.println("image is accelerated");
	}
	else {
	    System.out.println("image is not accelerated");
	}
	*/
    }

}
