package nn.pp.rcsoftkbd;

import nn.pp.rckbd.*;
import java.awt.*;
import java.util.*;
import java.awt.event.*;
import java.awt.image.*;
import java.net.*;

public class SoftKbdImpl extends Canvas
    implements SoftKbd, ImageObserver,
    MouseListener, MouseMotionListener
{
    public static final boolean debug = false;
    public static final int MINIMUMTASTENBREITE = 17;
    public static final int MINIMUMTASTENHOEHE = 17;

    //protected ScanCodeListener scancodelistener;
    private Graphics backgraf;
    private Image keyimage = null;
    private Object sync = new Object();
    private Image backgrd;
    private int gitterbreite;
    private int gitterhoehe;
    private Key lastkey, newkey;
    private Key[] tastenfeld;
    private byte maxpage = 0;
    private byte actualpage = 0;
    private Dimension mysize;
    private KeyEventHandler evthandler;
    private KbdMapping actualmapping;
    private boolean changed = true;
    private boolean layoutHasChanged = false;
    private Vector keystopaint;
    private Color darklinecolor = new Color(130,130,130);
    private Font normalfont = new Font("SansSerif", Font.PLAIN, 12);
    private KeyDef[] kbd_layout;
    private KbdFactory kbd_factory;
    private KeyTranslator keytrans;
    private Dialog kbdframe = null;
    private Panel kbdpanel = null;
    private String boardname;
    
    private boolean interactive;
    
    public SoftKbdImpl() {
	this.kbd_factory = KbdFactory.getInstance();
  	keystopaint = new Vector();
	mysize = new Dimension(0, 0);
    }

    public void init(KeyEventHandler keh, Locale mapping, String boardname, boolean interactive) {
  	if (interactive) {
  	    addMouseListener(this);
  	    addMouseMotionListener(this);
	    // for Keys we do it that way, as we need to demultiplex later
	    enableEvents(AWTEvent.KEY_EVENT_MASK);
	}
	this.interactive = interactive;
	this.evthandler = keh;
	this.boardname  = boardname;
	String layout = evthandler.getActualLayout().getName();
  	this.actualmapping = (KbdMapping)kbd_factory.
	    getKbdMapping(layout, mapping);
  	evthandler.addSoftKbdSupport(this);
 	setLayout(evthandler.getActualLayout());
    }

    public void setLayout(KbdLayout layout) {
        
	keytrans = kbd_factory.getKeyTranslator(layout.getName(),
						actualmapping.getLocale());
  	layoutHasChanged = true;
  	kbd_layout=layout.getKeyDefs();
  	int maxx=0;
  	int maxy=0;
  	for(int i=0; i<kbd_layout.length;i++) {	//Gitterbreite+Hhe ermitteln
	    if(kbd_layout[i].pos_x+kbd_layout[i].size_x > maxx)
		maxx = kbd_layout[i].pos_x+kbd_layout[i].size_x;
	    if(kbd_layout[i].pos_y+kbd_layout[i].size_y > maxy)
		maxy = kbd_layout[i].pos_y+kbd_layout[i].size_y;
	    if(kbd_layout[i].page > maxpage)
		maxpage=kbd_layout[i].page;
	}
  	//gitterbreite=mysize.width/maxx;
  	//gitterhoehe=mysize.height/maxy;
  	//if(gitterbreite < MINIMUMTASTENBREITE)
	gitterbreite = MINIMUMTASTENBREITE;
	//if(gitterhoehe < MINIMUMTASTENHOEHE)
	gitterhoehe = MINIMUMTASTENHOEHE;
  	setSize(gitterbreite*maxx, gitterhoehe*maxy);
  	mysize = new Dimension(gitterbreite*maxx, gitterhoehe*maxy);
  	tastenfeld = new Key[kbd_layout.length];
  	KbdMapping kbdmap = actualmapping;
  	boolean menubuttonok=false;
  	for(int j=0; j<kbd_layout.length; j++) {
	    tastenfeld[j] = new Key(this, kbd_layout[j],
		kbdmap.getMapDef(new java.lang.Short(kbd_layout[j].keynr),
			    KeyDef.SHORTNOP),
			    new Dimension(kbd_layout[j].size_x * gitterbreite,
					  kbd_layout[j].size_y * gitterhoehe),
			    new Point(kbd_layout[j].pos_x * gitterbreite,
				      kbd_layout[j].pos_y * gitterhoehe));
	}
	
  	lastkey=tastenfeld[0];
	keyimage = actualmapping.getKeyImg(KeyDef.SHORTNOP);
  	repaintAll();
	resetFrame(true);
    }

    public void setLayout(String layout) {
        
	KbdLayout newkl = kbd_factory.getKbdLayout(layout);
	if(evthandler.getActualLayout() != newkl) {
	    actualpage=0;
	    evthandler.init(newkl);
	}
    }
    
    public void setMapping(Locale mapping) {
	KbdMapping newkm;
	String layout = evthandler.getActualLayout().getName();
	newkm = (KbdMapping)kbd_factory.getKbdMapping(layout, mapping);
	if(actualmapping != newkm) {
	    actualmapping = newkm;
	    evthandler.resetAllModifiers();
	    changeModifier(KeyDef.SHORTNOP);
	    changed=true;
	    repaint();
	}
	resetFrame(false);
    }
    
    public String getKeyString(Short skeynr, Short modifiers) {
    	if (!actualmapping.hasMapping(modifiers)) {
    	    modifiers = KeyDef.SHORTNOP;
    	}
    	MapDef map = actualmapping.getMapDef(skeynr, modifiers);
    	
    	if (map != null) {
    	    return map.keychar;
    	}
    	return null;
    }

    public Dimension getPreferredSize() {
	 return mysize;
    }

    public Dimension getMinimumSize() {
	 return mysize;
    }

    /**
     * creates a frame fitting the softkbd, that can be
     * displayed wherever somebody likes it ;-)
     * the component's frame passed to the metod will become
     * the owner of window, in case it is null a normal frame
     * will be used...
     */
    public Window getAsWindow(Component c) {
	if(null == kbdframe) {
	    kbdframe = new Dialog(getFrameOf(c));
	    kbdframe.setLayout(new BorderLayout());
	    kbdframe.add(this);
	    kbdframe.pack();
	    kbdframe.setResizable(false);
	    kbdframe.addWindowListener(new WindowAdapter() {
		    public void windowClosing(WindowEvent e) {
			kbdframe.hide();
		    }
		});
	    resetFrame(true);
	}
	return kbdframe;
    }
    
    public Panel getAsPanel() {
    	if (kbdpanel == null) {
    	    kbdpanel = new Panel(new BorderLayout());
    	    kbdpanel.add(this);
    	}
    	
    	return kbdpanel;
    }

    private Frame getFrameOf(Component c) {
	while(!(c instanceof Frame)) {
	    if(null == (c = c.getParent()))
		return null;
	}
	return (Frame)c;
    }

    //---------------------------------------------------------------------

    static int bla = 0;
    
    public void update (Graphics g) { 
 	synchronized(sync) {
     	    if(changed) {
    	    	if ( (backgrd==null) || (layoutHasChanged) ) {
    		    backgrd=createImage(this.getSize().width,
    					this.getSize().height);
    		    backgraf= backgrd.getGraphics();
    		    backgraf.setColor(getBackground()); //Zeichenflche resetten
    		    backgraf.fillRect(0, 0, getSize().width, getSize().height);
    		    layoutHasChanged = false;
    	    	}
    	    	paintkeys(backgraf);
    	    }
      	    g.drawImage(backgrd, 0, 0, null);
      	    changed=false;
      	}
    }

    public void paint(Graphics g){
 	update(g);
    }

    public void paintkeys(Graphics graf){
	Key taste;
	int b = 0, i = 0;
   	int x,y,breite,hoehe,endx,endy;
	graf.setFont(normalfont);
	int fontsize=normalfont.getSize();
	String fontname=normalfont.getName();
	int fontstyle=normalfont.getStyle();
	
   	for(int k=0;k<keystopaint.size(); k++) {
	    taste=(Key)keystopaint.elementAt(k);
	    if(taste.keydef.page != actualpage) continue;
	    //berspringen wenn taste nicht auf aktueller Seite
	    b++;
	    x = taste.pos.x;
	    y = taste.pos.y;
	    breite = taste.size.width;
	    hoehe = taste.size.height;
	    endx=x+breite;
	    endy=y+hoehe;
	    graf.setColor(taste.backgroundcolor); //Untergrund bereiten
	    graf.fillRect(x,y,breite,hoehe);
	    graf.setColor(Color.white);
	    graf.drawLine(x,y,endx,y);
	    graf.drawLine(x,y,x,endy);
	    //graf.setColor(new Color(150,150,150));
	    //graf.drawLine(endx-2,endy-2,endx-2,y);
	    //graf.drawLine(endx-2,endy-2,x,endy-2);
	    graf.setColor(darklinecolor);
	    graf.drawLine(endx-1,endy-1,endx-1,y);
	    graf.drawLine(endx-1,endy-1,x,endy-1);
	    graf.setColor(Color.black);
	    if (taste.mapdef == null) continue;
	    if (taste.mapdef.imgidx == MapDef.NOIMAGE) {        // gltiger String definiert
		FontMetrics fm = graf.getFontMetrics();
		int width, fsize = fontsize;
		while(breite < (width=fm.stringWidth(taste.mapdef.keychar))) {
		    Font f = new Font(fontname, fontstyle, --fsize);
		    graf.setFont(f);
		    fm = graf.getFontMetrics();
		}
		int height = fm.getHeight();
		int ascent = fm.getAscent();
		int leading = fm.getLeading();
		int horizMargin = x+ (breite - width)/2;
		int verMargin = y + (hoehe - height)/2;
		graf.drawString(taste.mapdef.keychar,
				horizMargin, verMargin + ascent + leading);
		if(!graf.getFont().equals(normalfont))graf.setFont(normalfont);
	    } else { // wenn nicht, dann halt malen
		KbdMapping kbdmap=actualmapping;
                int ImageWidth = kbdmap.getImageXPos(taste.mapdef.imgidx+1) -
                                 kbdmap.getImageXPos(taste.mapdef.imgidx);
                graf.drawImage( keyimage, x+(breite-ImageWidth)/2,
                                y+(hoehe-kbdmap.getKeyImgHeight())/2,
                                x+(breite+ImageWidth)/2,
                                y+(hoehe+kbdmap.getKeyImgHeight())/2,
                                (kbdmap.getImageXPos(taste.mapdef.imgidx)),
                                0,
                                (kbdmap.getImageXPos(taste.mapdef.imgidx+1)),
                                kbdmap.getKeyImgHeight(),
                                this);
	    }
	}
   	keystopaint.removeAllElements();
    }

    protected void repaint(Key taste){			//Button neu malen
        keystopaint.addElement(taste);
    }

    private void repaintAll() {	// Alle Tasten neu malen (Page/Layoutwechsel)
              
 	synchronized(sync) {
 	    keystopaint.removeAllElements();
 	    for(int k=0;k<tastenfeld.length; k++) {
	    	if(tastenfeld[k].keydef.page == actualpage) {
    		    keystopaint.addElement(tastenfeld[k]);
            	}
            }
        }
        
  	if(backgrd != null) {
		backgraf.setColor(getBackground()); //Zeichenflche resetten
		backgraf.fillRect(0,0,getSize().width,getSize().height);
	}
  	changed = true;
  	
  	repaint();
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y,
			int width, int height) {
	if ((infoflags & ImageObserver.ALLBITS) != 0) {
	    repaintAll();
	    return false;
	} else {
	    return true;
	}
    }

    //-------------------------------------------------------------------
    // Mouse EventHandler

    private Key isInside(Point p){
 	for(int k=0;k<tastenfeld.length; k++) {
	    if((tastenfeld[k].contains(p)) &&
	       (tastenfeld[k].keydef.page==actualpage))
		return tastenfeld[k];
	}
  	return null;
    }


    public void mouseReleased(MouseEvent evt) {
 	if((newkey == null) ||
	   (lastkey.keydef.keynr==KeyDef.PAGE) ||
	   (lastkey.keydef.keynr==KeyDef.POPUP))
	   return;
	evthandler.released(lastkey.shortnumber,KeyEventHandler.SOFTKEYBOARD);
    }

    public void mousePressed(MouseEvent evt) {
 	if(newkey == null) return; //Abbruch, wenn ausserhalb der Buttons
	if(lastkey.keydef.keynr==KeyDef.PAGE) {	//Pageumschaltung
	    if(actualpage<maxpage) actualpage++;
	    else actualpage=0;
	    repaintAll();
	    changed=true;
	    repaint();
	    return;
	} 
	evthandler.pressed(lastkey.shortnumber, KeyEventHandler.SOFTKEYBOARD);
    }


    public void mouseMoved(MouseEvent evt) {
 	Point p=new Point(evt.getX(), evt.getY());
  	if (lastkey.contains(p)) {
	    if (!lastkey.isOver()) {
		lastkey.setOver(true);
		newkey = lastkey;
		changed=true;
		repaint();
	    }
	} else {
	    lastkey.setOver(false);	//alten Button rcksetzen
	    newkey=isInside(p); 	//neuen Button suchen	    
	    if(newkey != null) {
		lastkey=newkey;
		lastkey.setOver(true);	//neuen Button setzen
	    }
	    changed=true;
	    repaint();
	}
    }

    public void mouseDragged(MouseEvent evt){
 	Point p=new Point(evt.getX(), evt.getY());
   	if(!lastkey.contains(p)) {
	    if(lastkey.isClicked()) mouseReleased(evt);
	    //Wenn Click-Button verlassen--> Releasesignal
	    lastkey.setOver(false);
	    newkey=isInside(p);
	    if(newkey != null) {
		lastkey=newkey; 		//neuen Button suchen
		lastkey.setOver(true);	//neuen Button setzen
	    }
	}
  	changed=true;
   	repaint();
    }

    public void mouseClicked(MouseEvent evt) {}
    public void mouseEntered(MouseEvent evt) {}
    public void mouseExited(MouseEvent evt)  {}

    /**
     * we can also excpet Keyboard events
     */
    public void processKeyEvent(KeyEvent ke) {
	int eID = ke.getID();
	if(debug) System.out.println(ke);
	switch (eID) {
	  case KeyEvent.KEY_PRESSED:
	  case KeyEvent.KEY_RELEASED:
	      //case KeyEvent.KEY_TYPED:
	      Short keynr = keytrans.translateKeyEvent(ke);
	      if(debug) System.out.println("Key number found: " + keynr);
	      if(keynr==null) {
		  System.out.println("ERROR: no key number found for " +ke);
		  return;
	      }
	      evthandler.handleHardKbdEvent(keynr, eID);
	      ke.consume();
	      break;
	}
    }

    //-------------------------------------------------------------------
    // Zusatzfunktionen

    /**
     * In case we have already instantiated a frame this
     * method will update the frames title to the currrent
     * settings
     */
    private void resetFrame(boolean pack) {
	if(null != kbdframe) {
	    String mapping = actualmapping.getLocale().getDisplayName();
	    String layout = evthandler.getActualLayout().getName();
	    kbdframe.setTitle(boardname + " " + mapping + " " + layout);
	    if(pack) kbdframe.pack();
	}
    }
    
    public void changeModifier(java.lang.Short mod) {
  	synchronized(sync) {
  	    if(actualmapping.getKeyImg(mod) != null)
	    	keyimage = actualmapping.getKeyImg(mod);
  	    if(!actualmapping.hasMapping(mod))
	    	return;
 	    MapDef[] map=actualmapping.getMapDefs(mod);
	    for(int k=0; k<tastenfeld.length; k++)
	    	for(int i=0; i<map.length; i++)
		    if(tastenfeld[k].keydef.keynr == map[i].keynr) {
		    	tastenfeld[k].changeMapDef(map[i]);
		    	keystopaint.addElement(tastenfeld[k]);
		    }
  	    changed=true;
  	}
  	repaint();
    }

    public void setClicked(java.lang.Short skeynr,boolean clicked) {
  	if(lastkey.shortnumber.equals(skeynr)) {
	    lastkey.setClicked(clicked);
	} else {
	    for(int k=0;k<tastenfeld.length; k++)
		if(tastenfeld[k].shortnumber.equals(skeynr))
		    tastenfeld[k].setClicked(clicked);
	}
	changed=true;
	repaint();
    }

    void repaintnow() {
  	changed=true;
   	repaint();
    }

    public boolean hasMapping(java.lang.Short skeynr) {
	if(lastkey.shortnumber.equals(skeynr))
	    return actualmapping.hasMapping(skeynr);
   	for(int k=0;k<tastenfeld.length; k++)
	    if(tastenfeld[k].shortnumber.equals(skeynr))
      		return actualmapping.hasMapping(skeynr);
   	return false;
    }
}
