package nn.pp.sara;

import java.awt.*;
import java.util.*;
import java.text.*;
import java.net.*;
import java.awt.event.*;
import nn.pp.rc.*;

class FramePanelFrame extends Frame {
    FramePanel framePanel;
    
    FramePanelFrame(FramePanel _framePanel, String name) {
    	super(name);
    	
    	this.framePanel = _framePanel;
    	setLayout(new BorderLayout());

	addWindowListener(new WindowAdapter() {
	    public void windowClosing(WindowEvent e) {
	    	framePanel.switchInFrame();
	    }
	});
    }
}

abstract class FramePanel extends Panel implements ActionListener {
    URL codeBase;
    Panel parentPanel;
    ImageButton frameButton;

    boolean inFrame = true;
    Panel mainPanel;
    FramePanelFrame frame;
    
    public FramePanel(URL codeBase, SasForensicPanel parentPanel) {
    	this.codeBase = codeBase;
    	this.parentPanel = parentPanel;

    	frame = new FramePanelFrame(this, getFrameName());

    	ImageLoader imgloader = new ImageLoader(codeBase);
    	Image imageButtons = imgloader.loadImage("nn/pp/sara/windows.gif");
    	Dimension btnDim = new Dimension(30, 26);
    	frameButton = new ImageButton(imageButtons, btnDim, inFrame ? 1 : 0);
    }

    public void show() {
    	super.show();
    	if (inFrame) {
    	    frame.show();
    	    frame.toFront();
    	}
    }
    
    public void hide() {
    	super.hide();
    	if (inFrame) {
    	    frame.hide();
    	}
    }
    
    void switchInFrame() {
    	if (inFrame) {
    	    frame.hide();
    	    frame.remove(mainPanel);
    	    frame.pack();
    	    add(mainPanel);
    	    
    	    addVisualPanels(false);

    	    pack();
    	} else {
    	    remove(mainPanel);
    	    pack();

    	    addVisualPanels(true);

    	    frame.add(mainPanel);
    	    frame.pack();
    	    frame.show();
    	}
    	
    	inFrame = !inFrame;
    	frameButton.setImageIndex(inFrame ? 1 : 0);
    }
    
    protected void addVisualPanels(boolean inFrame) { }
    
    Frame getFrame() {
    	Object f = parentPanel.getParent();
    	if (f instanceof Frame) {
    	    return (Frame)f;
    	}
    	return null;
    }
    
    public void pack() {
    	Frame f = getFrame();
    	if (f != null) {
    	    f.pack();
    	}
    }

    public void actionPerformed(ActionEvent e) {
	Object src = e.getSource();
	
	if (src == frameButton) {
	    switchInFrame();
	}
    }

    protected Panel getFrameButtonPanel() {
    	Panel frameButtonPanel = new Panel();
    	frameButtonPanel.setLayout(new FlowLayout());
    	frameButton.addActionListener(this);
    	frameButtonPanel.add(frameButton);
    	
    	return frameButtonPanel;
    }
    
    protected void showInitial() {
    	if (inFrame) {
    	    frame.add(mainPanel, BorderLayout.CENTER);
    	    frame.show();
    	    frame.pack();
    	} else {
    	    add(mainPanel, BorderLayout.CENTER);
    	}
    }
    
    protected void setTitle(String s) {
        frame.setTitle(s);
    }
    
    protected abstract String getFrameName();
}
