package nn.pp.sara;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import nn.pp.rc.*;

abstract class InfoPanelPart extends Panel implements ActionListener {
    InfoPanel info;
    Label userLabel;
    Label sourceLabel;
    Label timeLabel;
    Button logButton;
    boolean hasSource;
    boolean hasLog;
    LogFrame logFrame;
    
    Hashtable logHash;
    
    InfoPanelPart(InfoPanel info, boolean hasSource, boolean hasLog) {
    	this.info = info;
    	this.hasSource = hasSource;
    	this.hasLog = hasLog;
    	
    	logHash = new Hashtable();
    	logFrame = new LogFrame(getHeader() + " (Log)");
    }
    
    void addLayout() {
    	setLayout(new BorderLayout());
    	
    	Panel headerPanel = new Panel(new BorderLayout());
    	
    	Label header = new Label(getHeader());
    	header.setFont(new Font("Helvetica", Font.BOLD, 12));
    	headerPanel.add(header, BorderLayout.WEST);
    	
    	if (hasLog) {
    	    logButton = new Button(T._("Show Log"));
    	    logButton.addActionListener(this);
    	    Panel p = new Panel(new FlowLayout());
    	    p.add(logButton);
    	    headerPanel.add(p, BorderLayout.CENTER);
    	}
    	
    	add(headerPanel, BorderLayout.NORTH);
    	
    	if (hasSource) {
    	    Panel sourcePanel = new Panel();
    	    sourcePanel.setLayout(new BorderLayout());
    	    
    	    if (!info.localOnly) {
    	    	userLabel = new FixedLabel("xxxxxxxxxxxxxxxxxxxxxxxx");
    	    	sourcePanel.add(userLabel, BorderLayout.NORTH);
    	    	sourceLabel = new FixedLabel("888.888.888.888");
    	    	sourcePanel.add(sourceLabel, BorderLayout.CENTER);
    	    }
    	    timeLabel = new FixedLabel("888.888.888.888");
    	    sourcePanel.add(timeLabel, BorderLayout.SOUTH);
    	    
    	    add(sourcePanel, BorderLayout.SOUTH);
    	}
    	
    	// this sets the part specific layout
    	addPartLayout();
    }
    
    void handleSasEvent(SasEvent evt) {
    	if (userLabel != null) {
    	    userLabel.setText(info.getEventUser(evt));
    	}
    	if (sourceLabel != null) {
    	    sourceLabel.setText(info.getEventIp(evt));
    	}
    	if (timeLabel != null) {
    	    timeLabel.setText(info.getEventTime(evt, false));
    	}
    	
    	// this performs the part specific action
    	handlePartSasEvent(evt);
    }
    
    protected void setUser(String user) {
    	if (userLabel != null) {
    	    userLabel.setText(user);
    	}
    }
    
    protected void setIp(String ip) {
    	if (sourceLabel != null) {
    	    sourceLabel.setText(ip);
    	}
    }
    
    protected void clearSource() {
    	if (userLabel != null) {
    	    userLabel.setText("");
    	}
    	if (sourceLabel != null) {
    	    sourceLabel.setText("");
    	}
    	if (timeLabel != null) {
    	    timeLabel.setText("");
    	}
    }
    
    abstract String getHeader();
    abstract void addPartLayout();
    abstract void handlePartSasEvent(SasEvent evt);

    public void actionPerformed(ActionEvent e) {
	Object src = e.getSource();
	
	if (src == logButton) {
	    showLog();
	}
    }
    
    protected String getLog() {
        Vector vec = new Vector(logHash.size());
        for (Enumeration e = logHash.elements(); e.hasMoreElements(); ) {
            LogEntry entry = (LogEntry)e.nextElement();
            vec.add(entry);
        }
        Collections.sort(vec, new LogComparer());
        
        String s = "";
        for (Enumeration e = vec.elements(); e.hasMoreElements(); ) {
            s += ((LogEntry)e.nextElement()).text;
            if (e.hasMoreElements()) {
                s += "\n";
            }
        }
        return s;
    }

    protected void showLog() {
        String s = getLog();
        logFrame.setText(s);
        logFrame.show();
    }
    
    void logEvent(SasEvent evt, String text) {
        if (!logHash.containsKey(evt)) {
            logHash.put(evt, new LogEntry(evt, text));
            if (logFrame.shown) {
                logFrame.setText(getLog());
            }
        }
    }
    
    void clearLog() {
        logHash.clear();
    }
}

class LogEntry {
    SasEvent evt;
    String text;
    
    LogEntry(SasEvent evt, String text) {
        this.evt = evt;
        this.text = text;
    }
}

class LogComparer implements Comparator {
    public int compare(Object obj1, Object obj2) {
        long d1 = ((LogEntry)obj1).evt.getTime().getTime();
        long d2 = ((LogEntry)obj2).evt.getTime().getTime();
        if ((d1 - d2) < 0) {
            return -1;
        } else if ((d1 - d2) > 0) {
            return 1;
        } else {
            return 0;
        }
    }
}

class LogFrame extends Frame {
    TextArea text;
    boolean shown = false;
    
    LogFrame() {
        this(null);
    }
    
    LogFrame(String title) {
        super(title);
        text = new TextArea("", 10, 80, TextArea.SCROLLBARS_BOTH);
        enableEvents(WindowEvent.WINDOW_CLOSING);
        setLayout(new BorderLayout());
        add(text, BorderLayout.CENTER);
        text.setEditable(false);
        pack();
    }
    
    public void show() {
        if (!shown) {
            super.show();
            shown = true;
        } else {
            toFront();
        }
    }
    
    public void hide() {
        if (shown) {
            super.hide();
            shown = false;
        }
    }
    
    void setText(String s) {
        text.setText(s);
    }
    
    void update(String s) {
        if (shown) {
            setText(s);
        }
    }

    protected void processWindowEvent(WindowEvent event) {
	if (event.getID() == WindowEvent.WINDOW_CLOSING) {
	    hide();
	}
    }
}
