package nn.pp.sara;

import java.awt.*;
import java.awt.event.*;
import nn.pp.rc.*;

class SpeedPanel extends Panel implements AdjustmentListener {
    int currentSpeed;
    
    ReplayPanel replay;
    Scrollbar speedBar;
    Label speedLabel;
    
    private int speedMax = 5;	// power of 2
    private int scrollbarMin = -speedMax, scrollbarMax = speedMax + 1;
    
    SpeedPanel(ReplayPanel replay) {
    	this.replay = replay;
    	
    	addLayout();
    	setSpeed(0, true);
    }
    
    private void addLayout() {
    	setLayout(new BorderLayout());
    	
    	speedBar = new FixedScrollbar(Scrollbar.HORIZONTAL, 100);
    	speedLabel = new FixedLabel("8/888 x");
    	
    	speedBar.addAdjustmentListener(this);
    	speedBar.setMinimum(scrollbarMin);
    	speedBar.setMaximum(scrollbarMax);
    	speedBar.setVisibleAmount(1);
    	speedBar.setPageIncrement(1);
    	
    	Panel p = new Panel(new FlowLayout(FlowLayout.CENTER, 0, 8));
    	Panel p1 = new Panel(new BorderLayout());
    	
    	p1.add(new Label("Speed: "), BorderLayout.WEST);
    	p1.add(speedBar, BorderLayout.CENTER);
    	p1.add(speedLabel, BorderLayout.EAST);
    	
    	p.add(p1);
    	
    	add(p, BorderLayout.CENTER);
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
    	Object src = e.getSource();
    	
    	if (src == speedBar && !e.getValueIsAdjusting()) {
    	    setSpeed(speedBar.getValue(), false);
    	}
    }
    
    // speed is set by powers of 2!
    // if speed == -3, the replay speed will be 1/8x,
    // 0 --> 1x, 2 --> 4x etc.
    void setSpeed(int speed, boolean adjustSlider) {
    	currentSpeed = speed;
    	
    	String s;
    	if (speed < 0) {
    	    s = "1/" + Math.round(Math.pow(2, -speed));
    	} else {
    	    s = "" + Math.round(Math.pow(2, speed));
    	}
    	speedLabel.setText(s + "x");
    	
    	if (adjustSlider) {
    	    speedBar.setValue(speed);
    	}
    	
    	replay.setSpeed(speed);
    }
}
