#!/bin/sh

# start eric_login on tty $con
start_config () {
    /bin/initserial $con
    if [ $? = 0 ]; then
	/bin/eric_config < $con > $con 
    fi
}

# starts a getty on tty $1
start_getty () {
    # configlogin or debugmode -> getty

    # build getty parameters depending on serial options
    getty_options="-P $serial_console_parity -B $serial_console_data"
    if [ "$serial_console_stop" = "2" ]; then
	getty_options="$getty_options -S 2"
    fi
    if [ "$baytech_mode" = "1" ]; then
        getty_options="$getty_options -b"
    fi
    if [ "$serial_console_handshake" = "hardware" ]; then
	getty_options="$getty_options -F hw"
    elif [ "$serial_console_handshake" = "software" ]; then
	getty_options="$getty_options -F sw"
    fi

    getty $getty_options $1 $serial_console_speed vt100
}

# start mgetty (modem login) on tty $1
start_mgetty () {
    cat /etc/ppp/options.template > /etc/ppp/options
    echo "$serialport__e__x_modem_board_ip:$serialport__e__x_modem_client_ip" >> /etc/ppp/options
    mgetty -s $serialport__e__x_modem_speed -x 0 -D -m "\"\" $serialport__e__x_modem_init" $1 e-RIC0
}

start_baytech () {
    /bin/baytech -l < $con > $con
}

if [ $# -eq 0 ]; then
	PORT=0
else
	PORT="$1"
fi
con="/dev/ttyS$PORT"

if [ ! -e $con ]; then
    echo "getty_switch.sh: Device $con not found"
    exit 1
fi
producttype=`cat /proc/sys/kernel/producttype`
firsttime=1

while(true); do
    eval `get_config <<EOF | sed "s/_e__[0-9]\+/_e__x/"
serialport._e_.$PORT._c_=
serialport._e_.$PORT.modem.speed=115200
serialport._e_.$PORT.modem.init=ATZH0 OK ATL0M0&K3X1 OK
serialport._e_.$PORT.modem.board_ip=192.168.3.1
serialport._e_.$PORT.modem.client_ip=192.168.3.2
serialport._e_.$PORT.configlogin.speed=115200
serialport._e_.$PORT.configlogin.data=8
serialport._e_.$PORT.configlogin.parity=none
serialport._e_.$PORT.configlogin.stop=1
serialport._e_.$PORT.configlogin.handshake=none
serialport._e_.$PORT.baytechlogin.speed=9600
serialport._e_.$PORT.baytechlogin.data=8
serialport._e_.$PORT.baytechlogin.parity=none
serialport._e_.$PORT.baytechlogin.stop=1
serialport._e_.$PORT.baytechlogin.handshake=none
ps.serial._e_.$PORT._c_=
EOF
`
    # check for serial debug mode
    serial_debug=0
    eric_config -csd && serial_debug=1

    # check for config mode
    config_mode=0
    eric_config -ccm && config_mode=1

    # check for connected PowerCIM first time only
    power_cim=0
    if [ "$firsttime" = 1 -a "$producttype" = "pdu" ]; then
      eric_config -cpcim && power_cim=1
      firsttime=0
    fi

    # check if to enable modem
    modem_enabled=0
    [ "$serialport__e__x__c_" = "modem" ] && modem_enabled=1

    # check if to enable configlogin
    configlogin=0
    [ "$serialport__e__x__c_" = "configlogin" ] && configlogin=1

    if [ "$producttype" = "pdu" -a "$serial_debug" = 0 ]; then
      baytech_mode=1
      serial_console_speed=$serialport__e__x_baytechlogin_speed;
      serial_console_data=$serialport__e__x_baytechlogin_data;
      serial_console_parity=$serialport__e__x_baytechlogin_parity;
      serial_console_stop=$serialport__e__x_baytechlogin_stop;
      serial_console_handshake=$serialport__e__x_baytechlogin_handshake;
    else
      baytech_mode=0
      serial_console_speed=$serialport__e__x_configlogin_speed;
      serial_console_data=$serialport__e__x_configlogin_data;
      serial_console_parity=$serialport__e__x_configlogin_parity;
      serial_console_stop=$serialport__e__x_configlogin_stop;
      serial_console_handshake=$serialport__e__x_configlogin_handshake;
    fi

    # choose something to start on $con
    if [ "$power_cim" = 1 ]; then
        start_baytech $con
    elif [ "$config_mode" = 1 ]; then
	start_config $con
    elif [ "$configlogin" = 1 -o "$serial_debug" = 1 ]; then
	start_getty $con
    elif [ "$modem_enabled" = 1 -a "$serial_debug" = 0 ]; then
	start_mgetty $con
    else
	# wait for reconfiguration signal
	deepsleep getty_switch.sh.sleep >/dev/null 2>&1
    fi
done
                      
