#!/bin/sh

# suppress output e.g. from wpa_cli 
exec >/dev/null 2>&1

while(true); do
    eval `echo | get_config <<EOF
eth_interface=
EOF
`

    if [ "$eth_interface" = "ath0" ]; then
	# make sure that supplicant is running
	wpa_cli status
	if [ "$?" = "255" ]; then
	    # not running -> start and send to background
	    wpa_supplicant -iath0 -c /etc/wpa_supplicant.conf -w -qq -B
	    sleep 10
	fi
	# Reassociate if not associated -- a hack against endless scanning
	# while frequency remained frozen after reboot (in final).
	wpa_cli status|grep wpa_state |grep -e 'DISCONNECTED\|SCANNING'
	exit=$?
	if [ "$exit" = "0" ]; then
	    wpa_cli reassociate
	fi
	sleep 30
    else
	sleep 999999
    fi
done
