/***************************************************************************** 
 * This file contains definitions for the SAA6721 TFT controller.
 *
 * Copyright (c) 2002 Peppercon AG
 *
 * Swen Anderson, sand@peppercon.com
 *
 * All rights reserved.
 *
 * $Id: saa6721.h,v 1.1.1.1 2002/06/13 16:19:43 miba Exp $
 ****************************************************************************/

#ifndef _SAA6721_H
#define _SAA6721_H

#define I2C_ADDRESS_SAA6721			0x3A

/* state */
#define SAA6721_IICTEST				2
#define SAA6721_INT_STATE			3
#define SAA6721_INT_STATE_ACTIVELOW		0x01

/* RGB mode detection */
#define SAA6721_RGBMODE				4
#define SAA6721_RGBMODE_HSYNC_NOT_PRESENT	0x01
#define SAA6721_RGBMODE_VSYNC_NOT_PRESENT	0x02
#define SAA6721_RGBMODE_POSITIVE_HSYNC		0x04
#define SAA6721_RGBMODE_POSITIVE_VSYNC		0x08

#define SAA6721_VERT_FRAME_RES1			5
#define SAA6721_VERT_FRAME_RES2			6
#define SAA6721_HORI_FRAME_RES1			7
#define SAA6721_HORI_FRAME_RES2			8

/* RGB auto adjustment */
#define SAA6721_RGB_AA_REF_LINE_POS_VALUE	50
#define SAA6721_RGB_AA_REF_LINE_POS1		9
#define SAA6721_RGB_AA_REF_LINE_POS1_VALUE	(SAA6721_RGB_AA_REF_LINE_POS_VALUE & 0xFF)
#define SAA6721_RGB_AA_REF_LINE_POS2		10
#define SAA6721_RGB_AA_REF_LINE_POS2_VALUE	((SAA6721_RGB_AA_REF_LINE_POS_VALUE >> 8) & 0xFF)	

#define SAA6721_RGB_AA_REF_PIXEL_POS_VALUE	300
#define SAA6721_RGB_AA_REF_PIXEL_POS1		11
#define SAA6721_RGB_AA_REF_PIXEL_POS1_VALUE	(SAA6721_RGB_AA_REF_PIXEL_POS_VALUE & 0xFF)
#define SAA6721_RGB_AA_REF_PIXEL_POS2		12
#define SAA6721_RGB_AA_REF_PIXEL_POS2_VALUE	((SAA6721_RGB_AA_REF_PIXEL_POS_VALUE >> 8) & 0xFF)

#define SAA6721_RGB_AA_REF_COLOR		13
#define SAA6721_RGB_AA_REF_COLOR_VALUE		0x10

#define SAA6721_RGB_AA_REF_PIXEL_COLOR_RED	14
#define SAA6721_RGB_AA_REF_PIXEL_COLOR_GREEN	15
#define SAA6721_RGB_AA_REF_PIXEL_COLOR_BLUE	16

#define SAA6721_RGB_AA_BLACK_LINES		17
#define SAA6721_RGB_AA_BLACK_PIXELS1		18
#define SAA6721_RGB_AA_BLACK_PIXELS2		19
#define SAA6721_RGB_AA_NON_BLACK_LINES1		20
#define SAA6721_RGB_AA_NON_BLACK_LINES2		21
#define SAA6721_RGB_AA_NON_BLACK_PIXELS1	22
#define SAA6721_RGB_AA_NON_BLACK_PIXELS2	23

/* general configuration */
#define SAA6721_CFG_REG1			24
#define SAA6721_CFG_REG1_PROC_PATH_RESET	0x01
#define SAA6721_CFG_REG1_MEM_PATH_RESET		0x02
#define SAA6721_CFG_REG1_INPUT_PATH_RESET	0x04
#define SAA6721_CFG_REG1_START_MEM_INIT		0x08
#define SAA6721_CFG_REG1_NO_EXT_MEM_PRESENT	0x10
#define SAA6721_CFG_REG1_ONE_EXT_ADC		0x20
#define SAA6721_CFG_REG1_RESET_INT		0x40

#define SAA6721_CFG_REG2			25
#define SAA6721_CFG_REG2_ALL_OUTPUT_LOW		0x01
#define SAA6721_CFG_REG2_BLANK_SCREEN		0x02
#define SAA6721_CFG_REG2_TEMP_DITH_OUTPUT	0x04
#define SAA6721_CFG_REG2_STRAIGHT_RGB		0x08
#define SAA6721_CFG_REG2_CLOCK_AT_MCLKI		0x10

/* clock distribution */
#define SAA6721_CLOCKREG			26
#define SAA6721_CLOCKREG_MEMCLK_HALF_PLLCLK	0x01
#define SAA6721_CLOCKREG_PANELCLK_FROM_PLL	0x02
#define SAA6721_CLOCKREG_PLL_ENABLE		0x04
#define SAA6721_CLOCKREG_POSTDIV_HALF_PREC	0x08
#define SAA6721_CLOCKREG_PREDIV_HALF_PREC	0x10
#define SAA6721_CLOCKREG_POSTDIV_ENABLE		0x20
#define SAA6721_CLOCKREG_PREDIV_ENABLE		0x40
#define SAA6721_CLOCKREG_MEMCLK_FROM_SYSCLK	0x80

#define SAA6721_PREDIV_P_COUNTER		27
#define SAA6721_PREDIV_P_COUNTER_VALUE		0x11
#define SAA6721_PREDIV_N_COUNTER		28
#define SAA6721_PREDIV_N_COUNTER_VALUE		0x00
#define SAA6721_PREDIV_N_OFFSET			29
#define SAA6721_PREDIV_N_OFFSET_VALUE		0x00

#define SAA6721_POSTDIV_P_COUNTER		30
#define SAA6721_POSTDIV_P_COUNTER_VALUE		0xFF
#define SAA6721_POSTDIV_N_COUNTER		31
#define SAA6721_POSTDIV_N_COUNTER_VALUE		0x00
#define SAA6721_POSTDIV_N_OFFSET		32
#define SAA6721_POSTDIV_N_OFFSET_VALUE		0x00

/* input interface */
#define SAA6721_INP_GP				33
#define SAA6721_INP_GP_HSYNC_HIGH_ACTIVE	0x01
#define SAA6721_INP_GP_VSYNC_HIGH_ACTIVE	0x02
#define SAA6721_INP_GP_CLAMP_HIGH_ACTIVE	0x04
#define SAA6721_INP_GP_GAIN_HIGH_ACTIVE		0x08
#define SAA6721_INP_GP_ADC1_SAMPLED_FIRST	0x10
#define SAA6721_INP_GP_RGB_PROCESSING		0x20
#define SAA6721_INP_GP_DATA_SAMPLING_ON		0x40
#define SAA6721_INP_GP_INTERLACED_RGB		0x80

#define SAA6721_INP_IMP				34
#define SAA6721_INP_IMP_YUVCREF_HIGH_ACTIVE	0x01
#define SAA6721_INP_IMP_YUVHREF_HIGH_ACTIVE	0x02
#define SAA6721_INP_IMP_YUV_FORMAT_CCIR656	(0<<2)
#define SAA6721_INP_IMP_YUV_FORMAT_411		(1<<2)
#define SAA6721_INP_IMP_YUV_FORMAT_422		(2<<2)
#define SAA6721_INP_IMP_YUV_FORMAT_444		(3<<2)
#define SAA6721_INP_IMP_YUV_SAMPLE_ALL		(0<<4)
#define SAA6721_INP_IMP_YUV_SAMPLE_ALTERNATE	(1<<4)
#define SAA6721_INP_IMP_YUV_SAMPLE_ODD		(2<<4)
#define SAA6721_INP_IMP_YUV_SAMPLE_EVEN		(3<<4)
#define SAA6721_INP_IMP_FIELD_REVERSE_CHANGE	0x40

#define SAA6721_INP_VERT_SAMPLE_OFFSET_VALUE	30
#define SAA6721_INP_VERT_SAMPLE_OFFSET1		35
#define SAA6721_INP_VERT_SAMPLE_OFFSET1_VALUE	(SAA6721_INP_VERT_SAMPLE_OFFSET_VALUE & 0xFF)
#define SAA6721_INP_VERT_SAMPLE_OFFSET2		36
#define SAA6721_INP_VERT_SAMPLE_OFFSET2_VALUE	((SAA6721_INP_VERT_SAMPLE_OFFSET_VALUE >> 8) & 0xFF)

#define SAA6721_INP_HORI_SAMPLE_OFFSET_VALUE	30
#define SAA6721_INP_HORI_SAMPLE_OFFSET1		37
#define SAA6721_INP_HORI_SAMPLE_OFFSET1_VALUE	(SAA6721_INP_HORI_SAMPLE_OFFSET_VALUE & 0xFF)
#define SAA6721_INP_HORI_SAMPLE_OFFSET2		38
#define SAA6721_INP_HORI_SAMPLE_OFFSET2_VALUE	((SAA6721_INP_HORI_SAMPLE_OFFSET_VALUE >> 8) & 0xFF)

#define SAA6721_INP_VERT_SAMPLE_LENGTH_VALUE	617
#define SAA6721_INP_VERT_SAMPLE_LENGTH1		39
#define SAA6721_INP_VERT_SAMPLE_LENGTH1_VALUE	(SAA6721_INP_VERT_SAMPLE_LENGTH_VALUE & 0xFF)
#define SAA6721_INP_VERT_SAMPLE_LENGTH2		40
#define SAA6721_INP_VERT_SAMPLE_LENGTH2_VALUE	((SAA6721_INP_VERT_SAMPLE_LENGTH_VALUE >> 8) & 0xFF)

#define SAA6721_INP_HORI_SAMPLE_LENGTH_VALUE	1200
#define SAA6721_INP_HORI_SAMPLE_LENGTH1		41
#define SAA6721_INP_HORI_SAMPLE_LENGTH1_VALUE	(SAA6721_INP_HORI_SAMPLE_LENGTH_VALUE & 0xFF)
#define SAA6721_INP_HORI_SAMPLE_LENGTH2		42
#define SAA6721_INP_HORI_SAMPLE_LENGTH2_VALUE	((SAA6721_INP_HORI_SAMPLE_LENGTH_VALUE >> 8) & 0xFF)

#define SAA6721_INP_CLAMP_PULSE_START		43
#define SAA6721_INP_CLAMP_PULSE_START_VALUE	0

#define SAA6721_INP_CLAMP_PULSE_END		44
#define SAA6721_INP_CLAMP_PULSE_END_VALUE	50

#define SAA6721_INP_GAIN_PULSE_START_DELAY	45
#define SAA6721_INP_GAIN_PULSE_START_DELAY_VALUE	0

#define SAA6721_INP_GAIN_PULSE_END_DELAY	46
#define SAA6721_INP_GAIN_PULSE_END_DELAY_VALUE	2


/* colour correction */
#define SAA6721_CC_PRG				47
#define SAA6721_CC_PRG_SUBST_ENABLE		0x01
#define SAA6721_CC_PRG_BLUE_CORR_ENABLE		0x02
#define SAA6721_CC_PRG_GREEN_CORR_ENABLE	0x04
#define SAA6721_CC_PRG_RED_CORR_ENABLE		0x08

#define SAA6721_CC_LOOKUP_INDEX			48
#define SAA6721_CC_LOOKUP_INDEX_VALUE		0x00

#define SAA6721_CC_LOOKUP_VALUE			49
#define SAA6721_CC_LOOKUP_VALUE_VALUE		0x00

/* memory interface */
#define SAA6721_MEM_CFG				50
#define SAA6721_MEM_CFG_DEINT_NO		0x0
#define SAA6721_MEM_CFG_DEINT_WO_FILT		0x1
#define SAA6721_MEM_CFG_DEINT_SPAT_FILT		0x2
#define SAA6721_MEM_CFG_DEINT_TEMP_FILT		0x3
#define SAA6721_MEM_CFG_BUS_32			(0x0<<2)
#define SAA6721_MEM_CFG_BUS_48			(0x1<<2)
#define SAA6721_MEM_CFG_BUS_64			(0x2<<2)
#define SAA6721_MEM_CFG_INT_DATAPATH_YUV	0x10

#define SAA6721_MEM_ACCESS_BURST_LENGTH		51
#define SAA6721_MEM_ACCESS_BURST_LENGTH_VALUE	8         /* SDRAM burst_seq_length for TFT Controller */

#define SAA6721_MEM_SDRAM_BURST_LENGTH		52
#define SAA6721_MEM_SDRAM_BURST_LENGTH_INIT	(0x3<<4)  /* SDRAM burst length code for SDRAM */
#define SAA6721_MEM_SDRAM_BURST_LENGTH_VALUE	(8 | SAA6721_MEM_SDRAM_BURST_LENGTH_INIT) /* SDRAM_burst_length for SDRAM */

#define SAA6721_MEM_SDRAM_TIMING1		53
#define SAA6721_MEM_SDRAM_TIMING1_TRCD		2      /* T_RCD */
#define SAA6721_MEM_SDRAM_TIMING1_CAS_LAT	(3<<4) /* T_CAS */
#define SAA6721_MEM_SDRAM_TIMING1_VALUE		(SAA6721_MEM_SDRAM_TIMING1_TRCD | SAA6721_MEM_SDRAM_TIMING1_CAS_LAT)

#define SAA6721_MEM_SDRAM_TIMING2		54
#define SAA6721_MEM_SDRAM_TIMING2_TRP		3      /* T_RP */
#define SAA6721_MEM_SDRAM_TIMING2_TRRD		(3<<4) /* T_RRD */
#define SAA6721_MEM_SDRAM_TIMING2_VALUE		(SAA6721_MEM_SDRAM_TIMING2_TRP | SAA6721_MEM_SDRAM_TIMING2_TRRD)

#define SAA6721_MEM_SDRAM_TIMING3		55
#define SAA6721_MEM_SDRAM_TIMING3_TRC		7  /* T_RC */
#define SAA6721_MEM_SDRAM_TIMING3_TWR		(2<<4) /* T_WR is assumed: change it to 1 */
#define SAA6721_MEM_SDRAM_TIMING3_VALUE		(SAA6721_MEM_SDRAM_TIMING3_TRC | SAA6721_MEM_SDRAM_TIMING3_TWR)

#define SAA6721_MEM_FIELD1_START_ROW_VALUE	0
#define SAA6721_MEM_FIELD1_START_ROW1		56
#define SAA6721_MEM_FIELD1_START_ROW1_VALUE	(SAA6721_MEM_FIELD1_START_ROW_VALUE & 0xFF)
#define SAA6721_MEM_FIELD1_START_ROW2		57
#define SAA6721_MEM_FIELD1_START_ROW2_VALUE	((SAA6721_MEM_FIELD1_START_ROW_VALUE >> 8) & 0xFF)

#define SAA6721_MEM_FIELD1_START_COLUMN		58
#define SAA6721_MEM_FIELD1_START_COLUMN_VALUE	0

#define SAA6721_MEM_FIELD2_START_ROW_VALUE	0
#define SAA6721_MEM_FIELD2_START_ROW1		59
#define SAA6721_MEM_FIELD2_START_ROW1_VALUE	(SAA6721_MEM_FIELD2_START_ROW_VALUE & 0xFF)
#define SAA6721_MEM_FIELD2_START_ROW2		60
#define SAA6721_MEM_FIELD2_START_ROW2_VALUE	((SAA6721_MEM_FIELD2_START_ROW_VALUE >> 8) & 0xFF)

#define SAA6721_MEM_FIELD2_START_COLUMN		61
#define SAA6721_MEM_FIELD2_START_COLUMN_VALUE	0

#define SAA6721_MEM_FIELD3_START_ROW_VALUE	0
#define SAA6721_MEM_FIELD3_START_ROW1		62
#define SAA6721_MEM_FIELD3_START_ROW1_VALUE	(SAA6721_MEM_FIELD3_START_ROW_VALUE & 0xFF)
#define SAA6721_MEM_FIELD3_START_ROW2		63
#define SAA6721_MEM_FIELD3_START_ROW2_VALUE	((SAA6721_MEM_FIELD3_START_ROW_VALUE >> 8) & 0xFF)

#define SAA6721_MEM_FIELD3_START_COLUMN		64
#define SAA6721_MEM_FIELD3_START_COLUMN_VALUE	0

#define SAA6721_MEM_FIELD4_START_ROW_VALUE	0
#define SAA6721_MEM_FIELD4_START_ROW1		65
#define SAA6721_MEM_FIELD4_START_ROW1_VALUE	(SAA6721_MEM_FIELD4_START_ROW_VALUE & 0xFF)
#define SAA6721_MEM_FIELD4_START_ROW2		66
#define SAA6721_MEM_FIELD4_START_ROW2_VALUE	((SAA6721_MEM_FIELD4_START_ROW_VALUE >> 8) & 0xFF)

#define SAA6721_MEM_FIELD4_START_COLUMN		67
#define SAA6721_MEM_FIELD4_START_COLUMN_VALUE	0

#define SAA6721_MEM_OUT_FRAME_LENGTH_VALUE	600
#define SAA6721_MEM_OUT_FRAME_LENGTH1		68
#define SAA6721_MEM_OUT_FRAME_LENGTH1_VALUE	(SAA6721_MEM_OUT_FRAME_LENGTH_VALUE & 0xFF)
#define SAA6721_MEM_OUT_FRAME_LENGTH2		69
#define SAA6721_MEM_OUT_FRAME_LENGTH2_VALUE	((SAA6721_MEM_OUT_FRAME_LENGTH_VALUE >> 8) & 0xFF)

#define SAA6721_MEM_OUT_LINE_LENGTH_VALUE	800
#define SAA6721_MEM_OUT_LINE_LENGTH1		70
#define SAA6721_MEM_OUT_LINE_LENGTH1_VALUE	(SAA6721_MEM_OUT_LINE_LENGTH_VALUE & 0xFF)
#define SAA6721_MEM_OUT_LINE_LENGTH2		71
#define SAA6721_MEM_OUT_LINE_LENGTH2_VALUE	((SAA6721_MEM_OUT_LINE_LENGTH_VALUE >> 8) & 0xFF)

#define SAA6721_MEM_BLACK_RED_COMP		72
#define SAA6721_MEM_BLACK_RED_COMP_VALUE	0xff	/* D(7..0)   */

#define SAA6721_MEM_BLACK_GREEN_COMP		73
#define SAA6721_MEM_BLACK_GREEN_COMP_VALUE	0x00    /* D(15..8)  */

#define SAA6721_MEM_BLACK_BLUE_COMP		74
#define SAA6721_MEM_BLACK_BLUE_COMP_VALUE	0x00    /* D(23..16) */

/* scaler definitions */


/* panninig unit definitions */
#define SAA6721_PU_PIC_V_OFFSET_VALUE		0
#define SAA6721_PU_PIC_V_OFFSET1		88
#define SAA6721_PU_PIC_V_OFFSET1_VALUE		(SAA6721_PU_PIC_V_OFFSET_VALUE & 0xFF)
#define SAA6721_PU_PIC_V_OFFSET2		89
#define SAA6721_PU_PIC_V_OFFSET2_VALUE          ((SAA6721_PU_PIC_V_OFFSET_VALUE >> 8) & 0x7)

#define SAA6721_PU_PIC_H_OFFSET_VALUE		0
#define SAA6721_PU_PIC_H_OFFSET1		90
#define SAA6721_PU_PIC_H_OFFSET1_VALUE		(SAA6721_PU_PIC_H_OFFSET_VALUE & 0xFF)
#define SAA6721_PU_PIC_H_OFFSET2		91
#define SAA6721_PU_PIC_H_OFFSET2_VALUE          ((SAA6721_PU_PIC_H_OFFSET_VALUE >> 8) & 0xf)

#define SAA6721_PU_PIC_V_SIZE_VALUE		768
#define SAA6721_PU_PIC_V_SIZE1			92
#define SAA6721_PU_PIC_V_SIZE1_VALUE		(SAA6721_PU_PIC_V_SIZE_VALUE & 0xFF)
#define SAA6721_PU_PIC_V_SIZE2			93
#define SAA6721_PU_PIC_V_SIZE2_VALUE		((SAA6721_PU_PIC_V_SIZE_VALUE >> 8) & 0x7)

#define SAA6721_PU_PIC_H_SIZE_VALUE		1024
#define SAA6721_PU_PIC_H_SIZE1			94
#define SAA6721_PU_PIC_H_SIZE1_VALUE		(SAA6721_PU_PIC_H_SIZE_VALUE & 0xFE)
#define SAA6721_PU_PIC_H_SIZE2			95
#define SAA6721_PU_PIC_H_SIZE2_VALUE		((SAA6721_PU_PIC_H_SIZE_VALUE >> 8) & 0xF)

#define SAA6721_PU_BORDER_RED			96
#define SAA6721_PU_BORDER_RED_VALUE		0x12
#define SAA6721_PU_BORDER_GREEN			97
#define SAA6721_PU_BORDER_GREEN_VALUE		0x34
#define SAA6721_PU_BORDER_BLUE			98
#define SAA6721_PU_BORDER_BLUE_VALUE		0x56


/* osd overlay port definitions */

/* on screen display */

/* on screen display window */

/* on screen display character matrix */

#define TFT_VSIZE	(600)
#define TFT_HSIZE	(800)
#define TFT_PHS_LENGTH    1

/* TFT display interface */
#define SAA6721_TFT_CFG1			202
#define SAA6721_TFT_CFG1_SINGLE_PIXEL_OUTPUT	0x01
#define SAA6721_TFT_CFG1_OUTPUT_RISING_PCLK	0x02
#define SAA6721_TFT_CFG1_PDE_HIGH_ACTIVE	0x04
#define SAA6721_TFT_CFG1_PHS_HIGH_ACTIVE	0x08
#define SAA6721_TFT_CFG1_PVS_HIGH_ACTIVE	0x10

#define SAA6721_TFT_CFG2			203
#define SAA6721_TFT_CFG2_LLC_ACT_VIDEO_ON	0x01
#define SAA6721_TFT_CFG2_LLC_BORDER_ON		0x02
#define SAA6721_TFT_CFG2_LLC_TOP_BLANCK_ON	0x04
#define SAA6721_TFT_CFG2_SYNC_OUTPUT_MODE	0x08
#define SAA6721_TFT_CFG2_BLANCKING_MODE		0x10
#define SAA6721_TFT_CFG2_OUTPUT_IF_ON		0x20
#define SAA6721_TFT_CFG2_PDE_PULSE_VERT_ON	0x40
#define SAA6721_TFT_CFG2_LINE_SYNC_OFF		0x80

#define SAA6721_TFT_HL_LENGTH_BLANCK_VALUE	TFT_HSIZE
#define SAA6721_TFT_HL_LENGTH_BLANCK1		204	/* h_len_blank */
#define SAA6721_TFT_HL_LENGTH_BLANCK1_VALUE	(SAA6721_TFT_HL_LENGTH_BLANCK_VALUE & 0xFF)
#define SAA6721_TFT_HL_LENGTH_BLANCK2		205
#define SAA6721_TFT_HL_LENGTH_BLANCK2_VALUE	((SAA6721_TFT_HL_LENGTH_BLANCK_VALUE >> 8) & 0xFF)

#define SAA6721_TFT_HL_LENGTH_BORDER_VALUE	TFT_HSIZE
#define SAA6721_TFT_HL_LENGTH_BORDER1		206	/* h_len_border */
#define SAA6721_TFT_HL_LENGTH_BORDER1_VALUE	(SAA6721_TFT_HL_LENGTH_BORDER_VALUE & 0xFF)
#define SAA6721_TFT_HL_LENGTH_BORDER2		207
#define SAA6721_TFT_HL_LENGTH_BORDER2_VALUE	((SAA6721_TFT_HL_LENGTH_BORDER_VALUE >> 8) & 0xFF)

#define SAA6721_TFT_HL_LENGTH_ACTIVE_VALUE	TFT_HSIZE
#define SAA6721_TFT_HL_LENGTH_ACTIVE1		208	/* h_len_active */
#define SAA6721_TFT_HL_LENGTH_ACTIVE1_VALUE	(SAA6721_TFT_HL_LENGTH_ACTIVE_VALUE & 0xFF)
#define SAA6721_TFT_HL_LENGTH_ACTIVE2		209
#define SAA6721_TFT_HL_LENGTH_ACTIVE2_VALUE	((SAA6721_TFT_HL_LENGTH_ACTIVE_VALUE >> 8) & 0xFF)

#define SAA6721_TFT_V_FRAME_LENGTH_VALUE	TFT_VSIZE
#define SAA6721_TFT_V_FRAME_LENGTH1		210	/* v_end */
#define SAA6721_TFT_V_FRAME_LENGTH1_VALUE	(SAA6721_TFT_V_FRAME_LENGTH_VALUE & 0xFF)
#define SAA6721_TFT_V_FRAME_LENGTH2		211
#define SAA6721_TFT_V_FRAME_LENGTH2_VALUE	((SAA6721_TFT_V_FRAME_LENGTH_VALUE >> 8) & 0xFF)

#define SAA6721_TFT_V_START_BORDER_VALUE	0
#define SAA6721_TFT_V_START_BORDER1		212	/* v_start */
#define SAA6721_TFT_V_START_BORDER1_VALUE	(SAA6721_TFT_V_START_BORDER_VALUE & 0xFF)
#define SAA6721_TFT_V_START_BORDER2		213
#define SAA6721_TFT_V_START_BORDER2_VALUE	((SAA6721_TFT_V_START_BORDER_VALUE >> 8) & 0xFF)

#define SAA6721_TFT_V_START_ACTIVE_VALUE	0
#define SAA6721_TFT_V_START_ACTIVE1		214	/* v_active */
#define SAA6721_TFT_V_START_ACTIVE1_VALUE	(SAA6721_TFT_V_START_ACTIVE_VALUE & 0xFF)
#define SAA6721_TFT_V_START_ACTIVE2		215
#define SAA6721_TFT_V_START_ACTIVE2_VALUE	((SAA6721_TFT_V_START_ACTIVE_VALUE >> 8) & 0xFF)

#define SAA6721_TFT_HDEL_START_VSYNC_VALUE	0
#define SAA6721_TFT_HDEL_START_VSYNC1		216	/* h_vs_start */
#define SAA6721_TFT_HDEL_START_VSYNC1_VALUE	(SAA6721_TFT_HDEL_START_VSYNC_VALUE & 0xFF)
#define SAA6721_TFT_HDEL_START_VSYNC2		217
#define SAA6721_TFT_HDEL_START_VSYNC2_VALUE	((SAA6721_TFT_HDEL_START_VSYNC_VALUE >> 8) & 0xFF)

#define SAA6721_TFT_HDEL_END_VSYNC_VALUE	0
#define SAA6721_TFT_HDEL_END_VSYNC1		218	/* h_vs_end */   
#define SAA6721_TFT_HDEL_END_VSYNC1_VALUE	(SAA6721_TFT_HDEL_END_VSYNC_VALUE & 0xFF)
#define SAA6721_TFT_HDEL_END_VSYNC2		219
#define SAA6721_TFT_HDEL_END_VSYNC2_VALUE	((SAA6721_TFT_HDEL_END_VSYNC_VALUE >> 8) & 0xFF)

#define SAA6721_TFT_HSYNC_PULSE_START_VALUE	0	/* h_hs_start */ /* PHS start */
#define SAA6721_TFT_HSYNC_PULSE_START1		220
#define SAA6721_TFT_HSYNC_PULSE_START1_VALUE	(SAA6721_TFT_HSYNC_PULSE_START_VALUE & 0xFF)
#define SAA6721_TFT_HSYNC_PULSE_START2		221
#define SAA6721_TFT_HSYNC_PULSE_START2_VALUE	((SAA6721_TFT_HSYNC_PULSE_START_VALUE >> 8) & 0xFF)

#define SAA6721_TFT_HSYNC_PULSE_END_VALUE	TFT_PHS_LENGTH	/* h_hs_end */   /* PHS end*/
#define SAA6721_TFT_HSYNC_PULSE_END1		222
#define SAA6721_TFT_HSYNC_PULSE_END1_VALUE	(SAA6721_TFT_HSYNC_PULSE_END_VALUE & 0xFF)
#define SAA6721_TFT_HSYNC_PULSE_END2		223
#define SAA6721_TFT_HSYNC_PULSE_END2_VALUE	((SAA6721_TFT_HSYNC_PULSE_END_VALUE >> 8) & 0xFF)

#define SAA6721_TFT_START_PDE_VALUE		0	/* h_de_start */ /* PDE start */
#define SAA6721_TFT_START_PDE1			224
#define SAA6721_TFT_START_PDE1_VALUE		(SAA6721_TFT_START_PDE_VALUE & 0xFF)
#define SAA6721_TFT_START_PDE2			225
#define SAA6721_TFT_START_PDE2_VALUE		((SAA6721_TFT_START_PDE_VALUE >> 8) & 0xFF)

#define SAA6721_TFT_END_PDE_VALUE		TFT_HSIZE	/* h_de_end */  /* PDE end */
#define SAA6721_TFT_END_PDE1			226
#define SAA6721_TFT_END_PDE1_VALUE		(SAA6721_TFT_END_PDE_VALUE & 0xFF)
#define SAA6721_TFT_END_PDE2			227
#define SAA6721_TFT_END_PDE2_VALUE		((SAA6721_TFT_END_PDE_VALUE >> 8) & 0xFF)

#define SAA6721_TFT_HOR_ACTIVE_START_VALUE	0	/* h_active_start */
#define SAA6721_TFT_HOR_ACTIVE_START1		228
#define SAA6721_TFT_HOR_ACTIVE_START1_VALUE	(SAA6721_TFT_HOR_ACTIVE_START_VALUE & 0xFF)
#define SAA6721_TFT_HOR_ACTIVE_START2		229
#define SAA6721_TFT_HOR_ACTIVE_START2_VALUE	((SAA6721_TFT_HOR_ACTIVE_START_VALUE >> 8) & 0xFF)

#define SAA6721_TFT_VERT_SYNC_END_VALUE		1	/* v_vs_end */  /* PVS end */
#define SAA6721_TFT_VERT_SYNC_END1		230
#define SAA6721_TFT_VERT_SYNC_END1_VALUE	(SAA6721_TFT_VERT_SYNC_END_VALUE & 0xFF)
#define SAA6721_TFT_VERT_SYNC_END2		231
#define SAA6721_TFT_VERT_SYNC_END2_VALUE	((SAA6721_TFT_VERT_SYNC_END_VALUE >> 8) & 0xFF)

#define SAA6721_TFT_MAX_HOR_LLENGTH_VALUE	TFT_HSIZE
#define SAA6721_TFT_MAX_HOR_LLENGTH1		232	/* h_max_len */
#define SAA6721_TFT_MAX_HOR_LLENGTH1_VALUE	(SAA6721_TFT_MAX_HOR_LLENGTH_VALUE & 0xFF)
#define SAA6721_TFT_MAX_HOR_LLENGTH2		233
#define SAA6721_TFT_MAX_HOR_LLENGTH2_VALUE	((SAA6721_TFT_MAX_HOR_LLENGTH_VALUE >> 8) & 0xFF)


#endif /* _SAA6721_H */
