/*----------------------------------------------------------
* Copyright (c) 2002 by National Semiconductor Corporation
* All rights reserved.
*-----------------------------------------------------------
* File Contents:
*     PCI access, search and Device Id handling
* Project:  PC87431
*---------------------------------------------------------*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>                         
#include <conio.h>
#include "common.h"
#include "pci.h"

unsigned long get_PCI_config_addr(unsigned long pci_id)
{
  unsigned long i, current_pci_id, pci_config_addr;

  for (i=0; i<32; i++)
  {
    pci_config_addr  = 0x80000000 | ((i<<11)&0xFF00);
	current_pci_id = PCIC_IN_32(pci_config_addr, 0);
	if ( current_pci_id == pci_id ) break;
  }

  return pci_config_addr;
}

unsigned long get_PCI_devid(unsigned char dev, unsigned char func)
{
    unsigned long current_pci_id, pci_config_addr;

    pci_config_addr  = 0x80000000 | ((dev<<11)&0xFF00);
    pci_config_addr |= ((func<<8)&0x0700);

	current_pci_id = PCIC_IN_32(pci_config_addr, 0);

  return current_pci_id;
}



#ifdef kuku
/**********************************************
******             search_pci()          ******
***********************************************/
UINT search_pci( ULONG ID ) {
ULONG   pci_address=0x80000000L, pci_data;
UINT    x;

	for(x=0;x<31;x++) {
		pci_data = read_pci( pci_address );
		if(pci_data==ID) return(1);
		pci_address += 0x00000800L;
	}
	return(0);
}

/**********************************************
******             read_pci()            ******
***********************************************/
ULONG read_pci( ULONG addr ) {
ULONG   pci_data;
	cli();
	outpd( 0xCF8, addr );
	pci_data = inpd( 0xCFC );
	sti();
	return(pci_data);
}

/**********************************************
******            write_pci()            ******
***********************************************/
void write_pci( ULONG addr, ULONG data ) {

	cli();
	outpd( 0xCF8, addr );
	outpd( 0xCFC, data );
	sti();
}
#endif
