/*
 * This file is part of "The Java Telnet Application".
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * "The Java Telnet Application" is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
package de.mud.jta.event;

import de.mud.jta.PluginMessage;
import de.mud.jta.PluginListener;
import de.mud.jta.PluginConfig;
import de.mud.jta.event.ConfigurationListener;


/**
 * Configuration request message. Subclassing this message can be used to
 * make the configuration more specific and efficient.
 * <P>
 * <B>Maintainer:</B> Matthias L. Jugel
 *
 * @version $Id: ConfigurationRequest.java,v 2.1 2000/01/26 15:34:05 leo Exp $
 * @author Matthias L. Jugel, Marcus Meiner
 */
public class ConfigurationRequest implements PluginMessage {
  PluginConfig config;

  public ConfigurationRequest(PluginConfig config) {
    this.config = config;
  }

  /**
   * Notify all listeners of a configuration event.
   * @param pl the list of plugin message listeners
   */
  public Object firePluginMessage(PluginListener pl) {
    if(pl instanceof ConfigurationListener) {
      ((ConfigurationListener)pl).setConfiguration(config);
    }
    return null;
  }
}
