/*
 * This file is part of "The Java Telnet Application".
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * "The Java Telnet Application" is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

package de.mud.jta.event;

import de.mud.jta.PluginListener;

/**
 * This interface should be used by plugins who would like to be notified
 * about the return of the focus from another plugin.
 * <P>
 * Implemented after a suggestion by Dave &lt;david@mirrabooka.com&gt;
 * <P>
 * <B>Maintainer:</B> Matthias L. Jugel
 *
 * @version $Id: ReturnFocusListener.java,v 1.1 2000/06/28 07:41:02 leo Exp $
 * @author Matthias L. Jugel, Marcus Meiner
 */
public interface ReturnFocusListener extends PluginListener {
  /** Called if the end of return focus message is sent. */
  public void returnFocus();
}
