/******************************************************************/
/*                                                                */
/* Module:       jb_io.h                                          */
/*                                                                */
/* Descriptions: Manages I/O related routines, file and string    */
/*               processing functions.                            */
/*                                                                */
/* Revisions:    1.0 02/22/02                                     */
/*                                                                */
/******************************************************************/

#ifndef JB_IO_H
#define JB_IO_H

#define PPC405		1
#ifndef DEBUGLEVEL
#define DEBUGLEVEL D_NOTICE
#endif

#define D_ALWAYS	0
#define D_ERROR		1
#define D_NOTICE	2
#define D_VERBOSE	3
#define D_BLABLA	4

#define D(x, fmt, args...) do { if (x <= DEBUGLEVEL) { printf("jblaster: "); printf(fmt, ##args); } } while (0)

#define UNUSED __attribute__ ((unused))

void	flush_ports		( void );
void	CloseLinuxDriver	( void );
void	InitLinuxDriver		( void );
int	VerifyHardware		( void );

int   ReadPort(int);
void  WritePort(int port,int data,int test);
int   jb_fopen(const char*,const char* );
int   jb_fclose(int file_id );
int   jb_fseek(int,int,int );
int   jb_ftell(int finputid );
int   jb_fgetc(int finputid );
char* jb_fgets(char* buffer,int finputid);

int   jb_grabdata(char* buffer,int start_byte,int term,char* str);
void  jb_strcpy(char* a,const char* b);
int   jb_str_cmp(const char* charset,const char* buffer);
int   jb_strlen(const char* str);
int   jb_strcmp(const char* a,const char* b);
void  jb_strcat(char* dst,const char* src);
int   jb_atoi(const char* number);
void  jb_toupper(char* str);

int   inb_ppc405(int port);
void  outb_ppc405(int data, int port);

void  set_tck(unsigned char val);    /* shared with ATMEL SCK */
void  set_tdi(unsigned char val);    /* shared with ATMEL MOSI */
void  set_tdi_byte(unsigned char val);
void  set_tms(unsigned char val);    /* shared with ATMEL RST */
unsigned int get_tdo(void);                 /* shared with ATMEL MISO */

#endif
