/******************************************************************************
 *  MODULE:           FPGA PROTOCOL
 ******************************************************************************
 *
 *  Virtual Media CIM Protocol Utilities header
 *
 *  FILE:             $Workfile$
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential
 * proprietary information distributed solely pursuant to a confidentiality
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#ifndef _VM_CIM_H_
#define _VM_CIM_H_

#include "vm_protocol.h"

extern int  vm_cim_send_init( int fd, int link_if );
extern int  vm_cim_send_protocol( int fd, int link_if, enum vm_category category, unsigned char cmd );
extern int  vm_cim_setup_version( enum version_component component, enum version_type type, unsigned char index );
extern int  vm_cim_setup_buffer( int type );
extern void vm_cim_set_display( char val );
extern int  vm_cim_setup_ccv( unsigned char ref );
extern int  vm_cim_setup_txtimeout( unsigned char timeout );
extern int  vm_cim_setup_write_eeprom( unsigned short offset, unsigned short cnt, unsigned char *pbuf );
extern int  vm_cim_setup_read_eeprom( unsigned short offset, unsigned short cnt );
extern int  vm_cim_setup_kbd_model( enum kbd_model model );
extern int  vm_cim_setup_kbd_language( enum kbd_language lang );
extern int  vm_cim_setup_mouse_mode( enum mouse_position position );
extern int  vm_cim_setup_led( enum led_settings setting );
extern int  vm_cim_setup_test_mode( enum test_mode test, unsigned char opt_cnt, unsigned char *opt );
extern int  vm_cim_setup_fpga_read( unsigned char addr );
extern int  vm_cim_setup_fpga_write( unsigned char addr, unsigned char data );
extern int  vm_cim_setup_stall_bulkep( unsigned char id, unsigned char setting );

#endif /* _VM_CIM_H_ */
