/******************************************************************************
 *  MODULE:           FPGA PROTOCOL
 ******************************************************************************
 *
 *  FPGA Protocol Device Diagnostic Utilities header
 *
 *  FILE:             $Workfile$
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential
 * proprietary information distributed solely pursuant to a confidentiality
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#ifndef _FPD_DIAG_H_
#define _FPD_DIAG_H_

#define MAX_PROTOCOL_BUFFER_SIZE               (512)
#define MAX_HOST_BUFFER_SIZE                   (64 * 1024)
#define POLL_TIMEOUT                           (60 * 1000)
#define MAX_TRIES                              (10000000)
#define RETRY_TIMEOUT                          (60)

typedef enum {
    RECEIVE = 0,
    SEND
} direction_t;

typedef enum {
    PKT_PATTERN_8BIT_ASCENDING = 0,
    PKT_PATTERN_8BIT_DESCENDING,
    PKT_PATTERN_8BIT_REPEATING,
    PKT_PATTERN_16BIT_ASCENDING,
    PKT_PATTERN_16BIT_DESCENDING,
    PKT_PATTERN_32BIT_ASCENDING,
    PKT_PATTERN_32BIT_DESCENDING,
} pkt_pattern_t;

typedef struct {
    int target_port;
    int protocol;
    int tx_parity;
    int rx_parity;
} line_connection_t;

/* global variables */
extern int debug_on;
extern unsigned char *protocol_buffer;
extern pkt_pattern_t pkt_pattern;
extern unsigned char ascending[MAX_PROTOCOL_BUFFER_SIZE];
extern unsigned char descending[MAX_PROTOCOL_BUFFER_SIZE];
extern unsigned char repeating[MAX_PROTOCOL_BUFFER_SIZE];
extern unsigned int  dma_page_size;
extern int           max_link_if;
extern char          bgnd_link_if_present;

/* function declarations */
extern int  fpd_init_diag( int fd );
extern int  fpd_cleanup_diag( void );
extern int  fpd_get_current_link_if( void );
extern int  fpd_get_link_if_protocol( void );
extern void fpd_display_info( int fd );
extern void fpd_display_pci_cfg( int fd );
extern int  fpd_read_reg( int fd );
extern int  fpd_write_reg( int fd );
extern int  fpd_get_line_connection_info( int link_if, line_connection_t **pconn );
extern int  fpd_set_line_connection_info( int link_id, int target, int protocol, int txpar, int rxpar );
extern int  fpd_disconnect_link( int fd, int link_id );
extern int  fpd_switch_link( int fd, int link_id, int target, int protocol, int txpar, int rxpar );
extern int  fpd_reset_linkif( int fd, int link_id );
extern int  fpd_select_masterslave( int fd );
extern int  fpd_get_switch_info( int fd );
extern void fpd_display_current_setup( void );
extern int  fpd_select_linkif( void );
extern int  fpd_select_linkif_and_line( int fd, int link_id );
extern int  fpd_write_buffer( int fd );
extern int  fpd_read_buffer( int fd );
extern void fpd_display_packet_info( int fd );
extern int  fpd_change_buffer_type( int fd );
extern int  fpd_change_packet( int fd );
extern int  fpd_poll_once( int fd, FPD_event_t *pevent );
extern int  fpd_send_pkt( int fd );
extern int  fpd_receive_pkt( int fd );
extern int  fpd_get_stats( int fd );
extern int  fpd_check_events( int fd );
extern int  fpd_get_link_errors( int fd );
extern int  fpd_get_pci_errors( int fd );
extern int  fpd_set_dma_burst_size( int fd );
extern int  fpd_get_dma_burst_size( int fd );
extern int  fpd_run_diag( int fd, int diag_code, direction_t direction, int enable );
extern int  fpd_send_pkts_continuously( int fd );
extern int  fpd_receive_pkts_continuously( int fd );
extern unsigned int fpd_get_buffer_type( void );
extern int  fpd_set_cable_type( int fd );
extern int  fpd_test_kxgen2_vm_port( int fd );
extern int  fpd_test_receiver_vm_port( int fd );

#endif /* _FPD_DIAG_ */
