/******************************************************************************
 *  MODULE:           FPGA PROTOCOL
 ******************************************************************************
 *
 *  Diagnostic Application for FPGA Protocol Device.
 *
 *  FILE:             $Workfile$
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential
 * proprietary information distributed solely pursuant to a confidentiality
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <fcntl.h>
#include <stdarg.h>
#include <string.h>
#include <sys/ioctl.h>

#include "fpd_menu.h"

#define FPD_DIAGNOSTICS_REV        "$Revision: 1.1 $"

static int fpd_verbose = 0;


static void log( char *fmt, ... )
{
    va_list ap;
    if( fpd_verbose ) {
        printf( "[fpd-diagnostics] " );
        va_start(ap,fmt);
        vprintf( fmt, ap );
        va_end(ap);
    }	
}

void msg( char *fmt, ... )
{
   va_list ap;
   printf( "[fpd-diagnostics] " );
   va_start(ap,fmt);
   vprintf( fmt, ap );
   va_end(ap);
}

void err( char *fmt, ... )
{
   va_list ap;
   fprintf( stderr, "[fpd-diagnostics] " );
   va_start(ap,fmt);
   vfprintf( stderr, fmt, ap );
   va_end(ap);	
}

static void usage( void )
{
    printf( "Use (" FPD_DIAGNOSTICS_REV "):\n"
            "fpd-diagnostics [options] [devname]\n\n"
            "    -h         help\n"
            "    -v         verbose\n"
            " [devname] is /dev/fpd\n\n");
}

int main( int argc, char * const argv[] )
{
    int ch;
    int fd;
    char dev[128] = "/dev/fpd";

    while( (ch = getopt(argc, argv, "hv")) != EOF ) {
        switch( ch ) {
            case 'v':
                fpd_verbose = 1;
                break;

            case 'h':
            default:
                usage();
                return 1;
        }
    }

    if( optind == argc-1 ) {
        strcpy(dev, argv[optind++]);
        log( "using %s as device node ...\n", dev );
    }

    if( (fd = open(dev, O_RDWR)) < 0 ) {
        err( "Cannot open %s : %s\n", dev, strerror(errno) );
        return 1;
    }

    fpd_menu(fd);

    close(fd);
	
    return 0;
}
