/******************************************************************************
 *  MODULE:           FPGA PROTOCOL
 ******************************************************************************
 *
 *  FPGA Protocol Device Driver Host Buffer Header File
 *
 *  FILE:             $Workfile$
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential
 * proprietary information distributed solely pursuant to a confidentiality
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#ifndef _FPD_HOST_H_
#define _FPD_HOST_H_

#include <linux/list.h>
#include "fpd_lock.h"
#include "fpd_ioctl.h"
#include "dmabuf.h"

#define FPD_HOST_BUFFER_SIZE                   (64 * 1024)
#define FPD_HOST_BUFFER_CNT                    (8)
#define FPD_HOST_DMA_BUFFER_SIZE               (FPD_HOST_BUFFER_SIZE * FPD_HOST_BUFFER_CNT)
#define FPD_HOST_DMA_RXBD_CNT                  (256)

#define FPD_HOST_BUFFER_STATE_FREE             0
#define FPD_HOST_BUFFER_STATE_USER_BUSY        1
#define FPD_HOST_BUFFER_STATE_PROCESSING       2
#define FPD_HOST_BUFFER_STATE_LIMBO            3

/* DMA RX Buffer Descriptor - Status bits */
#define FPD_HOST_DMA_RXBD_BYTE_CNT             0x000003FF
#define FPD_HOST_DMA_RXBD_BUSY                 0x00000400
#define FPD_HOST_DMA_RXBD_INT                  0x00000800

typedef struct {
    struct list_head       list;
    int                    count;
} dmabuf_list_t;

typedef struct {
    u16                    id;
    u16                    state;
    u32                    len;
    void *                 phys_addr;
    void *                 virtual_addr;
    struct list_head       list;

    /* RX-specific */
#ifdef NONCACHEABLE_RXBDTBL
    DMA_MEM                rx_bdtbl;
#else
    u32                   *rx_bdtbl;
#endif
    u16                    startbd;
    u16                    endbd;
} fpd_host_buf_t;

typedef struct {
    fpd_lock_t             lock;
    DMA_MEM                dmabuf;
    u32                    len;
    int                    buffer_empty;
    fpd_host_buf_t         hostbuf[FPD_HOST_BUFFER_CNT];
    fpd_host_buf_t        *current_rxbuf;
    dmabuf_list_t          process_buffer;
    dmabuf_list_t          user_buffer;
    dmabuf_list_t          free_buffer;
} fpd_host_txrx_t;

typedef struct {
    u32                    function;
    u32                    dma_size;
    u32                    rx_pkt_size_notification;
    u32                    rx_bdnum;
    fpd_host_txrx_t        tx;
    fpd_host_txrx_t        rx;
} fpd_host_chan_t;

typedef struct {
    u32                    link_if;
    void                  *private;
    fpd_host_chan_t      **channel;
} fpd_host_t;

typedef struct {
    u32                    buf_ptr;
    u32                    status;
} dma_rxbd_t;

typedef struct {
    dma_rxbd_t             bd[FPD_HOST_DMA_RXBD_CNT];
} dma_rxbd_table_t;


extern int fpd_host_init( fpd_host_t *phost, u32 link_if, u32 host_cnt, void *parg );
extern int fpd_host_init_rxbdtbl( fpd_host_t *phost, u32 host_chan );
extern int fpd_host_cleanup( fpd_host_t *phost );
extern int fpd_host_cleanup_rxbdtbl( fpd_host_t *phost, u32 host_chan );
extern int fpd_host_reset( fpd_host_t *phost, int host_chan );
extern int fpd_host_config( fpd_host_t *phost, int host_chan, u8 function, int dma_size, int rxlen );
extern int fpd_host_check_events( fpd_host_t *phost, int host_chan );
extern int fpd_host_get_rxbdtbl( fpd_host_t *phost, int host_chan, FPD_hostrxbdtbl_t *pbdtbl );
extern int fpd_host_get_txbuf_info( fpd_host_t *phost, int host_chan, FPD_host_txbuf_info_t *pinfo );
extern int fpd_host_get_txbuffer( fpd_host_t *phost, FPD_hostbuf_t *pbuf );
extern int fpd_host_write( fpd_host_t *phost, int host_chan, int len, int buf_id );
extern int fpd_host_read( fpd_host_t *phost, FPD_hostdata_t *pbuf );
extern int fpd_host_read_complete( fpd_host_t *phost, int host_chan, FPD_host_rxparam_t *prxinfo );
extern int fpd_host_handle_txdone( fpd_host_t *phost, int dma_chan );
extern int fpd_host_handle_rx( fpd_host_t *phost, int host_chan );
extern int fpd_host_handle_rx_nobuf( fpd_host_t *phost, int host_chan );

#endif /* _FPD_HOST_H */
