/******************************************************************************
 *  MODULE:           FPGA PROTOCOL
 ******************************************************************************
 *
 *  FPGA Protocol Device Driver Register Definitions
 *
 *  FILE:             $Workfile$
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential
 * proprietary information distributed solely pursuant to a confidentiality
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2005-2006 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#ifndef _REGISTER_H_
#define _REGISTER_H_

#include "linux/version.h"

/*-------------------*/
/* Access Definition */
/*-------------------*/
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0)
#define FPD_READ(ba, offset)        (readl((unsigned long)ba + offset))
#define FPD_WRITE(ba, offset, val)  (writel(val, ((unsigned long)ba + offset)))

/* this may not be valid for other architectures */
#define FPD_READ_SWAP(ba, offset)   (*(volatile u32 *)((unsigned long)ba + offset))
#else
#define FPD_READ(ba, offset)        (readl(ba + offset))
#define FPD_WRITE(ba, offset, val)  (writel(val, (ba + offset)))

/* this may not be valid for other architectures */
#define FPD_READ_SWAP(ba, offset)   (*(volatile u32 *)(ba + offset))
#endif /* LINUX_VERSION_CODE */

#define swap32(x) \
({ \
        __u32 __x = (x); \
        ((__u32)( \
                (((__u32)(__x) & (__u32)0x000000ffUL) << 24) | \
                (((__u32)(__x) & (__u32)0x0000ff00UL) <<  8) | \
                (((__u32)(__x) & (__u32)0x00ff0000UL) >>  8) | \
                (((__u32)(__x) & (__u32)0xff000000UL) >> 24) )); \
})

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
/* Not defined anymore in linux/include/linux */
#define PCI_CLASS_CODE                          0x0b
#endif

/*-----------------------------------*/
/* On-chip Registers (32-bit access) */
/*-----------------------------------*/
#define FPD_GLOBAL_CONTROL                      0x00000000
#define FPD_VERSION                             0x00000004
#define FPD_INTERFACE_COUNT                     0x00000008
#define FPD_GLOBAL_INTERRUPT_STATUS             0x0000000C
#define FPD_EXPANDER_STATUS                     0x00000010
#define FPD_LINE_STATUS_INTERRUPT_01            0x00000014
#define FPD_LINE_STATUS_INTERRUPT_23            0x00000018
#define FPD_LINE_STATUS0                        0x0000001C
#define FPD_LINE_STATUS1                        0x00000020
#define FPD_LINE_STATUS2                        0x00000024
#define FPD_LINE_STATUS3                        0x00000028
#define FPD_VIDEO_SWITCH_CONTROL                0x0000002C
#define FPD_BGND_LINK_IF_BASE                   0x00000100
#define FPD_LINK_IF_BASE0                       0x00000180
#define FPD_LINK_IF_BASE1                       0x00000200
#define FPD_LINK_IF_BASE2                       0x00000280
#define FPD_LINK_IF_BASE3                       0x00000300
#define FPD_LINK_IF_BASE4                       0x00000380

#define FPD_LINK_IF_SET_SIZE                    0x00000080

/* Test board specific */
#define FPD_LED_CONTROL                         0x00000084

/*------------------------------------------*/
/* Link Interface Registers (32-bit access) */
/*------------------------------------------*/
#define LIF_LINK_CONTROL                        0x00000000
#define LIF_LINK_INTERRUPT_STATUS               0x00000004
#define LIF_CIM_BUFFER_STATUS                   0x00000008
#define LIF_RX_CIM_BUFFER_DATA                  0x0000000C
#define LIF_TX_CIM_BUFFER_DATA                  0x00000010
#define LIF_TX_CIM_BUFFER_EOP                   0x00000014
#define LIF_PRIORITY_BUFFER_STATUS              0x00000018
#define LIF_RX_PRIORITY_BUFFER_DATA             0x0000001C
#define LIF_TX_PRIORITY_BUFFER_DATA             0x00000020
#define LIF_TX_PRIORITY_BUFFER_EOP              0x00000024
#define LIF_DMA_TX_CONTROL_DEV0                 0x00000028
#define LIF_DMA_TX_ADDRESS_DEV0                 0x0000002C
#define LIF_DMA_TX_STATUS_DEV0                  0x00000030
#define LIF_DMA_TX_CONTROL_DEV1                 0x00000034
#define LIF_DMA_TX_ADDRESS_DEV1                 0x00000038
#define LIF_DMA_TX_STATUS_DEV1                  0x0000003C
#define LIF_DMA_RX_CONTROL_DEV0                 0x00000040
#define LIF_DMA_RX_BD_TABLE_BASE_DEV0           0x00000044
#define LIF_DMA_RX_CONTROL_DEV1                 0x00000048
#define LIF_DMA_RX_BD_TABLE_BASE_DEV1           0x0000004C
#define LIF_PARAGON_LOOKUP_TABLE                0x00000050
#define LIF_ECHO_REQ_RESPONSE                   0x00000054
#define LIF_VSC_CONTROL                         0x00000058
#define LIF_RX_STATISTICS1                      0x00000070
#define LIF_RX_STATISTICS2                      0x00000074
#define LIF_TX_STATISTICS                       0x00000078
#define LIF_RX_INVALID_COMMAND                  0x0000007C

/*-----------------------------------------*/
/* Global Control Register Bit Definitions */
/*-----------------------------------------*/
#define GCR_DMA_BURST_SIZE                      0x00000003
#define GCR_GIE                                 0x00000004
#define GCR_LINE_STATUS_CHG_INT_EN              0x00000008
#define GCR_PCI_ERR_INT_EN                      0x00000010
#define GCR_EXP_INT_EN                          0x00000020
#define GCR_LOOPBACK                            0x00000040
#define GCR_LINK0_MODE                          0x00000080
#define GCR_TX_TIMEOUT                          0x00000F00

/* DMA burst size in words */
#define DMA_BURST_SIZE_8                        0
#define DMA_BURST_SIZE_16                       1
#define DMA_BURST_SIZE_32                       2
#define DMA_BURST_SIZE_64                       3

/*----------------------------------*/
/* Version Register Bit Definitions */
/*----------------------------------*/
#define FVR_PROTOCOL_SUB_VER                    0x0000000F
#define FVR_PROTOCOL_VER                        0x000000F0
#define FVR_FPGA_SUB_VER                        0x0000FF00
#define FVR_FPGA_VER                            0x000F0000

/*------------------------------------------*/
/* Interface Count Register Bit Definitions */
/*------------------------------------------*/
#define ICR_LINE_CNT                            0x0000007F
#define ICR_LINK_IF_CNT                         0x00000780
#define ICR_BGND_LINK_IF                        0x00000800
#define ICR_HOST_CHAN_CNT                       0x00007000

/*--------------------------------------------------*/
/* Global Interrupt Status Register Bit Definitions */
/*--------------------------------------------------*/
#define GISR_BG_LINK_IF                         0x00000001
#define GISR_LINK_IF_0                          0x00000002
#define GISR_LINK_IF_1                          0x00000004
#define GISR_LINK_IF_2                          0x00000008
#define GISR_LINK_IF_3                          0x00000010
#define GISR_LINK_IF_4                          0x00000020
#define GISR_LINE_STATUS_INT01                  0x00008000
#define GISR_LINE_STATUS_INT23                  0x00010000
#define GISR_PCI_ERR                            0x00020000
#define GISR_EXP_STAT_INT                       0x00040000
#define GISR_LINE_STATUS_CHANGE                 0x00018000

/*------------------------------------------*/
/* Expander Status Register Bit Definitions */
/*------------------------------------------*/
#define ESR_EXP_RDY                             0x00000001
#define ESR_SYNC_ERR_INT                        0x00000002

/*-----------------------------------------------*/
/* Video Switch Control Register Bit Definitions */
/*-----------------------------------------------*/
#define VSR_VS_DATA                             0x000000FF
#define VSR_VS_WRITESEL0                        0x00000100
#define VSR_VS_WRITESEL1                        0x00000200
#define VSR_VS_WRITESEL2                        0x00000400
#define VSR_VS_WRITESEL3                        0x00000800
#define VSR_VS_WRITESEL_ALL                     0x00000F00
#define VSR_VS_WRITE                            0x00001000
#define VSR_VS_CHIPSEL0                         0x00010000
#define VSR_VS_CHIPSEL1                         0x00020000
#define VSR_VS_CHIPSEL2                         0x00040000
#define VSR_VS_CHIPSEL3                         0x00080000
#define VSR_VS_CHIPSEL_ALL                      0x000F0000
#define VSR_VS_RST_EXP                          0x00100000
#define VSR_VS_RST_MAIN                         0x00200000
#define VSR_LV_ENABLE                           0x00800000
#define VSR_LV_SELECT                           0x03000000
#define VSR_LV_LINE                             0xFC000000

/* Local Video Output */
#define LV_PARAGON_CIM_VIDEO                    0x00000000
#define LV_VM_CIM_VIDEO                         0x01000000
#define LV_GRAPHIC_ENGINE_VIDEO                 0x02000000

/*---------------------------------------*/
/* Link Control Register Bit Definitions */
/*---------------------------------------*/
#define LIFCR_LINK_IF_RST                       0x00000001
#define LIFCR_HOST_BUF0_RST                     0x00000002
#define LIFCR_HOST_BUF1_RST                     0x00000004
#define LIFCR_TX_DMA_DONE_INT_EN_0              0x00000008
#define LIFCR_TX_DMA_DONE_INT_EN_1              0x00000010
#define LIFCR_RX_DMA_INT_EN_0                   0x00000020
#define LIFCR_RX_DMA_INT_EN_1                   0x00000040
#define LIFCR_TX_CIM_BUF_INT_EN                 0x00000080
#define LIFCR_RX_CIM_BUF_INT_EN                 0x00000100
#define LIFCR_TX_PRI_BUF_INT_EN                 0x00000200
#define LIFCR_RX_PRI_BUF_INT_EN                 0x00000400
#define LIFCR_TX_TIMEOUT_INT_EN                 0x00000800
#define LIFCR_BUF_SYNC_INT_EN                   0x00001000

#define LIFCR_RX_INV_CMD_INT_EN                 0x00002000
#define LIFCR_ECHO_RESP_INT_EN                  0x00004000
#define LIFCR_LINE_TO_IF                        0x001F8000
#define LIFCR_FORCE_CRC_ERR                     0x00200000
#define LIFCR_FORCE_PROT_ERR                    0x00400000
#define LIFCR_FORCE_INV_PKT_ERR                 0x00800000
#define LIFCR_DEBUG_MODE                        0x01000000
#define LIFCR_UPDATE_MODE                       0x02000000
#ifdef FPGA_VERSION_LESS_THAN_0_63
#define LIFCR_RX_PAR                            0x04000000
#define LIFCR_TX_PAR                            0x08000000
#define LIFCR_IGNORE_RX_PAR                     0x10000000
#define LIFCR_PROTOCOL                          0x80000000
#else
#define LIFCR_CHG_MODE_NOW                      0x04000000
#define LIFCR_RX_PAR                            0x08000000
#define LIFCR_TX_PAR                            0x10000000
#define LIFCR_IGNORE_RX_PAR                     0x20000000
#define LIFCR_PROTOCOL                          0x80000000
#endif

/*------------------------------------------------*/
/* Link Interrupt Status Register Bit Definitions */
/*------------------------------------------------*/
#define LIFISR_TX_DMA_DONE_0                    0x00000001
#define LIFISR_TX_DMA_DONE_1                    0x00000002
#define LIFISR_RX_DMA_NO_BUF_0                  0x00000004
#define LIFISR_RX_DMA_NO_BUF_1                  0x00000008
#define LIFISR_RX_DMA_BUF_FULL_0                0x00000010
#define LIFISR_RX_DMA_BUF_FULL_1                0x00000020
#define LIFISR_TX_CIM_BUF                       0x00000040
#define LIFISR_RX_CIM_BUF                       0x00000080
#define LIFISR_TX_PRI_BUF                       0x00000100
#define LIFISR_RX_PRI_BUF                       0x00000200
#define LIFISR_TX_HOST_TIMEOUT_0                0x00000400
#define LIFISR_TX_HOST_TIMEOUT_1                0x00000800
#define LIFISR_TX_CIM_TIMEOUT                   0x00001000
#define LIFISR_TX_PRI_TIMEOUT                   0x00002000
#define LIFISR_TX_CIM_WR_FULL_BUF               0x00004000
#define LIFISR_TX_CIM_NO_EOP                    0x00008000
#define LIFISR_TX_CIM_SYNC_ERR                  0x00010000
#define LIFISR_RX_CIM_RD_EMPTY_BUF              0x00020000
#define LIFISR_TX_PRI_WR_FULL_BUF               0x00040000
#define LIFISR_TX_PRI_NO_EOP                    0x00080000
#define LIFISR_TX_PRI_SYNC_ERR                  0x00100000
#define LIFISR_RX_PRI_RD_EMPTY_BUF              0x00200000
#define LIFISR_RX_INV_CMD                       0x00400000
#define LIFISR_ECHO_RESP_INT                    0x00800000
#define LIFISR_UPDATE_INV_PKT                   0x01000000

/*-----------------------------------------------------------*/
/* Link Interface CIM Buffer Status Register Bit Definitions */
/*-----------------------------------------------------------*/
#define LIFCBSR_RX_SOP                          0x00000001
#define LIFCBSR_RX_PKT_AVAIL                    0x00000002
#define LIFCBSR_RX_EMPTY                        0x00000004
#define LIFCBSR_RX_PKT_CNT                      0x00001FF8
#define LIFCBSR_TX_BYTE_AVAIL                   0x007FE000

/*--------------------------------------------------------*/
/* Link Interface DMA TX Control Register Bit Definitions */
/*--------------------------------------------------------*/
#define LIFDTCR_BYTE_CNT                        0x0001FFFF
#define LIFDTCR_PKT_SIZE                        0x02000000
#define LIFDTCR_DMA_START                       0x80000000

/*--------------------------------------------------------*/
/* Link Interface DMA RX Control Register Bit Definitions */
/*--------------------------------------------------------*/
#define LIFDRCR_BD_TABLE_SIZE                   0x000001FF
#define LIFDRCR_DMA_SUSPEND                     0x40000000
#define LIFDRCR_DMA_START                       0x80000000

/*--------------------------------------------------------*/
/* Link Interface Lookup Table Register Bit Definitions   */
/*--------------------------------------------------------*/
#define LIFLTR_PCMD_BYTE_CNT                    0x000000FF
#define LIFLTR_PCMD_VAL                         0x00000100
#define LIFLTR_PCMD_W_CHKSUM                    0x00000200
#define LIFLTR_PCMD_CNT_IN_RAM                  0x00000400
#define LIFLTR_PCMD_DEST                        0x00000800
#define LIFLTR_PCMD_BYTE                        0x00FF0000
#define LIFLTR_WRITE_ENTRY                      0x80000000

/*---------------------------------------------------------*/
/* Link Interface RX Statistics 1 Register Bit Definitions */
/*---------------------------------------------------------*/
#define LIFRS1_RX_INV_PKT_CNT                   0x000000FF
#define LIFRS1_RX_CRC_ERR_CNT                   0x0000FF00
#define LIFRS1_RX_PROT_ERR_CNT                  0x00FF0000
#define LIFRS1_RX_BUF_FULL_CNT                  0xFF000000

/*---------------------------------------------------------*/
/* Link Interface RX Statistics 2 Register Bit Definitions */
/*---------------------------------------------------------*/
#define LIFRS2_NOISE_CNT                        0x000000FF
#define LIFRS2_RX_TIMEOUT_CNT                   0x0000FF00
#define LIFRS2_RX_SEQ_ERR_CNT                   0x00FF0000
#define LIFRS2_RX_PAR_ERR_CNT                   0xFF000000

/*-------------------------------------------------------*/
/* Link Interface TX Statistics Register Bit Definitions */
/*-------------------------------------------------------*/
#define LIFTS_TX_CRC_ERR_CNT                   0x000000FF
#define LIFTS_TX_PROT_ERR_CNT                  0x0000FF00
#define LIFTS_TX_BUF_FULL_CNT                  0x00FF0000
#define LIFTS_MAX_RETRY                        0x0F000000

/*-------------------------------------------------------*/
/* Link IF RX Invalid Command Register Bit Definitions   */
/*-------------------------------------------------------*/
#define LIFRICR_RX_INV_CMD_CNT                 0x000000FF
#define LIFRICR_RX_LAST_INV_CMD                0x0000FF00

/*-------------------------------------------------------*/
/* Link IF VSC Control Register Bit Definitions          */
/*-------------------------------------------------------*/
#define LIFVCR_VSYNC_INV                       0x00000001
#define LIFVCR_HSYNC_INV                       0x00000002
#define LIFVCR_LOCAL_ENABLE                    0x08000000
#define LIFVCR_VSC_SELECT                      0x70000000
#define LIFVCR_VSC_ENABLE                      0x80000000

#endif /* _REGISTER_H_ */
