#ifndef __PP_I2C_H
#define __PP_I2C_H

/* global constants */
#define I2C_ASICS_NO_ADAPTERS	8
#if defined (PP_FEAT_KIRA_USE_I2C6)
#define I2C_FARADAY_NO_ADAPTERS 6
#else
#define I2C_FARADAY_NO_ADAPTERS	5
#endif
#define I2C_IBM_IIC_NO_ADAPTERS	1

#define I2C_OWN_ADDRESS		0x55
#define I2C_KME_ADDRESS		0x56
#define I2C_IPMI_ADDRESS	0x10
#define I2C_ADC_ADDRESS		0x4C
#define I2C_DDC_ADDRESS		0x00	/* slave-only */
#define I2C_FP_LED_ADDRESS      0x20
#define I2C_FP_BUS_ADDRESS      0x22
#define I2C_FP_LCD_ADDRESS      0x24
#define I2C_PCI_ADC_ADDRESS	0x48
#define I2C_KTST_LCD_DATA_ADDRESS	0x22
#define I2C_KTST_LCD_CMD_ADDRESS	0x23
#define I2C_IPMB_TEST_ADDRESS   0x55

#define I2C_DEVICE_MAJOR	((u8)245)

#define I2C_KME_MINOR		((u8)0)
#define I2C_IPMI_MINOR		((u8)1)
#define I2C_ADC_MINOR		((u8)2)
#define I2C_DDC_MINOR		((u8)3)
#define I2C_FP_LED_MINOR	((u8)4)
#define I2C_FP_LCD_MINOR	((u8)5)
#define I2C_FP_BUS_MINOR	((u8)6)

#define I2C_ASICS_FIRST_MINOR	((u8)7)
#define I2C_ASICS_LAST_MINOR	((u8)I2C_ASICS_FIRST_MINOR + I2C_ASICS_NO_ADAPTERS - 1)

#define I2C_IBM_IIC_FIRST_MINOR	((u8)15)
#define I2C_IBM_IIC_LAST_MINOR	((u8)I2C_IBM_IIC_FIRST_MINOR + I2C_IBM_IIC_NO_ADAPTERS - 1)

#define I2C_FARADAY_FIRST_MINOR	((u8)16)
#define I2C_FARADAY_LAST_MINOR	((u8)I2C_FARADAY_FIRST_MINOR + I2C_FARADAY_NO_ADAPTERS - 1)

#define I2C_KTST_LCD_DATA_MINOR	((u8)21)
#define I2C_KTST_LCD_CMD_MINOR	((u8)22)
#define I2C_PCI_ADC_MINOR	((u8)23)

#define I2C_IPMB_TEST_MINOR     ((u8)24)


#define IOCTL_I2C_IPMB_EVALBOARD_TEST 0x0750  /* special test on ASMI eval boards */


#ifdef __KERNEL__

/* plugin structure */
struct i2c_device_plugin {
	char name[20];			/* device name */
	
	u8 minor;			/* device minor number */
	u16 address;			/* device i2c address */
	int initialized;		/* flag if initialized */
	struct file_operations * fops;	/* file operations */
	
	int (*init_func)(struct i2c_device_plugin *);		/* init function */
	void (*cleanup_func)(struct i2c_device_plugin *);	/* cleanup function */
};

/* global structures */
extern struct i2c_client_address_data addr_data;

#endif /* __KERNEL__ */

#endif /* __PP_I2C_H */

