/**
 * lpc_kcs.h
 *
 * KIRA100 LPC (slave) driver for Keyboard Controller Style protocol
 *
 * (c) 2004 Peppercon AG, Ralf Guenther <rgue@peppercon.de>
 */

#ifndef __LPC_KCS_H__
#define __LPC_KCS_H__

#include "lpc_core.h"

int kcs_init(lpc_t *lpc, int chan, uint16_t host_io_base, wait_queue_head_t *wait, void **pkcs_data);
int kcs_cleanup(void *kcs_data);

int kcs_start(void *kcs_data);
int kcs_stop(void *kcs_data);

int kcs_read(void *kcs_data, uint8_t *buf, int size);
int kcs_write(void *kcs_data, const uint8_t *buf, int size);

int kcs_can_read(void *kcs_data);
int kcs_can_write(void *kcs_data);

int kcs_host_atn(void *kcs_data, int set);

int kcs_event(void *kcs_data);

#endif /* !__LPC_KCS_H__ */
