#ifndef _NV_PMU_ACCESS_H_
#define _NV_PMU_ACCESS_H_

/* Opcodes */
#define NV_CFG_PARA_WR                       0x02
#define NV_CFG_PARA_RD                       0x42
#define NV_MAC_ADDR_WR                       0x03
#define NV_MAC_ADDR_RD                       0x83
#define NV_IP_ADDR_WR                        0x04
#define NV_IP_ADDR_RD                        0x84
#define NV_ETH_FRM_WR                        0x08
#define NV_ETH_FRM_RD                        0x88
#define NV_MAC_FILTER1_WR                    0x05
#define NV_MAC_FILTER2_WR                    0x15
#define NV_MAC_FILTER3_WR                    0x25
#define NV_MAC_FILTER4_WR                    0x35
#define NV_ETH_ABORT                         0x87
#define NV_SYS_REG_RD                        0x46
#define NV_SYS_REG_WR                        0x06
 
/* PMU configuration register offsets */
#define NV_CFG_PARA_IAR                      0x00 /* I2C Address */
#define NV_CFG_PARA_ICR                      0x01 /* I2C Configuration */
#define NV_CFG_PARA_MCR                      0x02 /* MAC Configuration */
#define NV_CFG_PARA_MSR                      0x03 /* MAC Select */
#define NV_CFG_PARA_MFR                      0x04 /* MAC Features */
#define NV_CFG_PARA_FCR                      0x05 /* Filter Control */
#define NV_CFG_PARA_FSR                      0x06 /* Fragment Size */
#define NV_CFG_PARA_TCR                      0x07 /* TX Control */
#define NV_CFG_PARA_AMR                      0x08 /* Alert Mask */
#define NV_CFG_PARA_IMR                      0x09 /* Internal Alert Mask */
#define NV_CFG_PARA_ASR                      0x0a /* Alert Status */
#define NV_CFG_PARA_ISR                      0x0b /* Internal Alert Status */
#define NV_CFG_PARA_TSR                      0x0c /* TX Status */

/* I2C configuration register (ICR) */
#define NV_ICR_I2C_GC_EN			0x01
#define NV_ICR_SMP_ARP_EN			0x02
#define NV_ICR_SMB_ARA_EN			0x04

/* MAC configuration register (MCR) */
#define NV_MCR_MAC0_AUTO_SWITCH			0x01
#define NV_MCR_MAC1_AUTO_SWITCH			0x02
#define NV_MCR_MAC2_AUTO_SWITCH			0x04
#define NV_MCR_MAC3_AUTO_SWITCH			0x08

/* MAC features register (MFR) */
/* [1:0] Reserved */
#define NV_MFR_PING_RESPONSE_EN			0x04
#define NV_MFR_IP_ARP_EN			0x08

/* MAC select register (MSR) */
#define NV_MSR_MAC_SELECT_SHIFT			0
#define NV_MSR_MAC_SELECT_MASK			(0x03 << NV_MSR_MAC_SELECT_SHIFT)
#define NV_MSR_MAC_SELECT(x)			((x) << NV_MSR_MAC_SELECT_SHIFT)
#define NV_MSR_MAC_COUNT_SHIFT			2
#define NV_MSR_MAC_COUNT_MASK			(0x03 << NV_MSR_MAC_COUNT_SHIFT)
#define NV_MSR_MAC_COUNT(x)			((x) << NV_MSR_MAC_COUNT_SHIFT)
#define NV_MSR_MAC0_LINK			0x10
#define NV_MSR_MAC1_LINK			0x20
#define NV_MSR_MAC2_LINK			0x30
#define NV_MSR_MAC3_LINK			0x40

/* Filter Control register */
#define NV_FCR_MAC_RX_CF1			0x01
#define NV_FCR_MAC_RX_CF2			0x02
#define NV_FCR_MAC_RX_CF3			0x04
#define NV_FCR_MAC_RX_CF4			0x08
/* [5:4] Reserved */
#define NV_FCR_MAC_RX_EN			0x40

/* Alert mask (AMR) and status (ASR) bits */
#define NV_ALERT_MAC_RX_READY			0x01
#define NV_ALERT_MAC_TX_COMPLETE		0x02
#define NV_ALERT_MAC_TX_ERROR			0x04
#define NV_ALERT_LINK_STATUS			0x08
#define NV_ALERT_WATCHDOG_RESET			0x10
#define NV_ALERT_NVRAM_ERROR			0x20
#define NV_ALERT_INT_ALERT			0x40

/* TX status register */
#define NV_TSR_MAC_TX_STATUS_SHIFT		0
#define NV_TSR_MAC_TX_STATUS_MASK		(0x0F << NV_TSR_MAC_TX_STATUS_SHIFT)
#define NV_TSR_MAC_TX_STATUS_SUCCESS		0x00
#define NV_TSR_MAC_TX_STATUS_DROPPED		0x01
#define NV_TSR_MAC_TX_STATUS_COLLISION		0x02
#define NV_TSR_MAC_TX_STATUS_CARRIER		0x04
#define NV_TSR_MAC_TX_STATUS_DEFERRAL		0x08
#define NV_TSR_MAC_TX_PENDING			0x10

/* Internal alert mask (IMR) and status (ISR) bits */
#define NV_INT_ALERT_CHIP_THERM_CRITICAL	0x01
#define NV_INT_ALERT_CHIP_THERM_EXCESSIVE	0x02
#define NV_INT_ALERT_OS_HANG			0x04
#define NV_INT_ALERT_BOOT_ERROR			0x08
#define NV_INT_ALERT_OS_BOOT			0x10

/* Bits to OR into NV_ETH_FRM_WR */
#define NV_ETH_FRM_WR_BITMASK			0xc0
#define NV_ETH_FRM_WR_MF			0x00
#define NV_ETH_FRM_WR_LF			0x10
#define NV_ETH_FRM_WR_FF			0x20

/* Status from NV_ETH_FRM_RD status byte */
#define NV_ETH_FRM_RD_STS_PASS_FILTER_0		0x01
#define NV_ETH_FRM_RD_STS_PASS_FILTER_1		0x02
#define NV_ETH_FRM_RD_STS_PASS_FILTER_2		0x04
#define NV_ETH_FRM_RD_STS_PASS_FILTER_3		0x08
#define NV_ETH_FRM_RD_STS_STATUS_CHANGE		0x10
#define NV_ETH_FRM_RD_STS_MAC_RX_READY		0x20
#define NV_ETH_FRM_RD_STS_FIRST_FRAGMENT	0x40
#define NV_ETH_FRM_RD_STS_LAST_FRAGMENT		0x80

#endif /* _NV_PMU_ACCESS_H_ */
